/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UnchokerUtil {
    public static boolean isUnchokable(PEPeerTransport peer, boolean allow_snubbed) {
        return peer.getPeerState() == 30 && !peer.isSeed() && peer.isInterested() && (!peer.isSnubbed() || allow_snubbed);
    }

    public static void updateLargestValueFirstSort(long new_value, long[] values, PEPeerTransport new_item, ArrayList items, int start_pos) {
        items.ensureCapacity(values.length);
        for (int i = start_pos; i < values.length; ++i) {
            if (new_value < values[i]) continue;
            for (int j = values.length - 2; j >= i; --j) {
                values[j + 1] = values[j];
            }
            if (items.size() == values.length) {
                items.remove(values.length - 1);
            }
            values[i] = new_value;
            items.add(i, new_item);
            return;
        }
    }

    public static PEPeerTransport getNextOptimisticPeer(ArrayList all_peers, boolean factor_reciprocated, boolean allow_snubbed) {
        PEPeerTransport peer;
        int i;
        ArrayList<PEPeerTransport> optimistics = new ArrayList<PEPeerTransport>();
        for (i = 0; i < all_peers.size(); ++i) {
            peer = (PEPeerTransport)all_peers.get(i);
            if (!UnchokerUtil.isUnchokable(peer, false) || !peer.isChokedByMe()) continue;
            optimistics.add(peer);
        }
        if (optimistics.isEmpty() && allow_snubbed) {
            for (i = 0; i < all_peers.size(); ++i) {
                peer = (PEPeerTransport)all_peers.get(i);
                if (!UnchokerUtil.isUnchokable(peer, true) || !peer.isChokedByMe()) continue;
                optimistics.add(peer);
            }
        }
        if (optimistics.isEmpty()) {
            return null;
        }
        if (factor_reciprocated) {
            ArrayList ratioed_peers = new ArrayList(optimistics.size());
            long[] ratios = new long[optimistics.size()];
            Arrays.fill(ratios, Long.MIN_VALUE);
            for (int i2 = 0; i2 < optimistics.size(); ++i2) {
                PEPeerTransport peer2 = (PEPeerTransport)optimistics.get(i2);
                long score = peer2.getStats().getTotalDataBytesSent() - peer2.getStats().getTotalDataBytesReceived();
                UnchokerUtil.updateLargestValueFirstSort(score, ratios, peer2, ratioed_peers, 0);
            }
            double factor = 1.0 / (0.8 + 0.2 * Math.pow(RandomUtils.nextFloat(), -1.0));
            int pos = (int)(factor * (double)ratioed_peers.size());
            return (PEPeerTransport)ratioed_peers.get(pos);
        }
        int rand_pos = new Random().nextInt(optimistics.size());
        peer = (PEPeerTransport)optimistics.get(rand_pos);
        return peer;
    }

    public static void performChokes(ArrayList peers_to_choke, ArrayList peers_to_unchoke) {
        PEPeerTransport peer;
        int i;
        if (peers_to_choke != null) {
            for (i = 0; i < peers_to_choke.size(); ++i) {
                peer = (PEPeerTransport)peers_to_choke.get(i);
                if (peer.isChokedByMe()) continue;
                peer.sendChoke();
            }
        }
        if (peers_to_unchoke != null) {
            for (i = 0; i < peers_to_unchoke.size(); ++i) {
                peer = (PEPeerTransport)peers_to_unchoke.get(i);
                if (!peer.isChokedByMe()) continue;
                peer.sendUnChoke();
            }
        }
    }

    public static void performChokeUnchoke(PEPeerTransport to_choke, PEPeerTransport to_unchoke) {
        if (to_choke != null && !to_choke.isChokedByMe()) {
            to_choke.sendChoke();
        }
        if (to_unchoke != null && to_unchoke.isChokedByMe()) {
            to_unchoke.sendUnChoke();
        }
    }
}

