/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.stats;

import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class AzureusCoreStats {
    public static final String ST_ALL = ".*";
    public static final String ST_DISK = "disk.*";
    public static final String ST_DISK_READ_QUEUE_LENGTH = "disk.read.queue.length";
    public static final String ST_DISK_READ_QUEUE_BYTES = "disk.read.queue.bytes";
    public static final String ST_DISK_READ_REQUEST_COUNT = "disk.read.request.count";
    public static final String ST_DISK_READ_REQUEST_SINGLE = "disk.read.request.single";
    public static final String ST_DISK_READ_REQUEST_MULTIPLE = "disk.read.request.multiple";
    public static final String ST_DISK_READ_REQUEST_BLOCKS = "disk.read.request.blocks";
    public static final String ST_DISK_READ_BYTES_TOTAL = "disk.read.bytes.total";
    public static final String ST_DISK_READ_BYTES_SINGLE = "disk.read.bytes.single";
    public static final String ST_DISK_READ_BYTES_MULTIPLE = "disk.read.bytes.multiple";
    public static final String ST_DISK_READ_IO_TIME = "disk.read.io.time";
    public static final String ST_DISK_WRITE_QUEUE_LENGTH = "disk.write.queue.length";
    public static final String ST_DISK_WRITE_QUEUE_BYTES = "disk.write.queue.bytes";
    public static final String ST_DISK_WRITE_REQUEST_COUNT = "disk.write.request.count";
    public static final String ST_DISK_WRITE_REQUEST_BLOCKS = "disk.write.request.blocks";
    public static final String ST_DISK_WRITE_BYTES_TOTAL = "disk.write.bytes.total";
    public static final String ST_DISK_WRITE_BYTES_SINGLE = "disk.write.bytes.single";
    public static final String ST_DISK_WRITE_BYTES_MULTIPLE = "disk.write.bytes.multiple";
    public static final String ST_DISK_WRITE_IO_TIME = "disk.write.io.time";
    public static final String ST_NET_WRITE_CONTROL_WAIT_COUNT = "net.write.control.wait.count";
    public static final String ST_NET_WRITE_CONTROL_NP_COUNT = "net.write.control.np.count";
    public static final String ST_NET_WRITE_CONTROL_P_COUNT = "net.write.control.p.count";
    public static final String ST_NET_WRITE_CONTROL_ENTITY_COUNT = "net.write.control.entity.count";
    public static final String ST_NET_WRITE_CONTROL_CON_COUNT = "net.write.control.con.count";
    public static final String ST_NET_WRITE_CONTROL_READY_CON_COUNT = "net.write.control.ready.con.count";
    public static final String ST_NET_WRITE_CONTROL_READY_BYTE_COUNT = "net.write.control.ready.byte.count";
    public static final String ST_NET_READ_CONTROL_WAIT_COUNT = "net.read.control.wait.count";
    public static final String ST_NET_READ_CONTROL_ENTITY_COUNT = "net.read.control.entity.count";
    public static final String ST_NET_READ_CONTROL_CON_COUNT = "net.read.control.con.count";
    public static final String ST_NET_READ_CONTROL_READY_CON_COUNT = "net.read.control.ready.con.count";
    public static final String ST_NET_TCP_OUT_CONNECT_QUEUE_LENGTH = "net.tcp.outbound.connect.queue.length";
    public static final String ST_NET_TCP_OUT_PENDING_QUEUE_LENGTH = "net.tcp.outbound.pending.queue.length";
    public static final String ST_NET_TCP_OUT_CANCEL_QUEUE_LENGTH = "net.tcp.outbound.cancel.queue.length";
    public static final String ST_NET_TCP_OUT_CLOSE_QUEUE_LENGTH = "net.tcp.outbound.close.queue.length";
    public static final String ST_PEER_CONTROL_LOOP_COUNT = "peer.control.loop.count";
    public static final String ST_PEER_CONTROL_YIELD_COUNT = "peer.control.yield.count";
    public static final String ST_PEER_CONTROL_WAIT_COUNT = "peer.control.wait.count";
    public static final String ST_PEER_CONTROL_WAIT_TIME = "peer.control.wait.time";
    public static final String ST_PEER_MANAGER_COUNT = "peer.manager.count";
    public static final String ST_PEER_MANAGER_PEER_COUNT = "peer.manager.peer.count";
    public static final String ST_PEER_MANAGER_PEER_SNUBBED_COUNT = "peer.manager.peer.snubbed.count";
    public static final String ST_PEER_MANAGER_PEER_STALLED_DISK_COUNT = "peer.manager.peer.stalled.disk.count";
    private static final Integer POINT = new Integer(1);
    private static final Integer CUMULATIVE = new Integer(1);
    private static final Map stats_types = new HashMap();
    private static final Object[][] _ST_ALL = new Object[][]{{"disk.read.queue.length", POINT}, {"disk.read.queue.bytes", POINT}, {"disk.read.request.count", CUMULATIVE}, {"disk.read.request.single", CUMULATIVE}, {"disk.read.request.multiple", CUMULATIVE}, {"disk.read.request.blocks", CUMULATIVE}, {"disk.read.bytes.total", CUMULATIVE}, {"disk.read.bytes.single", CUMULATIVE}, {"disk.read.bytes.multiple", CUMULATIVE}, {"disk.read.io.time", CUMULATIVE}, {"disk.write.queue.length", POINT}, {"disk.write.queue.bytes", POINT}, {"disk.write.request.count", CUMULATIVE}, {"disk.write.request.blocks", CUMULATIVE}, {"disk.write.bytes.total", CUMULATIVE}, {"disk.write.bytes.single", CUMULATIVE}, {"disk.write.bytes.multiple", CUMULATIVE}, {"disk.write.io.time", CUMULATIVE}, {"net.write.control.wait.count", CUMULATIVE}, {"net.write.control.p.count", CUMULATIVE}, {"net.write.control.np.count", CUMULATIVE}, {"net.write.control.entity.count", POINT}, {"net.write.control.con.count", POINT}, {"net.write.control.ready.con.count", POINT}, {"net.write.control.ready.byte.count", POINT}, {"net.read.control.wait.count", CUMULATIVE}, {"net.read.control.entity.count", POINT}, {"net.read.control.con.count", POINT}, {"net.read.control.ready.con.count", POINT}, {"net.tcp.outbound.connect.queue.length", POINT}, {"net.tcp.outbound.pending.queue.length", POINT}, {"net.tcp.outbound.cancel.queue.length", POINT}, {"net.tcp.outbound.close.queue.length", POINT}, {"peer.control.loop.count", CUMULATIVE}, {"peer.control.yield.count", CUMULATIVE}, {"peer.control.wait.count", CUMULATIVE}, {"peer.control.wait.time", CUMULATIVE}, {"peer.manager.count", POINT}, {"peer.manager.peer.count", POINT}, {"peer.manager.peer.snubbed.count", POINT}, {"peer.manager.peer.stalled.disk.count", POINT}};
    private static final List providers;
    private static Map averages;
    private static boolean enable_averages;
    private static Timer average_timer;

    public static Map getStats(Set types) {
        HashSet<String> expanded = new HashSet<String>();
        Iterator<Object> it = types.iterator();
        while (it.hasNext()) {
            String type = (String)it.next();
            if (!type.endsWith("*")) {
                type = type + ST_ALL;
            }
            Pattern pattern = Pattern.compile(type);
            for (int i = 0; i < _ST_ALL.length; ++i) {
                String s = (String)_ST_ALL[i][0];
                if (!pattern.matcher(s).matches()) continue;
                expanded.add(s);
            }
        }
        Map result = AzureusCoreStats.getStatsSupport(expanded);
        Map ave = averages;
        if (ave != null) {
            it = result.keySet().iterator();
            HashMap<String, Long> ave_results = new HashMap<String, Long>();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object[] a_entry = (Object[])ave.get(key);
                if (a_entry == null) continue;
                Average average = (Average)a_entry[0];
                ave_results.put(key + ".average", new Long(average.getAverage()));
            }
            result.putAll(ave_results);
        }
        return result;
    }

    protected static Map getStatsSupport(Set types) {
        HashMap result = new HashMap();
        for (int i = 0; i < providers.size(); ++i) {
            Object[] provider_entry = (Object[])providers.get(i);
            HashMap provider_result = new HashMap();
            Set target_types = types == null ? (Set)provider_entry[0] : types;
            try {
                ((AzureusCoreStatsProvider)provider_entry[1]).updateStats(target_types, provider_result);
                Iterator pit = provider_result.entrySet().iterator();
                while (pit.hasNext()) {
                    Map.Entry pe = pit.next();
                    String key = (String)pe.getKey();
                    Object obj = pe.getValue();
                    if (obj instanceof Long) {
                        Long old = (Long)result.get(key);
                        if (old == null) {
                            result.put(key, obj);
                            continue;
                        }
                        long v = (Long)obj;
                        result.put(key, new Long(v + old));
                        continue;
                    }
                    result.put(key, obj);
                }
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(Set types, AzureusCoreStatsProvider provider) {
        List list = providers;
        synchronized (list) {
            providers.add(new Object[]{types, provider});
        }
    }

    public static synchronized void setEnableAverages(boolean enabled) {
        if (enabled == enable_averages) {
            return;
        }
        enable_averages = enabled;
        if (enabled) {
            if (average_timer == null) {
                average_timer = new Timer("AzureusCoreStats:average");
                averages = new HashMap();
                average_timer.addPeriodicEvent(1000L, new TimerEventPerformer(){
                    private Map ave = AzureusCoreStats.access$000();

                    public void perform(TimerEvent event2) {
                        Map stats = AzureusCoreStats.getStatsSupport(null);
                        Iterator it = stats.entrySet().iterator();
                        while (it.hasNext()) {
                            long last_value;
                            Average a;
                            Map.Entry entry = it.next();
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            if (!(value instanceof Long)) continue;
                            Object[] a_entry = (Object[])this.ave.get(key);
                            if (a_entry == null) {
                                a = Average.getInstance(1000, 10);
                                last_value = 0L;
                                a_entry = new Object[]{a, value};
                                this.ave.put(key, a_entry);
                            } else {
                                a = (Average)a_entry[0];
                                last_value = (Long)a_entry[1];
                            }
                            if (stats_types.get(key) == CUMULATIVE) {
                                a.addValue((Long)value - last_value);
                            } else {
                                a.addValue((Long)value);
                            }
                            a_entry[1] = value;
                        }
                    }
                });
            }
        } else if (average_timer != null) {
            average_timer.destroy();
            average_timer = null;
            averages = null;
        }
    }

    public static boolean getEnableAverages() {
        return enable_averages;
    }

    static /* synthetic */ Map access$000() {
        return averages;
    }

    static {
        for (int i = 0; i < _ST_ALL.length; ++i) {
            stats_types.put(_ST_ALL[i][0], _ST_ALL[i][1]);
        }
        providers = new ArrayList();
        averages = new HashMap();
    }
}

