/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.torrent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformTorrentMessenger;
import com.aelitis.azureus.core.torrent.MetaDataUpdateListener;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.json.JSONObject;
import org.json.JSONString;

public class PlatformTorrentUtils {
    private static final long RETRY_METADATA = 600000L;
    public static final boolean DEBUG_CACHING = System.getProperty("az3.debug.caching", "0").equals("1");
    private static final String TOR_AZ_PROP_MAP = "Content";
    private static final String TOR_AZ_PROP_HASH = "Content Hash";
    private static final String TOR_AZ_PROP_TITLE = "Title";
    private static final String TOR_AZ_PROP_DESCRIPTION = "Description";
    private static final String TOR_AZ_PROP_AUTHOR = "Author";
    private static final String TOR_AZ_PROP_PUBLISHER = "Publisher";
    private static final String TOR_AZ_PROP_URL = "URL";
    private static final String TOR_AZ_PROP_THUMBNAIL = "Thumbnail";
    private static final String TOR_AZ_PROP_QUALITY = "Quality";
    private static final String TOR_AZ_PROP_USER_RATING = "UserRating";
    private static final String TOR_AZ_PROP_LASTUPDATED = "Revision Date";
    private static final String TOR_AZ_PROP_CREATIONDATE = "Creation Date";
    private static final String TOR_AZ_PROP_METADATA_REFRESHON = "Refresh On";
    private static final String TOR_AZ_PROP_PROGRESSIVE = "Progressive";
    private static final String TOR_AZ_PROP_SPEED = "Speed Bps";
    private static final ArrayList metaDataListeners = new ArrayList();

    public static Map getContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return new HashMap();
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("azureus_properties");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("azureus_properties", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    static Map getTempContentMap(TOTorrent torrent) {
        HashMap mapContent;
        Object objExistingContentMap;
        if (torrent == null) {
            return new HashMap();
        }
        HashMap mapAZProps = torrent.getAdditionalMapProperty("attributes");
        if (mapAZProps == null) {
            mapAZProps = new HashMap();
            torrent.setAdditionalMapProperty("attributes", mapAZProps);
        }
        if ((objExistingContentMap = mapAZProps.get(TOR_AZ_PROP_MAP)) instanceof Map) {
            mapContent = (HashMap)objExistingContentMap;
        } else {
            mapContent = new HashMap();
            mapAZProps.put(TOR_AZ_PROP_MAP, mapContent);
        }
        return mapContent;
    }

    private static String getContentMapString(TOTorrent torrent, String key) {
        if (torrent == null) {
            return null;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static long getContentMapLong(TOTorrent torrent, String key, long def) {
        if (torrent == null) {
            return def;
        }
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(key);
        try {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            if (obj instanceof byte[]) {
                return Long.parseLong(new String((byte[])obj));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return def;
    }

    public static String getContentHash(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_HASH);
    }

    public static String getContentTitle(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_TITLE);
    }

    public static String getContentDescription(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_DESCRIPTION);
    }

    public static String getContentAuthor(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_AUTHOR);
    }

    public static String getContentPublisher(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_PUBLISHER);
    }

    public static String getContentURL(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_URL);
    }

    public static String getContentQuality(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapString(torrent, TOR_AZ_PROP_QUALITY);
    }

    private static void putOrRemove(Map map, String key, Object obj) {
        if (obj == null || obj.equals(null)) {
            map.remove(key);
        } else {
            map.put(key, obj);
        }
    }

    public static void setContentQuality(TOTorrent torrent, String sQualityID) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_QUALITY, sQualityID);
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static byte[] getContentThumbnail(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        Object obj = mapContent.get(TOR_AZ_PROP_THUMBNAIL);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public static void setContentThumbnail(TOTorrent torrent, byte[] thumbnail) {
        Map mapContent = PlatformTorrentUtils.getContentMap(torrent);
        PlatformTorrentUtils.putOrRemove(mapContent, TOR_AZ_PROP_THUMBNAIL, thumbnail);
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static void setUserRating(TOTorrent torrent, int rating) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        mapContent.put(TOR_AZ_PROP_USER_RATING, new Long(rating));
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static void removeUserRating(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        try {
            if (mapContent.remove(TOR_AZ_PROP_USER_RATING) != null) {
                TorrentUtils.writeToFile(torrent);
            }
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static int getUserRating(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        Long l = (Long)mapContent.get(TOR_AZ_PROP_USER_RATING);
        if (l == null) {
            return -1;
        }
        return l.intValue();
    }

    public static long getMetaDataRefreshOn(TOTorrent torrent) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        Long l = (Long)mapContent.get(TOR_AZ_PROP_METADATA_REFRESHON);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public static void setMetaDataRefreshOn(TOTorrent torrent, long refreshOn) {
        Map mapContent = PlatformTorrentUtils.getTempContentMap(torrent);
        mapContent.put(TOR_AZ_PROP_METADATA_REFRESHON, new Long(refreshOn));
        try {
            TorrentUtils.writeToFile(torrent);
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
    }

    public static boolean isContent(TOTorrent torrent) {
        boolean bContent;
        if (torrent == null) {
            return false;
        }
        boolean bl = bContent = PlatformTorrentUtils.getContentHash(torrent) != null;
        if (bContent) {
            return true;
        }
        try {
            URL announceURL = torrent.getAnnounceURL();
            if (announceURL == null) {
                return false;
            }
            String url = announceURL.toString().toLowerCase();
            return url.indexOf("tracker.aelitis.com") >= 0 || url.indexOf("azureusplatform.com") >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isContent(Torrent torrent) {
        if (torrent instanceof TorrentImpl) {
            return PlatformTorrentUtils.isContent(((TorrentImpl)torrent).getTorrent());
        }
        return false;
    }

    public static void updateMetaData(final TOTorrent torrent, long maxDelayMS) {
        if (!PlatformTorrentUtils.isContent(torrent)) {
            PlatformTorrentUtils.log("torrent " + new String(torrent.getName()) + " not az content");
            return;
        }
        try {
            if (DEBUG_CACHING) {
                PlatformTorrentUtils.log("updateMD");
            }
            final String hash = torrent.getHashWrapper().toBase32String();
            PlatformTorrentMessenger.getMetaData(new String[]{hash}, maxDelayMS, new PlatformTorrentMessenger.GetMetaDataReplyListener(){

                public void messageSent() {
                }

                public void replyReceived(String replyType, Map mapHashes) {
                    PlatformTorrentUtils.updateMetaData_handleReply(torrent, hash, replyType, mapHashes);
                }
            });
        }
        catch (TOTorrentException e) {
            e.printStackTrace();
        }
    }

    private static void updateMetaData_handleReply(final TOTorrent torrent, String hash, String replyType, Map mapHashes) {
        Map contentMap = PlatformTorrentUtils.getContentMap(torrent);
        if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
            if (DEBUG_CACHING) {
                PlatformTorrentUtils.log("Exception, retrying later");
            }
            SimpleTimer.addEvent("Update MD Retry", SystemTime.getCurrentTime() + 600000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    if (DEBUG_CACHING) {
                        PlatformTorrentUtils.log("retry time");
                    }
                    PlatformTorrentUtils.updateMetaData(torrent, 15000L);
                }
            });
        } else {
            JSONObject jsonMapMetaData = (JSONObject)mapHashes.get(hash);
            if (jsonMapMetaData != null) {
                long newLastUpdated;
                long diff;
                long oldLastUpdated = PlatformTorrentUtils.getContentLastUpdated(torrent);
                long expireyMins = 0L;
                Iterator iterator = jsonMapMetaData.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = jsonMapMetaData.get(key);
                    if (value == null || value.equals(null)) {
                        contentMap.remove(key);
                    } else if ((key.equals(TOR_AZ_PROP_THUMBNAIL) || key.endsWith(".B64")) && value instanceof String) {
                        contentMap.put(key, Base64.decode((String)value));
                    } else if (key.equals("expires-in-mins") && value instanceof Long) {
                        expireyMins = (Long)value;
                    } else if (!(value instanceof JSONString)) {
                        String s = jsonMapMetaData.getString(key);
                        contentMap.put(key, s);
                    } else {
                        System.out.println("BOO! " + key + ";" + value);
                    }
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                    try {
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        DownloadManager dm = gm.getDownloadManager(torrent);
                        String title = PlatformTorrentUtils.getContentTitle(torrent);
                        if (title != null && title.length() > 0 && dm.getDownloadState().getDisplayName() == null) {
                            dm.getDownloadState().setDisplayName(title);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    PlatformTorrentUtils.triggerMetaDataUpdateListeners(torrent);
                }
                long refreshOn = expireyMins > 0L ? SystemTime.getCurrentTime() + expireyMins * 60L * 1000L : ((diff = (newLastUpdated = PlatformTorrentUtils.getContentLastUpdated(torrent)) - oldLastUpdated) > 0L && oldLastUpdated != 0L ? SystemTime.getCurrentTime() + diff * 2L : SystemTime.getCurrentTime() + 604800000L);
                if (DEBUG_CACHING) {
                    PlatformTorrentUtils.log("got MD. Next refresh in " + (refreshOn - SystemTime.getCurrentTime()));
                }
                PlatformTorrentUtils.setMetaDataRefreshOn(torrent, refreshOn);
                SimpleTimer.addEvent("Update MD", refreshOn, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        PlatformTorrentUtils.updateMetaData(torrent, 15000L);
                    }
                });
            } else {
                long refreshOn = SystemTime.getCurrentTime() + 2592000000L;
                PlatformTorrentUtils.setMetaDataRefreshOn(torrent, refreshOn);
                if (DEBUG_CACHING) {
                    PlatformTorrentUtils.log("no hash in reply for " + torrent + ". Next refresh on " + new Date(refreshOn));
                }
            }
        }
    }

    public static void addListener(MetaDataUpdateListener l) {
        if (metaDataListeners.indexOf(l) < 0) {
            metaDataListeners.add(l);
        }
    }

    public static void removeListener(MetaDataUpdateListener l) {
        metaDataListeners.remove(l);
    }

    public static void triggerMetaDataUpdateListeners(TOTorrent torrent) {
        MetaDataUpdateListener[] listeners = metaDataListeners.toArray(new MetaDataUpdateListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            MetaDataUpdateListener listener = listeners[i];
            try {
                listener.metaDataUpdated(torrent);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public static long getContentLastUpdated(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_LASTUPDATED, 0L);
    }

    public static boolean isContentProgressive(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_PROGRESSIVE, 0L) == 1L;
    }

    public static long getContentSpeedBps(TOTorrent torrent) {
        return PlatformTorrentUtils.getContentMapLong(torrent, TOR_AZ_PROP_SPEED, 0L);
    }

    public static void log(String str) {
        if (DEBUG_CACHING) {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.MD");
            diag_logger.log(str);
            System.out.println(str);
        }
    }
}

