/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.versioncheck;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNLookup;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPCodecs;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPReply;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPRequest;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPReleasablePacketHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;

public class VersionCheckClient {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String REASON_UPDATE_CHECK_START = "us";
    public static final String REASON_UPDATE_CHECK_PERIODIC = "up";
    public static final String REASON_CHECK_SWT = "sw";
    public static final String REASON_DHT_EXTENDED_ALLOWED = "dx";
    public static final String REASON_DHT_ENABLE_ALLOWED = "de";
    public static final String REASON_EXTERNAL_IP = "ip";
    public static final String REASON_RECOMMENDED_PLUGINS = "rp";
    public static final String REASON_SECONDARY_CHECK = "sc";
    private static final String AZ_MSG_SERVER_ADDRESS = "version.aelitis.com";
    private static final int AZ_MSG_SERVER_PORT = 27001;
    private static final String MESSAGE_TYPE_ID = "AZVER";
    public static final String HTTP_SERVER_ADDRESS = "version.aelitis.com";
    public static final int HTTP_SERVER_PORT = 2080;
    public static final String TCP_SERVER_ADDRESS = "version.aelitis.com";
    public static final int TCP_SERVER_PORT = 2080;
    public static final String UDP_SERVER_ADDRESS = "version.aelitis.com";
    public static final int UDP_SERVER_PORT = 2080;
    private static final long CACHE_PERIOD = 300000L;
    private static boolean secondary_check_done;
    private static final VersionCheckClient instance;
    private Map last_check_data = null;
    private final AEMonitor check_mon = new AEMonitor("versioncheckclient");
    private long last_check_time = 0L;

    private VersionCheckClient() {
    }

    public static VersionCheckClient getSingleton() {
        return instance;
    }

    public Map getVersionCheckInfo(String reason) {
        return this.getVersionCheckInfoSupport(reason, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getVersionCheckInfoSupport(String reason, boolean only_if_cached, boolean force) {
        try {
            this.check_mon.enter();
            long time_diff = SystemTime.getCurrentTime() - this.last_check_time;
            boolean bl = force = force || time_diff > 300000L || time_diff < 0L;
            if (this.last_check_data == null || this.last_check_data.size() == 0 || force) {
                if (only_if_cached && this.last_check_data != null) {
                    HashMap hashMap = new HashMap();
                    return hashMap;
                }
                try {
                    this.last_check_data = this.performVersionCheck(this.constructVersionCheckMessage(reason), true, true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.last_check_data = new HashMap();
                }
            } else {
                Logger.log(new LogEvent(LOGID, "VersionCheckClient is using cached version check info. Using " + this.last_check_data.size() + " reply keys."));
            }
        }
        finally {
            this.check_mon.exit();
        }
        if (this.last_check_data == null) {
            this.last_check_data = new HashMap();
        }
        return this.last_check_data;
    }

    private boolean isVersionCheckDataValid() {
        return this.last_check_data != null && this.last_check_data.size() > 0;
    }

    public String getExternalIpAddress(boolean only_if_cached) {
        Map reply = this.getVersionCheckInfoSupport(REASON_EXTERNAL_IP, only_if_cached, false);
        byte[] address = (byte[])reply.get("source_ip_address");
        if (address != null) {
            return new String(address);
        }
        return null;
    }

    public boolean DHTEnableAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_ENABLE_ALLOWED);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid();
        }
        return res;
    }

    public boolean DHTExtendedUseAllowed() {
        Map reply = this.getVersionCheckInfo(REASON_DHT_EXTENDED_ALLOWED);
        boolean res = false;
        byte[] value = (byte[])reply.get("enable_dht_extended_use");
        if (value != null) {
            res = new String(value).equalsIgnoreCase("true");
        }
        if (!res) {
            res = !this.isVersionCheckDataValid();
        }
        return res;
    }

    public String[] getRecommendedPlugins() {
        Map reply = this.getVersionCheckInfo(REASON_RECOMMENDED_PLUGINS);
        List l = (List)reply.get("recommended_plugins");
        if (l == null) {
            return new String[0];
        }
        String[] res = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            res[i] = new String((byte[])l.get(i));
        }
        return res;
    }

    private Map performVersionCheck(Map data_to_send, boolean use_az_message, boolean use_http) throws Exception {
        Exception error = null;
        Map reply = null;
        if (use_az_message) {
            try {
                reply = this.executeAZMessage(data_to_send);
                reply.put("protocol_used", "AZMSG");
            }
            catch (Exception e) {
                error = e;
            }
        }
        if (reply == null && use_http) {
            try {
                reply = this.executeHTTP(data_to_send);
                reply.put("protocol_used", "HTTP");
                error = null;
            }
            catch (Exception e) {
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient server version check successful. Received " + reply.size() + " reply keys."));
        }
        this.last_check_time = SystemTime.getCurrentTime();
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeAZMessage(Map data_to_send) throws Exception {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from version.aelitis.com:27001"));
        }
        ClientMessageService msg_service = null;
        Map reply = null;
        try {
            msg_service = ClientMessageServiceClient.getServerService("version.aelitis.com", 27001, MESSAGE_TYPE_ID);
            msg_service.sendMessage(data_to_send);
            reply = msg_service.receiveMessage();
            this.preProcessReply(reply);
        }
        finally {
            if (msg_service != null) {
                msg_service.close();
            }
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map executeHTTP(Map data_to_send) throws Exception {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from version.aelitis.com:2080 via HTTP"));
        }
        String url_str = "http://version.aelitis.com:2080/version?";
        url_str = url_str + URLEncoder.encode(new String(BEncoder.encode(data_to_send), "ISO-8859-1"), "ISO-8859-1");
        URL url = new URL(url_str);
        HttpURLConnection url_connection = (HttpURLConnection)url.openConnection();
        url_connection.connect();
        try {
            InputStream is = url_connection.getInputStream();
            Map reply = BDecoder.decode(new BufferedInputStream(is));
            this.preProcessReply(reply);
            Map map = reply;
            return map;
        }
        finally {
            url_connection.disconnect();
        }
    }

    public String getHTTPGetString(boolean for_proxy) {
        return this.getHTTPGetString(new HashMap(), for_proxy);
    }

    private String getHTTPGetString(Map content, boolean for_proxy) {
        String get_str = "GET " + (for_proxy ? "http://version.aelitis.com:2080" : "") + "/version?";
        try {
            get_str = get_str + URLEncoder.encode(new String(BEncoder.encode(content), "ISO-8859-1"), "ISO-8859-1");
        }
        catch (Throwable e) {
            // empty catch block
        }
        get_str = get_str + " HTTP/1.1\r\n\r\n";
        return get_str;
    }

    private Map executeTCP(Map data_to_send, InetAddress bind_ip, int bind_port) throws Exception {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "VersionCheckClient retrieving version information from version.aelitis.com:2080 via TCP"));
        }
        String get_str = this.getHTTPGetString(data_to_send, false);
        Socket socket = null;
        try {
            int len;
            socket = new Socket();
            if (bind_ip != null) {
                socket.bind(new InetSocketAddress(bind_ip, bind_port));
            } else if (bind_port != 0) {
                socket.bind(new InetSocketAddress(bind_port));
            }
            socket.setSoTimeout(10000);
            socket.connect(new InetSocketAddress("version.aelitis.com", 2080), 10000);
            OutputStream os = socket.getOutputStream();
            os.write(get_str.getBytes("ISO-8859-1"));
            os.flush();
            InputStream is = socket.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int total_len = 0;
            while ((len = is.read(buffer)) > 0) {
                if ((total_len += len) > 16000) {
                    throw new IOException("reply too large");
                }
                baos.write(buffer, 0, len);
            }
            byte[] reply_bytes = baos.toByteArray();
            for (int i = 3; i < reply_bytes.length; ++i) {
                if (reply_bytes[i - 3] != 13 || reply_bytes[i - 2] != 10 || reply_bytes[i - 1] != 13 || reply_bytes[i - 0] != 10) continue;
                Map reply = BDecoder.decode(new BufferedInputStream(new ByteArrayInputStream(reply_bytes, i + 1, reply_bytes.length - (i + 1))));
                this.preProcessReply(reply);
                Map map = reply;
                return map;
            }
            throw new Exception("Invalid reply: " + new String(reply_bytes));
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private Map executeUDP(Map data_to_send, InetAddress bind_ip, int bind_port) throws Exception {
        PRUDPPacketHandler packet_handler;
        PRUDPReleasablePacketHandler handler;
        block7: {
            handler = PRUDPPacketHandlerFactory.getReleasableHandler(bind_port);
            packet_handler = handler.getHandler();
            long timeout = 5L;
            Random random = new Random();
            Exception last_error = null;
            packet_handler.setExplicitBindAddress(bind_ip);
            for (int i = 0; i < 3; ++i) {
                try {
                    long connection_id = Long.MIN_VALUE | random.nextLong();
                    VersionCheckClientUDPRequest request_packet = new VersionCheckClientUDPRequest(connection_id);
                    request_packet.setPayload(data_to_send);
                    VersionCheckClientUDPReply reply_packet = (VersionCheckClientUDPReply)packet_handler.sendAndReceive(null, request_packet, new InetSocketAddress("version.aelitis.com", 2080), timeout);
                    Map reply = reply_packet.getPayload();
                    this.preProcessReply(reply);
                    Map map = reply;
                    return map;
                }
                catch (Exception e) {
                    last_error = e;
                    timeout *= 2L;
                    continue;
                }
            }
            if (last_error == null) break block7;
            throw last_error;
        }
        throw new Exception("Timeout");
        finally {
            packet_handler.setExplicitBindAddress(null);
            handler.release();
        }
    }

    protected void preProcessReply(Map reply) {
        String done_asn;
        long advice;
        Long as_advice;
        String asn;
        long asn_check_time;
        long ASN_MIN_CHECK = 604800000L;
        boolean check_asn = false;
        long now = SystemTime.getCurrentTime();
        if (now < (asn_check_time = COConfigurationManager.getLongParameter("ASN Autocheck Performed Time")) || now - asn_check_time > 604800000L) {
            String bgp_prefix = COConfigurationManager.getStringParameter("ASN BGP", null);
            asn = COConfigurationManager.getStringParameter("ASN ASN", null);
            if (asn == null || asn.length() == 0 || bgp_prefix == null || bgp_prefix.length() == 0) {
                check_asn = true;
            } else {
                try {
                    byte[] address = (byte[])reply.get("source_ip_address");
                    InetAddress ip = InetAddress.getByName(new String(address));
                    if (!NetworkAdmin.getSingleton().matchesCIDR(bgp_prefix, ip)) {
                        check_asn = true;
                    }
                }
                catch (Throwable e) {
                    check_asn = true;
                    Debug.printStackTrace(e);
                }
            }
        }
        if (check_asn) {
            COConfigurationManager.setParameter("ASN Autocheck Performed Time", now);
            try {
                byte[] address = (byte[])reply.get("source_ip_address");
                InetAddress ip = InetAddress.getByName(new String(address));
                NetworkAdminASNLookup asn2 = NetworkAdmin.getSingleton().lookupASN(ip);
                COConfigurationManager.setParameter("ASN AS", asn2.getAS());
                COConfigurationManager.setParameter("ASN ASN", asn2.getASName());
                COConfigurationManager.setParameter("ASN BGP", asn2.getBGPPrefix());
                if (!secondary_check_done) {
                    secondary_check_done = true;
                    new AEThread("Secondary version check", true){

                        public void runSupport() {
                            VersionCheckClient.this.getVersionCheckInfoSupport(VersionCheckClient.REASON_SECONDARY_CHECK, false, true);
                        }
                    }.start();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if ((as_advice = (Long)reply.get("as_advice")) != null && (asn = COConfigurationManager.getStringParameter("ASN ASN", null)) != null && (advice = as_advice.longValue()) != 0L && !(done_asn = COConfigurationManager.getStringParameter("ASN Advice Followed", "")).equals(asn)) {
            boolean alert;
            COConfigurationManager.setParameter("ASN Advice Followed", asn);
            boolean change = advice == 1L || advice == 2L;
            boolean bl = alert = advice == 1L || advice == 3L;
            if (!COConfigurationManager.getBooleanParameter("network.transport.encrypted.require")) {
                if (change) {
                    COConfigurationManager.setParameter("network.transport.encrypted.require", true);
                }
                if (alert) {
                    String msg = MessageText.getString("crypto.alert.as.warning", new String[]{asn});
                    Logger.log(new LogAlert(false, 1, msg));
                }
            }
        }
    }

    public InetAddress getExternalIpAddressHTTP() throws Exception {
        Map reply = this.executeHTTP(new HashMap());
        byte[] address = (byte[])reply.get("source_ip_address");
        return InetAddress.getByName(new String(address));
    }

    public InetAddress getExternalIpAddressTCP(InetAddress bind_ip, int bind_port) throws Exception {
        Map reply = this.executeTCP(new HashMap(), bind_ip, bind_port);
        byte[] address = (byte[])reply.get("source_ip_address");
        return InetAddress.getByName(new String(address));
    }

    public InetAddress getExternalIpAddressUDP(InetAddress bind_ip, int bind_port) throws Exception {
        Map reply = this.executeUDP(new HashMap(), bind_ip, bind_port);
        byte[] address = (byte[])reply.get("source_ip_address");
        return InetAddress.getByName(new String(address));
    }

    private Map constructVersionCheckMessage(String reason) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("appid", SystemProperties.getApplicationIdentifier());
        message.put("version", "2.5.0.4");
        String id = COConfigurationManager.getStringParameter("ID", null);
        boolean send_info = COConfigurationManager.getBooleanParameter("Send Version Info");
        int last_send_time = COConfigurationManager.getIntParameter("Send Version Info Last Time", -1);
        int current_send_time = (int)(SystemTime.getCurrentTime() / 1000L);
        COConfigurationManager.setParameter("Send Version Info Last Time", current_send_time);
        if (id != null && send_info) {
            String ui;
            String asn;
            String as;
            message.put("id", id);
            message.put("os", Constants.OSName);
            message.put("os_version", System.getProperty("os.version"));
            message.put("os_arch", System.getProperty("os.arch"));
            if (last_send_time != -1 && last_send_time < current_send_time) {
                message.put("tsl", new Long(current_send_time - last_send_time));
            }
            message.put("reason", reason);
            String java_version = System.getProperty("java.version");
            if (java_version == null) {
                java_version = "unknown";
            }
            message.put("java", java_version);
            String java_vendor = System.getProperty("java.vm.vendor");
            if (java_vendor == null) {
                java_vendor = "unknown";
            }
            message.put("javavendor", java_vendor);
            long max_mem = Runtime.getRuntime().maxMemory() / 0x100000L;
            message.put("javamx", new Long(max_mem));
            OverallStats stats = StatsFactory.getStats();
            if (stats != null) {
                long total_uptime = stats.getTotalUpTime();
                message.put("total_uptime", new Long(total_uptime));
            }
            if ((as = COConfigurationManager.getStringParameter("ASN AS", null)) != null) {
                if (as.startsWith("\"")) {
                    as = as.substring(1).trim();
                    COConfigurationManager.setParameter("ASN AS", as);
                }
                message.put("ip_as", as);
            }
            if ((asn = COConfigurationManager.getStringParameter("ASN ASN", null)) != null) {
                if (asn.length() > 64) {
                    asn = asn.substring(0, 64);
                }
                message.put("ip_asn", asn);
            }
            if ((ui = COConfigurationManager.getStringParameter("ui")).length() > 0) {
                message.put("ui", ui);
            }
            if (AzureusCoreFactory.isCoreAvailable()) {
                PluginInterface[] plugins = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaces();
                ArrayList<String> pids = new ArrayList<String>();
                for (int i = 0; i < plugins.length; ++i) {
                    String pid = plugins[i].getPluginID();
                    String info = plugins[i].getPluginconfig().getPluginStringParameter("plugin.info");
                    if ((info == null || info.length() <= 0) && (pid.startsWith("<") || pid.startsWith("azbp") || pid.startsWith("azupdater") || pid.startsWith("azplatform") || pids.contains(pid))) continue;
                    if (info != null && info.length() > 0) {
                        if (info.length() < 256) {
                            pid = pid + ":" + info;
                        } else {
                            Debug.out("Plugin '" + pid + "' reported excessive info string '" + info + "'");
                        }
                    }
                    pids.add(pid);
                }
                message.put("plugins", pids);
            }
        }
        try {
            Class<?> c = Class.forName("org.eclipse.swt.SWT");
            String swt_platform = (String)c.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
            message.put("swt_platform", swt_platform);
            if (send_info) {
                Integer swt_version = (Integer)c.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
                message.put("swt_version", new Long(swt_version.longValue()));
                c = Class.forName("org.gudy.azureus2.ui.swt.mainwindow.MainWindow");
                if (c != null) {
                    c.getMethod("addToVersionCheckMessage", Map.class).invoke(null, message);
                }
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError er) {
        }
        catch (InvocationTargetException err) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        boolean using_phe = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
        message.put("using_phe", using_phe ? new Long(1L) : new Long(0L));
        return message;
    }

    public static void main(String[] args) {
        try {
            COConfigurationManager.initialise();
            System.out.println("UDP:  " + VersionCheckClient.getSingleton().getExternalIpAddressUDP(null, 0));
            System.out.println("TCP:  " + VersionCheckClient.getSingleton().getExternalIpAddressTCP(null, 0));
            System.out.println("HTTP: " + VersionCheckClient.getSingleton().getExternalIpAddressHTTP());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        VersionCheckClientUDPCodecs.registerCodecs();
        instance = new VersionCheckClient();
    }
}

