/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.getright;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderGetRight
extends ExternalSeedReaderImpl {
    private static final int TARGET_REQUEST_SIZE_DEFAULT = 262144;
    private URL url;
    private String ip;
    private int port;
    private ExternalSeedHTTPDownloader http_downloader;
    private int piece_size;
    private int piece_group_size;

    protected ExternalSeedReaderGetRight(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url, Map _params) {
        super(_plugin, _torrent, _params);
        int target_request_size = this.getIntParam(_params, "req_size", 262144);
        this.url = _url;
        this.ip = this.url.getHost();
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        this.http_downloader = new ExternalSeedHTTPDownloader(this.url, this.getUserAgent());
        this.piece_size = (int)this.getTorrent().getPieceSize();
        this.piece_group_size = target_request_size / this.piece_size;
        if (this.piece_group_size == 0) {
            this.piece_group_size = 1;
        }
    }

    public boolean sameAs(ExternalSeedReader other) {
        if (other instanceof ExternalSeedReaderGetRight) {
            return this.url.toString().equals(((ExternalSeedReaderGetRight)other).url.toString());
        }
        return false;
    }

    public String getName() {
        return "GR: " + this.url;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return this.piece_group_size;
    }

    protected boolean getRequestCanSpanPieces() {
        return true;
    }

    protected void readData(ExternalSeedReaderRequest request2) throws ExternalSeedException {
        this.http_downloader.downloadRange(request2.getStartPieceNumber() * this.piece_size + request2.getStartPieceOffset(), request2.getLength(), request2, this.isTransient());
    }
}

