/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.webseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderRequest;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderWebSeed
extends ExternalSeedReaderImpl {
    private URL url;
    private String ip;
    private int port;
    private String url_prefix;
    private boolean supports_503;

    protected ExternalSeedReaderWebSeed(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url, Map _params) {
        super(_plugin, _torrent, _params);
        this.supports_503 = this.getBooleanParam(_params, "supports_503", true);
        this.url = _url;
        this.ip = this.url.getHost();
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        try {
            String hash_str = URLEncoder.encode(new String(_torrent.getHash(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.url_prefix = this.url.toString() + "?info_hash=" + hash_str;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean sameAs(ExternalSeedReader other) {
        if (other instanceof ExternalSeedReaderWebSeed) {
            return this.url.toString().equals(((ExternalSeedReaderWebSeed)other).url.toString());
        }
        return false;
    }

    public String getName() {
        return "WS: " + this.url;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return 1;
    }

    protected boolean getRequestCanSpanPieces() {
        return false;
    }

    protected void readData(ExternalSeedReaderRequest request2) throws ExternalSeedException {
        long piece = request2.getStartPieceNumber();
        long piece_start = request2.getStartPieceOffset();
        long piece_end = piece_start + (long)request2.getLength() - 1L;
        String str = this.url_prefix + "&piece=" + piece + "&ranges=" + piece_start + "-" + piece_end;
        this.setReconnectDelay(30000);
        try {
            ExternalSeedHTTPDownloader http_downloader = new ExternalSeedHTTPDownloader(new URL(str), this.getUserAgent());
            if (this.supports_503) {
                http_downloader.downloadSocket(request2.getLength(), request2, this.isTransient());
            } else {
                http_downloader.download(request2.getLength(), request2, this.isTransient());
            }
            if (http_downloader.getLastResponse() == 503) {
                Integer retry = new Integer(new String(http_downloader.getLast503ResponseData()));
                this.setReconnectDelay(retry * 1000);
                throw new ExternalSeedException("Server temporarily unavailable, retrying in " + retry);
            }
        }
        catch (MalformedURLException e) {
            throw new ExternalSeedException("URL encode fails", e);
        }
    }
}

