/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerException;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class MagnetPlugin
implements Plugin {
    private PluginInterface plugin_interface;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Magnet URI Handler");
        MenuItemListener listener = new MenuItemListener(){

            public void selected(MenuItem _menu, Object _target) {
                Download download = (Download)((TableRow)_target).getDataSource();
                if (download == null || download.getTorrent() == null) {
                    return;
                }
                Torrent torrent = download.getTorrent();
                String cb_data = "magnet:?xt=urn:btih:" + Base32.encode(torrent.getHash());
                try {
                    MagnetPlugin.this.plugin_interface.getUIManager().copyToClipBoard(cb_data);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        final TableContextMenuItem menu1 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu2 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "MagnetPlugin.contextmenu.exporturi");
        menu1.addListener(listener);
        menu2.addListener(listener);
        MagnetURIHandler.getSingleton().addListener(new MagnetURIHandlerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] badge() {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/magnet/Magnet.gif");
                if (is == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                    }
                    finally {
                        is.close();
                    }
                    return baos.toByteArray();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            public byte[] download(final MagnetURIHandlerProgressListener muh_listener, byte[] hash, InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
                try {
                    Torrent torrent;
                    Download dl = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(hash);
                    if (dl != null && (torrent = dl.getTorrent()) != null) {
                        return torrent.writeToBEncodedData();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                return MagnetPlugin.this.download(new MagnetPluginProgressListener(){

                    public void reportSize(long size) {
                        muh_listener.reportSize(size);
                    }

                    public void reportActivity(String str) {
                        muh_listener.reportActivity(str);
                    }

                    public void reportCompleteness(int percent) {
                        muh_listener.reportCompleteness(percent);
                    }
                }, hash, sources, timeout);
            }

            public boolean download(URL url) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(url, false);
                    return true;
                }
                catch (DownloadException e) {
                    throw new MagnetURIHandlerException("Operation failed", e);
                }
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread t = new AEThread("MagnetPlugin:init"){

                    public void runSupport() {
                        MagnetPlugin.this.plugin_interface.getDistributedDatabase();
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UISWTInstance swt = (UISWTInstance)instance;
                    Image image = swt.loadImage("com/aelitis/azureus/plugins/magnet/icons/magnet.gif");
                    menu1.setGraphic(swt.createGraphic(image));
                    menu2.setGraphic(swt.createGraphic(image));
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    public URL getMagnetURL(Download d) {
        Torrent torrent = d.getTorrent();
        if (torrent == null) {
            return null;
        }
        return this.getMagnetURL(torrent.getHash());
    }

    public URL getMagnetURL(byte[] hash) {
        try {
            return new URL("magnet:?xt=urn:btih:" + Base32.encode(hash));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public byte[] badge() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(final MagnetPluginProgressListener listener, byte[] hash, final InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
        try {
            listener.reportActivity(this.getMessageText("report.waiting_ddb"));
            final DistributedDatabase db = this.plugin_interface.getDistributedDatabase();
            final ArrayList potential_contacts = new ArrayList();
            final AESemaphore potential_contacts_sem = new AESemaphore("MagnetPlugin:liveones");
            final AEMonitor potential_contacts_mon = new AEMonitor("MagnetPlugin:liveones");
            final int[] outstanding = new int[]{0};
            listener.reportActivity(this.getMessageText("report.searching"));
            DistributedDatabaseListener ddb_listener = new DistributedDatabaseListener(){

                public void event(DistributedDatabaseEvent event2) {
                    int type = event2.getType();
                    if (type == 2) {
                        this.contactFound(event2.getValue().getContact());
                    } else if (type == 4 || type == 5) {
                        for (int i = 0; i < sources.length; ++i) {
                            try {
                                this.contactFound(db.importContact(sources[i]));
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        potential_contacts_sem.release();
                    }
                }

                public void contactFound(final DistributedDatabaseContact contact) {
                    listener.reportActivity(MagnetPlugin.this.getMessageText("report.found", contact.getName()));
                    outstanding[0] = outstanding[0] + 1;
                    AEThread t = new AEThread("MagnetPlugin:HitHandler"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            try {
                                boolean alive = contact.isAlive(20000L);
                                listener.reportActivity(MagnetPlugin.this.getMessageText(alive ? "report.alive" : "report.dead", contact.getName()));
                                try {
                                    potential_contacts_mon.enter();
                                    Object[] entry = new Object[]{new Boolean(alive), contact};
                                    boolean added = false;
                                    if (alive) {
                                        for (int i = 0; i < potential_contacts.size(); ++i) {
                                            if (((Boolean)((Object[])potential_contacts.get(i))[0]).booleanValue()) continue;
                                            potential_contacts.add(i, entry);
                                            added = true;
                                            break;
                                        }
                                    }
                                    if (!added) {
                                        potential_contacts.add(entry);
                                    }
                                    potential_contacts_sem.release();
                                }
                                finally {
                                    potential_contacts_mon.exit();
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    potential_contacts_mon.enter();
                                    int[] nArray = outstanding;
                                    nArray[0] = nArray[0] - 1;
                                }
                                finally {
                                    potential_contacts_mon.exit();
                                }
                                throw throwable;
                            }
                            try {
                                potential_contacts_mon.enter();
                                int[] nArray = outstanding;
                                nArray[0] = nArray[0] - 1;
                            }
                            finally {
                                potential_contacts_mon.exit();
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            };
            db.read(ddb_listener, db.createKey(hash, "Torrent download lookup for '" + ByteFormatter.encodeString(hash) + "'"), timeout, 3);
            long remaining = timeout;
            while (remaining > 0L) {
                DistributedDatabaseContact contact;
                boolean live_contact;
                long start = SystemTime.getCurrentTime();
                potential_contacts_sem.reserve(remaining);
                remaining -= SystemTime.getCurrentTime() - start;
                try {
                    potential_contacts_mon.enter();
                    if (potential_contacts.size() == 0) {
                        if (outstanding[0] != 0) continue;
                        break;
                    }
                    Object[] entry = (Object[])potential_contacts.remove(0);
                    live_contact = (Boolean)entry[0];
                    contact = (DistributedDatabaseContact)entry[1];
                }
                finally {
                    potential_contacts_mon.exit();
                    continue;
                }
                if (!live_contact) {
                    listener.reportActivity(this.getMessageText("report.tunnel", contact.getName()));
                    contact.openTunnel();
                }
                try {
                    listener.reportActivity(this.getMessageText("report.downloading", contact.getName()));
                    DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                        public void reportSize(long size) {
                            listener.reportSize(size);
                        }

                        public void reportActivity(String str) {
                            listener.reportActivity(str);
                        }

                        public void reportCompleteness(int percent) {
                            listener.reportCompleteness(percent);
                        }
                    }, db.getStandardTransferType(1), db.createKey(hash, "Torrent download content for '" + ByteFormatter.encodeString(hash) + "'"), timeout);
                    if (value == null) continue;
                    return (byte[])value.getValue([B.class);
                }
                catch (Throwable e) {
                    listener.reportActivity(this.getMessageText("report.error", Debug.getNestedExceptionMessage(e)));
                    Debug.printStackTrace(e);
                }
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            listener.reportActivity(this.getMessageText("report.error", Debug.getNestedExceptionMessage(e)));
            throw new MagnetURIHandlerException("MagnetURIHandler failed", e);
        }
    }

    protected String getMessageText(String resource) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource, new String[]{param});
    }
}

