/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;

public class UPnPMapping {
    public static final int PT_DEFAULT = 1;
    public static final int PT_PERSISTENT = 2;
    public static final int PT_TRANSIENT = 3;
    protected String resource_name;
    protected boolean tcp;
    protected int port;
    protected boolean enabled;
    protected int persistent = 1;
    protected List listeners = new ArrayList();

    protected UPnPMapping(String _resource_name, boolean _tcp, int _port, boolean _enabled) {
        this.resource_name = _resource_name;
        this.tcp = _tcp;
        this.port = _port;
        this.enabled = _enabled;
    }

    public void setPersistent(int _persistent) {
        this.persistent = _persistent;
    }

    public int getPersistent() {
        return this.persistent;
    }

    public boolean isTCP() {
        return this.tcp;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int _port) {
        if (this.port != _port) {
            this.port = _port;
            this.changed();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean _enabled) {
        if (this.enabled != _enabled) {
            this.enabled = _enabled;
            this.changed();
        }
    }

    public String getString() {
        return this.getString(this.getPort());
    }

    public String getString(int port) {
        String name = MessageText.keyExists(this.resource_name) ? MessageText.getString(this.resource_name) : this.resource_name;
        return name + " (" + (this.isTCP() ? "TCP" : "UDP") + "/" + port + ")";
    }

    public void destroy() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingListener)this.listeners.get(i)).mappingDestroyed(this);
        }
    }

    protected void changed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingListener)this.listeners.get(i)).mappingChanged(this);
        }
    }

    public void addListener(UPnPMappingListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPMappingListener l) {
        this.listeners.remove(l);
    }
}

