/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.skin;

import com.aelitis.azureus.ui.skin.SkinProperties;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;

public class SkinPropertiesImpl
implements SkinProperties {
    private static final LogIDs LOGID = LogIDs.UI3;
    private static final String PATH_SKIN_DEFS = "com/aelitis/azureus/ui/skin/";
    private static final String FILE_SKIN_DEFS = "skin3.properties";
    private static final String MESSAGES = "com.aelitis.azureus.ui.skin.messages3";
    private static final String LOCATION_SKIN = "skin/display.properties";
    private static final Pattern PAT_PARAM_ALPHA = Pattern.compile("\\{([^0-9].+?)\\}");
    private static final Pattern PAT_PARAM_NUM = Pattern.compile("\\{([0-9]+?)\\}");
    private Properties properties = new Properties();

    public SkinPropertiesImpl() {
        String sFiles;
        ClassLoader classLoader = SkinPropertiesImpl.class.getClassLoader();
        InputStream is = classLoader.getResourceAsStream("com/aelitis/azureus/ui/skin/skin3.properties");
        if (is != null) {
            try {
                this.properties.load(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Logger.log(new LogEvent(LOGID, "com/aelitis/azureus/ui/skin/skin3.properties not found"));
        }
        is = classLoader.getResourceAsStream(LOCATION_SKIN);
        if (is != null) {
            try {
                this.properties.load(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((sFiles = this.properties.getProperty("skin.include")) != null) {
            String[] sFilesArray = sFiles.split(",");
            for (int i = 0; i < sFilesArray.length; ++i) {
                String sFile = PATH_SKIN_DEFS + sFilesArray[i] + ".properties";
                try {
                    is = classLoader.getResourceAsStream(sFile);
                    if (is != null) {
                        this.properties.load(is);
                        continue;
                    }
                    System.err.println("No Skin " + sFile + " found");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        MessageText.integratePluginMessages(MESSAGES, this.getClass().getClassLoader());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    private String getValue(String name, String[] params) {
        String value = null;
        String osName = null;
        if (name == null) {
            return null;
        }
        if (Constants.isOSX) {
            osName = name + "._mac";
        } else if (Constants.isUnix) {
            osName = name + "._unix";
        } else if (Constants.isFreeBSD) {
            osName = name + "._freebsd";
        } else if (Constants.isLinux) {
            osName = name + "._linux";
        } else if (Constants.isSolaris) {
            osName = name + "._solaris";
        } else if (Constants.isWindows) {
            osName = name + "._windows";
        }
        if (osName != null) {
            value = this.properties.getProperty(osName);
        }
        if (value == null) {
            value = this.properties.getProperty(name);
        }
        if (value != null && value.indexOf(125) > 0) {
            String key;
            Matcher matcher;
            if (params != null) {
                matcher = PAT_PARAM_NUM.matcher(value);
                while (matcher.find()) {
                    key = matcher.group(1);
                    try {
                        int i = Integer.parseInt(key);
                        if (i >= params.length) continue;
                        value = value.replaceAll("\\Q{" + key + "}\\E", params[i]);
                    }
                    catch (Exception e) {}
                }
            }
            matcher = PAT_PARAM_ALPHA.matcher(value);
            while (matcher.find()) {
                key = matcher.group(1);
                String text = this.getValue(key, params);
                if (text == null) {
                    text = MessageText.getString(key);
                }
                value = value.replaceAll("\\Q{" + key + "}\\E", text);
            }
        }
        return value;
    }

    public int getIntValue(String name, int def) {
        String value = this.getValue(name, null);
        if (value == null) {
            return def;
        }
        int result = def;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int[] getColorValue(String name) {
        int[] colors = new int[3];
        String value = this.getValue(name, null);
        if (value == null || value.length() == 0) {
            colors[2] = -1;
            colors[1] = -1;
            colors[0] = -1;
            return colors;
        }
        try {
            if (value.charAt(0) == '#') {
                long l = Long.parseLong(value.substring(1), 16);
                colors[0] = (int)(l >> 16 & 0xFFL);
                colors[1] = (int)(l >> 8 & 0xFFL);
                colors[2] = (int)(l & 0xFFL);
            } else {
                StringTokenizer st = new StringTokenizer(value, ",");
                colors[0] = Integer.parseInt(st.nextToken());
                colors[1] = Integer.parseInt(st.nextToken());
                colors[2] = Integer.parseInt(st.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            colors[2] = -1;
            colors[1] = -1;
            colors[0] = -1;
        }
        return colors;
    }

    public String getStringValue(String name) {
        return this.getStringValue(name, (String[])null);
    }

    public String getStringValue(String name, String def) {
        return this.getStringValue(name, null, def);
    }

    public String[] getStringArray(String name) {
        return this.getStringArray(name, null);
    }

    public String[] getStringArray(String name, String[] params) {
        String s = this.getValue(name, params);
        if (s == null) {
            return null;
        }
        String[] values = s.split("\\s*,\\s*");
        if (values == null) {
            return new String[]{s};
        }
        return values;
    }

    public String getStringValue(String name, String[] params) {
        return this.getValue(name, params);
    }

    public String getStringValue(String name, String[] params, String def) {
        String s = this.getValue(name, params);
        return s == null ? def : s;
    }
}

