/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.swt.UIConfigDefaultsSWTv3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.utils.UIUpdaterFactory;
import com.aelitis.azureus.util.Constants;
import com.aelitis.azureus.util.InitialisationFunctions;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.common.util.UserAlerts;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.Main;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.UIConfigDefaultsSWT;
import org.gudy.azureus2.ui.swt.auth.AuthenticatorWindow;
import org.gudy.azureus2.ui.swt.auth.CertificateTrustWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.networks.SWTNetworkSelection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.updater2.SWTUpdateChecker;

public class Initializer
implements IUIIntializer {
    private static StartServer startServer;
    private final AzureusCore core;
    protected static SplashWindow splash;

    public static void main(final String[] args) {
        COConfigurationManager.preInitialise();
        String mi_str = System.getProperty("MULTI_INSTANCE");
        boolean mi = mi_str != null && mi_str.equalsIgnoreCase("true");
        startServer = new StartServer();
        boolean debugGUI = Boolean.getBoolean("debug");
        if (mi || debugGUI || Main.processParams(args, startServer)) {
            AzureusCore core = AzureusCoreFactory.create();
            Constants.initialize(core);
            PlatformConfigMessenger.login(0L);
            core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){
                private GlobalManager gm;

                public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                    if (component instanceof GlobalManager) {
                        this.gm = (GlobalManager)component;
                        InitialisationFunctions.initialise(core);
                    }
                }

                public void started(AzureusCore core) {
                    if (this.gm == null) {
                        return;
                    }
                    new UserAlerts(this.gm);
                    new Colors();
                    Cursors.init();
                    new MainWindow(core, Display.getDefault(), splash);
                    SWTUpdateChecker.initialize();
                    UpdateMonitor.getSingleton(core);
                    Alerts.initComplete();
                    for (int i = 0; i < args.length; ++i) {
                        try {
                            TorrentOpener.openTorrent(args[i]);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }

                public void stopping(AzureusCore core) {
                    Alerts.stopInitiated();
                }

                public void stopped(AzureusCore core) {
                }

                public boolean syncInvokeRequired() {
                    return true;
                }

                public boolean stopRequested(AzureusCore _core) throws AzureusCoreException {
                    return Initializer.handleStopRestart(false);
                }

                public boolean restartRequested(AzureusCore core) {
                    return Initializer.handleStopRestart(true);
                }
            });
            startServer.pollForConnections(core);
            new Initializer(core, args);
        }
    }

    public static boolean handleStopRestart(boolean restart) {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT != null) {
            return functionsSWT.dispose(restart, true);
        }
        return false;
    }

    public Initializer(AzureusCore core, String[] args) {
        this.core = core;
        try {
            SWTThread.createInstance(this);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            Debug.printStackTrace(e);
        }
    }

    public void run() {
        long startTime = SystemTime.getCurrentTime();
        new LocaleUtilSWT(this.core);
        final Display display = SWTThread.getInstance().getDisplay();
        UIConfigDefaultsSWT.initialize();
        UIConfigDefaultsSWTv3.initialize();
        ImageRepository.loadImagesForSplashWindow(display);
        ImageRepository.addPath("com/aelitis/azureus/ui/images/azureus.jpg", "azureus_splash");
        display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                splash = new SplashWindow(display);
            }
        });
        System.out.println("Locale Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.core.addListener(new AzureusCoreListener(){
            long startTime = SystemTime.getCurrentTime();
            String sLastTask;

            public void reportCurrentTask(AzureusCoreOperation op, String currentTask) {
                if (op.getOperationType() != 1) {
                    return;
                }
                if (this.sLastTask != null && !this.sLastTask.startsWith("Loading Torrent")) {
                    long now = SystemTime.getCurrentTime();
                    long diff = now - this.startTime;
                    if (diff > 10L && diff < 300000L) {
                        System.out.println("   Core: " + diff + "ms for " + this.sLastTask);
                    }
                    this.startTime = SystemTime.getCurrentTime();
                }
                this.sLastTask = currentTask;
            }

            public void reportPercent(AzureusCoreOperation op, int percent) {
                long now;
                long diff;
                if (op.getOperationType() != 1) {
                    return;
                }
                if (percent == 100 && (diff = (now = SystemTime.getCurrentTime()) - this.startTime) > 10L && diff < 300000L) {
                    System.out.println("   Core: " + diff + "ms for " + this.sLastTask);
                }
            }
        });
        this.core.start();
        splash.reportPercent(25);
        System.out.println("Core Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        Colors.getInstance();
        Alerts.init();
        ProgressWindow.register(this.core);
        new SWTNetworkSelection();
        new AuthenticatorWindow();
        new CertificateTrustWindow();
        splash.reportPercent(50);
        InstallPluginWizard.register(this.core, display);
        System.out.println("GUI Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(boolean isForRestart, boolean isCloseAreadyInProgress) throws AzureusCoreException {
        if (this.core != null && !isCloseAreadyInProgress && isForRestart) {
            this.core.checkRestartSupported();
        }
        try {
            if (startServer != null) {
                startServer.stopIt();
            }
            Colors.getInstance().disposeColors();
            UIUpdaterFactory.getInstance().stopIt();
            SWTThread.getInstance().terminate();
        }
        finally {
            if (this.core != null && !isCloseAreadyInProgress) {
                try {
                    if (isForRestart) {
                        this.core.restart();
                    } else {
                        long lStopStarted = System.currentTimeMillis();
                        System.out.println("core.stop");
                        this.core.stop();
                        System.out.println("core.stop done in " + (System.currentTimeMillis() - lStopStarted));
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }
}

