/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import java.io.File;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;

public class UIConfigDefaultsSWTv3 {
    public static void initialize() {
        ConfigurationManager config = ConfigurationManager.getInstance();
        if (System.getProperty("FORCE_PROGRESSIVE", "").length() > 0) {
            config.setParameter("Prioritize First Piece", true);
            config.save();
        }
        String sFirstVersion = config.getStringParameter("First Recorded Version");
        ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
        defaults.addParameter("Wizard Completed", true);
        defaults.addParameter("ui", "az3");
        if (Constants.compareVersions(sFirstVersion, "3.0.0.0") >= 0) {
            if (!config.isNewInstall() && Constants.compareVersions(sFirstVersion, "3.0.0.4") < 0) {
                String userPath = SystemProperties.getUserPath();
                File f = new File(userPath, "data");
                String sDefSavePath = config.getStringParameter("Default save path");
                if (sDefSavePath == null || !f.equals(new File(sDefSavePath))) {
                    sFirstVersion = "2.5.0.0";
                    config.setParameter("First Recorded Version", sFirstVersion);
                    config.save();
                    return;
                }
            }
            defaults.addParameter("Auto Upload Speed Enabled", true);
            defaults.addParameter("Use default data dir", true);
            defaults.addParameter("Add URL Silently", true);
            defaults.addParameter("add_torrents_silently", true);
            defaults.addParameter("Popup Download Finished", true);
            defaults.addParameter("Popup Download Added", true);
            defaults.addParameter("Status Area Show SR", false);
            defaults.addParameter("Status Area Show NAT", false);
            defaults.addParameter("Status Area Show IPF", false);
            defaults.addParameter("window.maximized", true);
            config.save();
        }
    }
}

