/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser;

import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import com.aelitis.azureus.ui.swt.browser.msg.MessageListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.json.JSONString;

public class BrowserContext
extends ClientMessageContextImpl
implements DisposeListener {
    public static final String LISTENER_ID = "context";
    public static final String OP_PAGE_CHANGED = "page-changed";
    private static final String CONTEXT_KEY = "BrowserContext";
    private static final String KEY_ENABLE_MENU = "browser.menu.enable";
    private Browser browser;
    private Display display;
    private boolean pageLoading = false;

    public BrowserContext(String id, Browser browser, Control widgetWaitingIndicator) {
        this(id);
        this.registerBrowser(browser, widgetWaitingIndicator);
    }

    public BrowserContext(String id) {
        super(id);
    }

    public void registerBrowser(final Browser browser, final Control widgetWaitIndicator) {
        if (this.browser != null) {
            throw new IllegalStateException("Context " + this.getID() + " already has a registered browser");
        }
        final TimerEventPerformer showBrowersPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (browser != null && !browser.isDisposed()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (browser != null && !browser.isDisposed() && !browser.isVisible()) {
                                browser.setVisible(true);
                            }
                        }
                    });
                }
            }
        };
        final TimerEventPerformer hideIndicatorPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (widgetWaitIndicator != null && !widgetWaitIndicator.isDisposed()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (widgetWaitIndicator != null && !widgetWaitIndicator.isDisposed()) {
                                widgetWaitIndicator.setVisible(false);
                            }
                        }
                    });
                }
            }
        };
        browser.setVisible(false);
        if (widgetWaitIndicator != null && !widgetWaitIndicator.isDisposed()) {
            widgetWaitIndicator.setVisible(false);
        }
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                SimpleTimer.addEvent("Show Browser", System.currentTimeMillis() + 700L, showBrowersPerformer);
            }
        });
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event2) {
            }

            public void completed(ProgressEvent event2) {
                if (Constants.isOSX) {
                    Shell shell = browser.getShell();
                    Point size = shell.getSize();
                    --size.x;
                    --size.y;
                    shell.setSize(size);
                    ++size.x;
                    ++size.y;
                    shell.setSize(size);
                }
            }
        });
        browser.addLocationListener(new LocationListener(){
            private TimerEvent timerevent;

            public void changed(LocationEvent event2) {
                if (this.timerevent != null) {
                    this.timerevent.cancel();
                }
                if (widgetWaitIndicator != null && !widgetWaitIndicator.isDisposed()) {
                    widgetWaitIndicator.setVisible(false);
                }
            }

            public void changing(LocationEvent event2) {
                boolean isWebURL;
                boolean bl = isWebURL = event2.location.startsWith("http://") || event2.location.startsWith("https://");
                if (!isWebURL) {
                    return;
                }
                String[] whitelist = PlatformConfigMessenger.getURLWhitelist();
                boolean ok = false;
                for (int i = 0; i < whitelist.length; ++i) {
                    if (!event2.location.matches(whitelist[i])) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    BrowserContext.this.debug("Canceling URL change to external: " + event2.location + " (does not match one of the " + whitelist.length + " whitelist entries)");
                    event2.doit = false;
                } else {
                    if (widgetWaitIndicator != null && !widgetWaitIndicator.isDisposed()) {
                        widgetWaitIndicator.setVisible(true);
                    }
                    this.timerevent = SimpleTimer.addEvent("Hide Indicator", System.currentTimeMillis() + 5000L, hideIndicatorPerformer);
                }
            }
        });
        browser.setData(CONTEXT_KEY, (Object)this);
        browser.addDisposeListener((DisposeListener)this);
        final boolean enableMenu = System.getProperty(KEY_ENABLE_MENU, "0").equals("1");
        browser.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = enableMenu;
            }
        });
        this.getMessageDispatcher().registerBrowser(browser);
        this.browser = browser;
        this.display = browser.getDisplay();
    }

    public void deregisterBrowser() {
        if (this.browser == null) {
            throw new IllegalStateException("Context " + this.getID() + " doesn't have a registered browser");
        }
        this.browser.setData(CONTEXT_KEY, null);
        this.browser.removeDisposeListener((DisposeListener)this);
        this.getMessageDispatcher().deregisterBrowser(this.browser);
        this.browser = null;
    }

    public static BrowserContext getContext(Browser browser) {
        Object data = browser.getData(CONTEXT_KEY);
        if (data != null && !(data instanceof BrowserContext)) {
            Debug.out("Data in Browser with key BrowserContext is not a BrowserContext");
            return null;
        }
        return (BrowserContext)data;
    }

    public void addMessageListener(MessageListener listener) {
        this.getMessageDispatcher().addListener(listener);
    }

    public Object getBrowserData(String key) {
        return this.browser.getData(key);
    }

    public void setBrowserData(String key, Object value) {
        this.browser.setData(key, value);
    }

    public boolean sendBrowserMessage(String key, String op) {
        return this.sendBrowserMessage(key, op, null);
    }

    public boolean sendBrowserMessage(String key, String op, JSONString params) {
        StringBuffer msg = new StringBuffer();
        msg.append("az.msg.dispatch('").append(key).append("', '").append(op).append("'");
        if (params != null) {
            msg.append(", ").append(params.toJSONString());
        }
        msg.append(")");
        return this.executeInBrowser(msg.toString());
    }

    protected boolean maySend(String key, String op, JSONString params) {
        return !this.pageLoading;
    }

    public boolean executeInBrowser(final String javascript) {
        if (!this.mayExecute(javascript)) {
            this.debug("BLOCKED: browser.execute( " + this.getShortJavascript(javascript) + " )");
            return false;
        }
        if (this.display == null || this.display.isDisposed()) {
            this.debug("CANNOT: browser.execute( " + this.getShortJavascript(javascript) + " )");
            return false;
        }
        final String reallyExecute = "try { " + javascript + " } catch ( e ) { }";
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BrowserContext.this.browser == null || BrowserContext.this.browser.isDisposed()) {
                    BrowserContext.this.debug("CANNOT: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                } else if (!BrowserContext.this.browser.execute(reallyExecute)) {
                    BrowserContext.this.debug("FAILED: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                } else {
                    BrowserContext.this.debug("SUCCESS: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                }
            }
        });
        return true;
    }

    protected boolean mayExecute(String javascript) {
        return !this.pageLoading;
    }

    public void handleMessage(BrowserMessage message) {
        String operationId = message.getOperationId();
        if (!OP_PAGE_CHANGED.equals(operationId)) {
            throw new IllegalArgumentException("Unknown operation: " + operationId);
        }
        this.pageChanged(message);
    }

    private void pageChanged(BrowserMessage message) {
        this.debug("Page changed");
    }

    public void widgetDisposed(DisposeEvent event2) {
        if (event2.widget == this.browser) {
            this.deregisterBrowser();
        }
    }

    private String getShortJavascript(String javascript) {
        if (javascript.length() < 515) {
            return javascript;
        }
        StringBuffer result = new StringBuffer();
        result.append(javascript.substring(0, 256));
        result.append("...");
        result.append(javascript.substring(javascript.length() - 256));
        return result.toString();
    }
}

