/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener.publish;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class DownloadStateAndRemoveListener
implements DownloadManagerListener,
DownloadListener,
DownloadWillBeRemovedListener {
    public static final String REMOVAL_ATTRIBUTE_KEY = "REMOVAL ALLOWED";
    private PluginInterface pluginInterface;
    private UISWTInstance swtInstance;
    private Display display;
    private HashMap downloadSemaphores;

    public void downloadAdded(Download download) {
        if (!this.isRemovalAllowed(download)) {
            this.downloadSemaphores.put(download, this.pluginInterface.getUtilities().getSemaphore());
            download.addListener(this);
            download.addDownloadWillBeRemovedListener(this);
        }
    }

    public void downloadRemoved(Download download) {
        this.downloadSemaphores.remove(download);
    }

    public DownloadStateAndRemoveListener(PluginInterface pi, Display display, UISWTInstance swt) {
        this.pluginInterface = pi;
        this.display = display;
        this.swtInstance = swt;
        this.downloadSemaphores = new HashMap();
    }

    public void downloadWillBeRemoved(Download download) throws DownloadRemovalVetoException {
        if (this.isPublished(download)) {
            if (this.isRemovalAllowed(download)) {
                return;
            }
            Semaphore sem = (Semaphore)this.downloadSemaphores.get(download);
            if (sem != null) {
                sem.reserve();
            }
            if (!this.isRemovalAllowed(download)) {
                throw new DownloadRemovalVetoException("Director Plugin Veto", true);
            }
        }
    }

    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }

    public void stateChanged(Download download, int old_state, int new_state) {
        if (new_state == 7 && this.isPublished(download) && !this.isRemovalAllowed(download)) {
            final boolean[] stop = new boolean[1];
            this.display.syncExec(new Runnable(){

                public void run() {
                    LocaleUtilities msgs = DownloadStateAndRemoveListener.this.pluginInterface.getUtilities().getLocaleUtilities();
                    String title = msgs.getLocalisedMessageText("stopSeeding.title");
                    String text = msgs.getLocalisedMessageText("stopSeeding.text");
                    int result = DownloadStateAndRemoveListener.this.swtInstance.promptUser(title, text, new String[]{msgs.getLocalisedMessageText("stopSeeding.stopSeeding"), msgs.getLocalisedMessageText("stopSeeding.cancel")}, 1);
                    stop[0] = result == 0;
                }
            });
            if (!stop[0]) {
                download.setForceStart(true);
            } else {
                this.setRemovalAllowed(download);
            }
            Semaphore sem = (Semaphore)this.downloadSemaphores.get(download);
            if (sem != null) {
                sem.releaseAllWaiters();
            }
        }
    }

    private boolean isRemovalAllowed(Download d) {
        TorrentAttribute attrib = this.pluginInterface.getTorrentManager().getPluginAttribute("ContentMap");
        Map content_map = d.getMapAttribute(attrib);
        if (content_map != null && content_map.containsKey(REMOVAL_ATTRIBUTE_KEY)) {
            return true;
        }
        return d.getState() == 7;
    }

    private void setRemovalAllowed(Download d) {
        TorrentAttribute attrib = this.pluginInterface.getTorrentManager().getPluginAttribute("ContentMap");
        HashMap<String, Long> content_map = d.getMapAttribute(attrib);
        if (content_map == null) {
            content_map = new HashMap<String, Long>();
        }
        content_map.put(REMOVAL_ATTRIBUTE_KEY, new Long(1L));
        d.setMapAttribute(attrib, content_map);
    }

    private boolean isPublished(Download d) {
        TorrentAttribute attrib = this.pluginInterface.getTorrentManager().getPluginAttribute("ContentMap");
        Map content_map = d.getMapAttribute(attrib);
        return content_map != null && content_map.containsKey("DIRECTOR PUBLISH");
    }
}

