/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener.publish;

import com.aelitis.azureus.ui.swt.browser.listener.publish.LocalHoster;
import com.aelitis.azureus.ui.swt.browser.listener.publish.PublishTransaction;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import com.aelitis.azureus.ui.swt.browser.txn.AbstractTransactionalListener;
import com.aelitis.azureus.ui.swt.browser.txn.Transaction;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.plugins.PluginInterface;

public class PublishListener
extends AbstractTransactionalListener {
    public static final String DEFAULT_LISTENER_ID = "publish";
    public static final String OP_CHOOSE_FILE = "choose-file";
    public static final String OP_CHOOSE_FOLDER = "choose-folder";
    public static final String OP_CHOOSE_THUMBNAIL = "choose-thumbnail";
    public static final String OP_EDIT_THUMBNAIL = "edit-thumbnail";
    public static final String OP_TORRENT_READY = "torrent-ready";
    public static final String OP_CANCEL = "cancel";
    private PluginInterface pluginInterface;
    private Shell shell;
    private LocalHoster hoster;

    public PublishListener(Shell s, PluginInterface pi, LocalHoster hoster) {
        this(s, pi, DEFAULT_LISTENER_ID, hoster);
    }

    public PublishListener(Shell s, PluginInterface pi, String id, LocalHoster hoster) {
        super(id);
        this.pluginInterface = pi;
        this.shell = s;
        this.hoster = hoster;
        this.registerOperationTxnRequiresNew(OP_CHOOSE_FILE);
        this.registerOperationTxnRequiresNew(OP_CHOOSE_FOLDER);
        this.registerOperationTxnMandatory(OP_CHOOSE_THUMBNAIL);
        this.registerOperationTxnMandatory(OP_TORRENT_READY);
        this.registerOperationTxnRequired(OP_CANCEL);
        this.registerOperationTxnRequiresNew(OP_EDIT_THUMBNAIL);
    }

    public void handleTxnlMessage(BrowserMessage message, Transaction txn) {
        PublishTransaction realTxn = (PublishTransaction)txn;
        realTxn.setPluginInterface(this.pluginInterface);
        realTxn.setShell(this.shell);
        realTxn.setLocalHoster(this.hoster);
        if (OP_CHOOSE_FILE.equals(message.getOperationId())) {
            realTxn.chooseFile(message);
        } else if (OP_CHOOSE_FOLDER.equals(message.getOperationId())) {
            realTxn.chooseFolder(message);
        } else if (OP_CHOOSE_THUMBNAIL.equals(message.getOperationId()) || OP_EDIT_THUMBNAIL.equals(message.getOperationId())) {
            realTxn.chooseThumbnail(message);
        } else if (OP_TORRENT_READY.equals(message.getOperationId())) {
            realTxn.torrentIsReady(message);
        } else if (OP_CANCEL.equals(message.getOperationId())) {
            realTxn.cancel();
        } else {
            throw new IllegalArgumentException("Unknown operation: " + message.getOperationId());
        }
    }
}

