/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener.publish;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.ui.swt.browser.listener.publish.LocalHoster;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import com.aelitis.azureus.ui.swt.browser.txn.Transaction;
import com.aelitis.azureus.ui.swt.utils.ImageResizeException;
import com.aelitis.azureus.ui.swt.utils.ImageResizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.bouncycastle.util.encoders.Base64;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentCreator;
import org.gudy.azureus2.plugins.torrent.TorrentCreatorListener;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.json.JSONObject;

public class PublishTransaction
extends Transaction {
    private static final String ELEMENTS = "elements";
    public static final String PUBLISH_ATTRIBUTE_KEY = "DIRECTOR PUBLISH";
    private static final int DEFAULT_IMAGE_BOX_SIZE = 320;
    private static final float DEFAULT_JPEG_QUALITY = 0.85f;
    private PluginInterface pluginInterface;
    private Shell shell;
    private LocalHoster hoster;
    private TorrentCreator creator;
    private TorrentCreatorListener creatorListener;
    private File dataFile;

    public void setPluginInterface(PluginInterface pluginInterface) {
        this.pluginInterface = pluginInterface;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setLocalHoster(LocalHoster hoster) {
        this.hoster = hoster;
    }

    public PublishTransaction(int id, String type, ClientMessageContext context) {
        super(id, type, context);
    }

    public void chooseFile(BrowserMessage message) {
        FileDialog dialog = new FileDialog(this.shell);
        String file = dialog.open();
        this.createTorrentFile(file);
    }

    public void chooseFolder(BrowserMessage message) {
        DirectoryDialog dialog = new DirectoryDialog(this.shell);
        String file = dialog.open();
        this.createTorrentFile(file);
    }

    protected boolean canceling() {
        if (this.creator != null) {
            this.creator.cancel();
            this.creator.removeListener(this.creatorListener);
            this.creator = null;
        }
        return true;
    }

    public void chooseThumbnail(BrowserMessage message) {
        int[] resize_size = new int[]{320, 320};
        float[] image_quality = new float[]{0.85f};
        JSONObject elements = null;
        if (message.isParamObject()) {
            JSONObject parameters = message.getDecodedObject();
            try {
                resize_size[0] = parameters.getInt("width");
                resize_size[1] = parameters.getInt("height");
                image_quality[0] = (float)parameters.getDouble("quality");
                if (parameters.has(ELEMENTS)) {
                    elements = parameters.getJSONObject(ELEMENTS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"Image Files"});
        dialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.bmp;*.gif;*.png"});
        String fileName = dialog.open();
        if (fileName != null) {
            try {
                this.sendBrowserMessage("thumb", "start", elements);
                File file = new File(fileName);
                ResizedImageInfo info = this.loadAndResizeImage(file, resize_size[0], resize_size[1], image_quality[0]);
                if (info == null) {
                    this.debug("User canceled image resizing");
                    this.sendBrowserMessage("thumb", "clear", elements);
                } else {
                    String thumbURL = info.url.toString();
                    this.debug("Size : " + info.data.length);
                    String encoded = new String(Base64.encode(info.data));
                    JSONObject params = new JSONObject();
                    params.put("url", thumbURL);
                    params.put("width", info.width);
                    params.put("height", info.height);
                    params.put("data", encoded);
                    if (elements != null) {
                        params.put(ELEMENTS, elements);
                    }
                    this.sendBrowserMessage("thumb", "done", params);
                }
            }
            catch (ImageResizeException e) {
                this.debug("Error resizing image", e);
                this.sendBrowserMessage("thumb", "clear", elements);
                JSONObject params = new JSONObject();
                params.put("message", e.getMessage());
                this.sendBrowserMessage("page", "error", params);
            }
            catch (Exception e) {
                this.debug("Error reading file", e);
                this.sendBrowserMessage("thumb", "clear", elements);
                JSONObject params = new JSONObject();
                params.put("message", "Azureus cannot process this image. Please select another one.");
                this.sendBrowserMessage("page", "error", params);
            }
            catch (OutOfMemoryError e) {
                this.debug("Error processing the image", e);
                this.sendBrowserMessage("thumb", "clear", elements);
                JSONObject params = new JSONObject();
                params.put("message", "Azureus cannot process this image (likely reason is that it is too big). Please select another one.");
                this.sendBrowserMessage("page", "error", params);
            }
        }
    }

    public void torrentIsReady(BrowserMessage message) {
        this.torrentIsReady(message.getDecodedObject().getString("torrent"));
    }

    protected void torrentIsReady(String strTorrent) {
        try {
            strTorrent = strTorrent.replaceAll("\\n", "");
            this.debug("data file path = [" + this.dataFile.getPath() + "]");
            this.debug("Torrent is ready, size = " + strTorrent.length() + ", content (base64) : " + strTorrent);
            byte[] torrent_data = Base64.decode(strTorrent);
            this.debug("Torrent Byte Length: " + torrent_data.length);
            Torrent torrent = this.pluginInterface.getTorrentManager().createFromBEncodedData(torrent_data);
            torrent.setDefaultEncoding();
            Download download = this.pluginInterface.getDownloadManager().addDownload(torrent, null, this.dataFile);
            TorrentAttribute attrib = this.pluginInterface.getTorrentManager().getPluginAttribute("ContentMap");
            HashMap<String, Long> content_map = download.getMapAttribute(attrib);
            if (content_map == null) {
                content_map = new HashMap<String, Long>();
            }
            content_map.put(PUBLISH_ATTRIBUTE_KEY, new Long(1L));
            download.setMapAttribute(attrib, content_map);
            download.setForceStart(true);
            this.stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void torrentCreationFailed(Exception cause) {
        this.debug("Torrent Creation Failed", cause);
        this.sendBrowserMessage("torrent", "failed");
        JSONObject params = new JSONObject();
        params.put("message", "Azureus cannot process this file. Please select another file.");
        this.sendBrowserMessage("page", "error", params);
    }

    private void createTorrentFile(String file) {
        if (file != null) {
            this.dataFile = new File(file);
            try {
                this.creator = this.pluginInterface.getTorrentManager().createFromDataFileEx(this.dataFile, new URL("http://xxxxxxxxxxxxxxxxx:6969/announce"), false);
                this.creatorListener = new TorrentCreatorListener(){

                    public void complete(Torrent torrent) {
                        try {
                            torrent.setDefaultEncoding();
                            PublishTransaction.this.debug("local torrent creation complete: " + torrent.getName() + " : " + torrent.getMagnetURI());
                            String tData = new String(Base64.encode(torrent.writeToBEncodedData()));
                            JSONObject params = new JSONObject();
                            params.put("data", tData);
                            PublishTransaction.this.sendBrowserMessage("torrent", "done", params);
                        }
                        catch (Throwable t) {
                            PublishTransaction.this.debug("error encoding torrent", t);
                        }
                    }

                    public void failed(TorrentException cause) {
                        PublishTransaction.this.torrentCreationFailed(cause);
                    }

                    public void reportActivity(String activity) {
                    }

                    public void reportPercentageDone(int percent) {
                        JSONObject params = new JSONObject();
                        params.put("percent", percent);
                        PublishTransaction.this.sendBrowserMessage("torrent", "progress", params);
                    }
                };
                this.creator.addListener(this.creatorListener);
                this.creator.start();
            }
            catch (MalformedURLException e) {
                this.torrentCreationFailed(e);
            }
            catch (TorrentException e) {
                this.torrentCreationFailed(e);
            }
            JSONObject params = new JSONObject();
            params.put("folder", this.dataFile.isDirectory());
            params.put("name", this.dataFile.getName());
            this.sendBrowserMessage("torrent", "chosen", params);
        } else {
            this.cancel();
            this.stop();
        }
    }

    private ResizedImageInfo loadAndResizeImage(File f, int width, int height, float quality) throws Exception {
        Image source;
        ImageLoader loader = new ImageLoader();
        Display display = this.shell.getDisplay();
        ImageResizer resizer = new ImageResizer(display, width, height, this.shell);
        Image output = resizer.resize(source = new Image((Device)this.shell.getDisplay(), f.getAbsolutePath()));
        if (output == null) {
            return null;
        }
        ImageData data = output.getImageData();
        if (output != null && !output.isDisposed()) {
            output.dispose();
        }
        File fDest = File.createTempFile("thumbnail", ".jpg");
        final FileOutputStream fos = new FileOutputStream(fDest);
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = new OutputStream(){

            public void write(int arg0) throws IOException {
                fos.write(arg0);
                baos.write(arg0);
            }

            public void flush() throws IOException {
                fos.flush();
                baos.flush();
            }

            public void write(byte[] arg0) throws IOException {
                fos.write(arg0);
                baos.write(arg0);
            }

            public void write(byte[] arg0, int arg1, int arg2) throws IOException {
                fos.write(arg0);
                baos.write(arg0);
            }
        };
        loader.data = new ImageData[]{data};
        try {
            Class<?> cla_JPEGFileFormat = Class.forName("org.eclipse.swt.internal.image.JPEGFileFormat");
            Constructor<?> jpeg_constructor = cla_JPEGFileFormat.getDeclaredConstructor(new Class[0]);
            jpeg_constructor.setAccessible(true);
            FileFormat format = (FileFormat)jpeg_constructor.newInstance(new Object[0]);
            Field field = cla_JPEGFileFormat.getDeclaredField("encoderQFactor");
            field.setAccessible(true);
            field.setInt(format, (int)(quality * 100.0f));
            Class<?> cla_LEDataOutputStream = Class.forName("org.eclipse.swt.internal.image.LEDataOutputStream");
            Constructor<?> le_constructor = cla_LEDataOutputStream.getDeclaredConstructor(OutputStream.class);
            le_constructor.setAccessible(true);
            Object le_stream = le_constructor.newInstance(os);
            Method unloadIntoStream = cla_JPEGFileFormat.getMethod("unloadIntoStream", ImageLoader.class, cla_LEDataOutputStream);
            try {
                unloadIntoStream.invoke((Object)format, loader, le_stream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            loader.save(os, 4);
        }
        os.flush();
        URL url = this.hoster.hostFile(fDest);
        ResizedImageInfo result = new ResizedImageInfo(url, width, height, baos.toByteArray());
        os.close();
        return result;
    }

    private class ResizedImageInfo {
        public URL url;
        public int width;
        public int height;
        public byte[] data;

        public ResizedImageInfo(URL url, int width, int height, byte[] data) {
            this.url = url;
            this.width = width;
            this.height = height;
            this.data = data;
        }
    }
}

