/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener.publish;

import com.aelitis.azureus.ui.swt.browser.listener.publish.DownloadStateAndRemoveListener;
import com.aelitis.azureus.ui.swt.browser.msg.AbstractMessageListener;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.json.JSONArray;
import org.json.JSONObject;

public class SeedingListener
extends AbstractMessageListener {
    private static final long INFINITE_ETA = 31535999L;
    private static final long STOPPED_ETA = -88L;
    private static final long ERROR_ETA = -99L;
    private static final String JS_UPLOAD_PROGRESS_MSG_KEY = "upload-progress";
    private static final String JS_INDIVI_UPDATE_MSG_OP = "torrents";
    private static final String JS_GLOBAL_UPDATE_MSG_OP = "global";
    public static final String DEFAULT_LISTENER_ID = "seeding";
    public static final String OP_SEND_UPDATE = "send-update";
    public static final String OP_REMOVE = "remove";
    public static final String OP_STOP = "stop";
    public static final String OP_START = "start";
    private PluginInterface pluginInterface;
    private DownloadStateAndRemoveListener downloadListener;

    public SeedingListener(PluginInterface pi, DownloadStateAndRemoveListener downloadListener) {
        this(DEFAULT_LISTENER_ID, pi, downloadListener);
    }

    public SeedingListener(String id, PluginInterface pi, DownloadStateAndRemoveListener downloadListener) {
        super(id);
        this.pluginInterface = pi;
        this.downloadListener = downloadListener;
    }

    public void handleMessage(BrowserMessage message) {
        if (OP_SEND_UPDATE.equals(message.getOperationId())) {
            this.sendUpdate();
        } else if (OP_REMOVE.equals(message.getOperationId())) {
            this.removeTorrent(message.getDecodedObject().getString("id"));
        } else if (OP_START.equals(message.getOperationId())) {
            this.startTorrent(message.getDecodedObject().getString("id"));
        } else if (OP_STOP.equals(message.getOperationId())) {
            this.stopTorrent(message.getDecodedObject().getString("id"));
        } else {
            throw new IllegalArgumentException("Unknown operation: " + message.getOperationId());
        }
    }

    private Download getDownloadByMagnet(String magnet) {
        DownloadManager dm = this.pluginInterface.getDownloadManager();
        Download[] downloads = dm.getDownloads();
        for (int i = downloads.length - 1; i >= 0; --i) {
            String downloadId;
            Download d = downloads[i];
            Torrent torrent = d.getTorrent();
            if (torrent == null || !(downloadId = Base32.encode(torrent.getHash())).equals(magnet)) continue;
            return d;
        }
        return null;
    }

    private void removeTorrent(String id) {
        final Download d = this.getDownloadByMagnet(id);
        if (d != null) {
            if (d.getState() != 7) {
                d.addListener(new DownloadListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void stateChanged(Download download, int old_state, int new_state) {
                        if (new_state == 7) {
                            try {
                                d.removeDownloadWillBeRemovedListener(SeedingListener.this.downloadListener);
                                download.remove();
                            }
                            catch (DownloadException e) {
                                e.printStackTrace();
                            }
                            catch (DownloadRemovalVetoException e) {
                                e.printStackTrace();
                            }
                            finally {
                                download.removeListener(this);
                            }
                        }
                    }

                    public void positionChanged(Download download, int oldPosition, int newPosition) {
                    }
                });
                this.stop(d);
            } else {
                try {
                    d.removeDownloadWillBeRemovedListener(this.downloadListener);
                    d.remove();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void startTorrent(String id) {
        Download d = this.getDownloadByMagnet(id);
        if (d != null) {
            try {
                d.setForceStart(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void stopTorrent(String id) {
        Download d = this.getDownloadByMagnet(id);
        this.stop(d);
    }

    private void stop(Download download) {
        try {
            download.removeListener(this.downloadListener);
            download.stop();
            download.addListener(this.downloadListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendUpdate() {
        try {
            DownloadManager dm = this.pluginInterface.getDownloadManager();
            Download[] downloads = dm.getDownloads();
            long total_bytes = 0L;
            long total_bytes_remaining = 0L;
            long total_up_rate_bps = 0L;
            int num_actually_uploading = 0;
            ArrayList<IndividualProgress> indiv_torrents = new ArrayList<IndividualProgress>();
            for (int i = downloads.length - 1; i >= 0; --i) {
                Download d = downloads[i];
                if (!this.isPublished(d)) continue;
                long download_size = d.getTorrent().getSize();
                int percent_done = (int)(d.getStats().getUploaded() * 100L / download_size);
                if (percent_done > 99) {
                    indiv_torrents.add(new IndividualProgress(d.getTorrent().getHash(), d.getName(), 100, 0L));
                    continue;
                }
                total_bytes += download_size;
                long bytes_remaining = (long)((float)download_size * ((float)(100 - percent_done) / 100.0f));
                total_bytes_remaining += bytes_remaining;
                long eta = 31535999L;
                if (d.getState() == 7) {
                    eta = -88L;
                } else if (d.getState() == 8) {
                    eta = -99L;
                } else {
                    ++num_actually_uploading;
                    long up_rate_bps = d.getStats().getUploadAverage();
                    if (up_rate_bps > 0L) {
                        total_up_rate_bps += up_rate_bps;
                        eta = bytes_remaining / up_rate_bps;
                    }
                }
                indiv_torrents.add(new IndividualProgress(d.getTorrent().getHash(), d.getName(), percent_done, eta));
            }
            if (!indiv_torrents.isEmpty()) {
                long g_percent = 100L;
                long g_eta = 31535999L;
                if (total_bytes > 0L) {
                    g_percent = (total_bytes - total_bytes_remaining) * 100L / total_bytes;
                    if (total_up_rate_bps > 0L) {
                        g_eta = total_bytes_remaining / total_up_rate_bps;
                    }
                    if (num_actually_uploading < 1) {
                        g_eta = -88L;
                        g_percent = 0L;
                    }
                } else {
                    g_eta = 0L;
                }
                JSONArray torrents = new JSONArray();
                Iterator it = indiv_torrents.iterator();
                while (it.hasNext()) {
                    IndividualProgress ind = (IndividualProgress)it.next();
                    long mod_eta = ind.eta;
                    if (g_eta > 0L && ind.eta > g_eta) {
                        mod_eta = g_eta;
                    }
                    torrents.put(this.constructJSTorrentProgress(ind.infohash, ind.name, ind.percent, mod_eta));
                }
                this.context.sendBrowserMessage(JS_UPLOAD_PROGRESS_MSG_KEY, JS_GLOBAL_UPDATE_MSG_OP, this.constructJSGlobalProgress((int)g_percent, g_eta));
                this.context.sendBrowserMessage(JS_UPLOAD_PROGRESS_MSG_KEY, JS_INDIVI_UPDATE_MSG_OP, torrents);
            }
        }
        catch (Throwable tt) {
            tt.printStackTrace();
        }
    }

    private boolean isPublished(Download d) {
        TorrentAttribute attrib = this.pluginInterface.getTorrentManager().getPluginAttribute("ContentMap");
        Map content_map = d.getMapAttribute(attrib);
        return content_map != null && content_map.containsKey("DIRECTOR PUBLISH");
    }

    private JSONObject constructJSTorrentProgress(byte[] infohash, String name, int percent, long _eta) {
        String hash = infohash == null ? "<null>" : Base32.encode(infohash);
        String eta = this.formatETA(_eta);
        JSONObject torrent = new JSONObject();
        torrent.put("hash", hash);
        torrent.put("name", name);
        torrent.put("percent", percent);
        torrent.put("eta", eta);
        return torrent;
    }

    private JSONObject constructJSGlobalProgress(int percent, long _eta) {
        String eta = this.formatETA(_eta);
        JSONObject global = new JSONObject();
        global.put("percent", percent);
        global.put("eta", eta);
        return global;
    }

    private String formatETA(long eta) {
        if (eta == 31535999L) {
            return "";
        }
        if (eta == -88L) {
            return "x";
        }
        if (eta == -99L) {
            return "e";
        }
        return this.pluginInterface.getUtilities().getFormatters().formatETAFromSeconds(eta);
    }

    private static class IndividualProgress {
        private final byte[] infohash;
        private final String name;
        private final int percent;
        private final long eta;

        private IndividualProgress(byte[] _infohash, String _name, int _percent, long _eta) {
            this.infohash = _infohash;
            this.name = _name;
            this.percent = _percent;
            this.eta = _eta;
        }
    }
}

