/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.msg;

import com.aelitis.azureus.ui.swt.browser.msg.MessageCompletionListener;
import com.aelitis.azureus.util.JSFunctionParametersParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.json.JSONArray;
import org.json.JSONObject;

public class BrowserMessage {
    public static final String MESSAGE_PREFIX = "AZMSG";
    public static final String MESSAGE_DELIM = ";";
    public static final int NO_PARAM = 0;
    public static final int OBJECT_PARAM = 1;
    public static final int ARRAY_PARAM = 2;
    public static final int LIST_PARAM = 3;
    private int sequence;
    private String listenerId;
    private String operationId;
    private String params;
    private int paramType;
    private Object decodedParams;
    private String sFullMessage;
    private ArrayList completionListeners = new ArrayList();
    private boolean completed;
    private boolean completeDelayed;
    static int seqFake = 1;

    public BrowserMessage(String sMsg) {
        if (sMsg == null) {
            throw new IllegalArgumentException("event must be non-null");
        }
        this.sFullMessage = sMsg;
        this.parse();
    }

    protected void parse() {
        String text = this.sFullMessage;
        int delimSeqNum = text.indexOf(MESSAGE_DELIM);
        if (delimSeqNum == -1) {
            throw new IllegalArgumentException("Message has no delimeters: " + text);
        }
        if (delimSeqNum == text.length() - 1) {
            throw new IllegalArgumentException("Message has no sequence number: " + text);
        }
        int delimListener = text.indexOf(MESSAGE_DELIM, delimSeqNum + 1);
        if (delimListener == -1 || delimListener == text.length() - 1) {
            throw new IllegalArgumentException("Message has no listener ID: " + text);
        }
        try {
            this.sequence = Integer.parseInt(text.substring(delimSeqNum + 1, delimListener));
        }
        catch (NumberFormatException e) {
            System.err.println("Plese put the throw back in once souk fixes the seq # bug");
            this.sequence = seqFake++;
        }
        int delimOperation = text.indexOf(MESSAGE_DELIM, delimListener + 1);
        if (delimOperation == -1 || delimOperation == text.length() - 1) {
            throw new IllegalArgumentException("Message has no operation ID: " + text);
        }
        this.listenerId = text.substring(delimListener + 1, delimOperation);
        int delimParams = text.indexOf(MESSAGE_DELIM, delimOperation + 1);
        if (delimParams == -1) {
            this.operationId = text.substring(delimOperation + 1);
        } else if (delimParams == text.length() - 1) {
            this.operationId = text.substring(delimOperation + 1, delimParams);
            this.params = null;
            this.paramType = 0;
            this.decodedParams = null;
        } else {
            this.operationId = text.substring(delimOperation + 1, delimParams);
            this.params = text.substring(delimParams + 1);
            char leading = this.params.charAt(0);
            switch (leading) {
                case '{': {
                    this.paramType = 1;
                    this.decodedParams = new JSONObject(this.params);
                    break;
                }
                case '[': {
                    this.paramType = 2;
                    this.decodedParams = new JSONArray(this.params);
                    break;
                }
                default: {
                    this.paramType = 3;
                    this.decodedParams = JSFunctionParametersParser.parse(this.params);
                }
            }
        }
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getFullMessage() {
        return this.sFullMessage;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public boolean isParamObject() {
        return this.paramType == 1;
    }

    public boolean isParamArray() {
        return this.paramType == 2;
    }

    public boolean isParamList() {
        return this.paramType == 3;
    }

    public String getParams() {
        return this.params;
    }

    public JSONObject getDecodedObject() {
        if (!this.isParamObject()) {
            throw new IllegalStateException("Decoded parameter is not a JSONObject");
        }
        return (JSONObject)this.decodedParams;
    }

    public JSONArray getDecodedArray() {
        if (!this.isParamArray()) {
            throw new IllegalStateException("Decoded parameter is not a JSONArray");
        }
        return (JSONArray)this.decodedParams;
    }

    public List getDecodedList() {
        if (!this.isParamList()) {
            throw new IllegalStateException("Decoded parameter is not a List");
        }
        return (List)this.decodedParams;
    }

    public void addCompletionListener(MessageCompletionListener l) {
        this.completionListeners.add(l);
    }

    public void removeCompletionListener(MessageCompletionListener l) {
        this.completionListeners.remove(l);
    }

    private void triggerCompletionListeners(boolean success, Object data) {
        Iterator iterator = this.completionListeners.iterator();
        while (iterator.hasNext()) {
            MessageCompletionListener l = (MessageCompletionListener)iterator.next();
            try {
                l.completed(success, data);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void complete(boolean bOnlyNonDelayed, boolean success, Object data) {
        System.out.println("complete called with " + bOnlyNonDelayed);
        if (this.completed || bOnlyNonDelayed && this.completeDelayed) {
            System.out.println("exit early" + this.completed);
            return;
        }
        this.triggerCompletionListeners(success, data);
        this.completed = true;
    }

    public void setCompleteDelayed(boolean bCompleteDelayed) {
        this.completeDelayed = bCompleteDelayed;
    }

    public String toString() {
        return "[" + this.sequence + "] " + this.listenerId + "." + this.operationId + "(" + this.params + ")";
    }
}

