/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.msg;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import com.aelitis.azureus.ui.swt.browser.msg.MessageListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.gudy.azureus2.core3.util.Debug;

public class MessageDispatcher
implements StatusTextListener {
    public static final String LISTENER_ID = "dispatcher";
    public static final String OP_RESET_SEQUENCE = "reset-sequence";
    public static final String CONTEXT_LISTENER_ID = "context";
    private static final int INITIAL_LAST_SEQUENCE = -1;
    private ClientMessageContext context;
    private Map listeners = new HashMap();
    private int lastSequence = -1;
    private String sLastEventText;

    public MessageDispatcher(ClientMessageContext context) {
        this.context = context;
    }

    public void registerBrowser(Browser browser) {
        browser.addStatusTextListener((StatusTextListener)this);
    }

    public void deregisterBrowser(Browser browser) {
        browser.removeStatusTextListener((StatusTextListener)this);
    }

    public synchronized void addListener(MessageListener listener) {
        String id = listener.getId();
        MessageListener registered = (MessageListener)this.listeners.get(id);
        if (registered != null) {
            if (registered != listener) {
                throw new IllegalStateException("Listener " + registered.getClass().getName() + " already registered for ID " + id);
            }
        } else {
            listener.setContext(this.context);
            this.listeners.put(id, listener);
        }
    }

    public synchronized void removeListener(MessageListener listener) {
        this.removeListener(listener.getId());
    }

    public synchronized void removeListener(String id) {
        MessageListener removed = (MessageListener)this.listeners.remove(id);
        if (removed != null) {
            removed.setContext(null);
        }
    }

    public MessageListener getListener(String id) {
        return (MessageListener)this.listeners.get(id);
    }

    public void changed(StatusTextEvent event2) {
        if (event2.text == null) {
            return;
        }
        if (this.sLastEventText != null && event2.text.equals(this.sLastEventText)) {
            return;
        }
        this.sLastEventText = event2.text;
        if (event2.text.startsWith("AZMSG")) {
            try {
                this.dispatch(new BrowserMessage(event2.text));
                System.out.println("status change dispatched: " + event2.text);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void dispatch(BrowserMessage message) {
        if (message == null) {
            return;
        }
        this.context.debug("Received " + message);
        String listenerId = message.getListenerId();
        if (LISTENER_ID.equals(listenerId)) {
            this.handleMessage(message);
        } else if (CONTEXT_LISTENER_ID.equals(listenerId)) {
            this.context.handleMessage(message);
        } else if (!this.isValidSequence(message)) {
            this.context.debug("Ignoring duplicate: " + message);
        } else {
            MessageListener listener = this.getListener(listenerId);
            if (listener == null) {
                this.context.debug("No listener registered with ID " + listenerId);
            } else {
                listener.handleMessage(message);
                message.complete(true, true, null);
            }
        }
    }

    public void handleMessage(BrowserMessage message) {
        String operationId = message.getOperationId();
        if (!OP_RESET_SEQUENCE.equals(operationId)) {
            throw new IllegalArgumentException("Unknown operation: " + operationId);
        }
        this.resetSequence();
    }

    public boolean isValidSequence(BrowserMessage message) {
        int sequence = message.getSequence();
        if (sequence < 0) {
            Debug.outNoStack("Invalid sequence number: " + sequence);
            return false;
        }
        if (sequence <= this.lastSequence) {
            this.context.debug("Duplicate sequence number: " + sequence + ", last: " + this.lastSequence);
            return false;
        }
        this.lastSequence = sequence;
        return true;
    }

    public void resetSequence() {
        this.context.debug("Reseting sequence number");
        this.lastSequence = -1;
    }
}

