/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.txn;

import com.aelitis.azureus.ui.swt.browser.msg.AbstractMessageListener;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import com.aelitis.azureus.ui.swt.browser.txn.Transaction;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTransactionalListener
extends AbstractMessageListener {
    public static final String TXN_REQUIRED = "Required";
    public static final String TXN_REQUIRES_NEW = "RequiresNew";
    public static final String TXN_MANDATORY = "Mandatory";
    public static final String TXN_NONE = "NotSupported";
    private String txnType;
    private Map txnStatesByOp = new HashMap();

    public AbstractTransactionalListener(String id) {
        this(id, id);
    }

    public AbstractTransactionalListener(String id, String txnType) {
        super(id);
        this.txnType = txnType;
    }

    protected String getOperationTxnState(String operationId) {
        return (String)this.txnStatesByOp.get(operationId);
    }

    protected void registerOperationTxnRequired(String operationId) {
        this.registerOperation(operationId, TXN_REQUIRED);
    }

    protected void registerOperationTxnRequiresNew(String operationId) {
        this.registerOperation(operationId, TXN_REQUIRES_NEW);
    }

    protected void registerOperationTxnMandatory(String operationId) {
        this.registerOperation(operationId, TXN_MANDATORY);
    }

    protected void registerOperationTxnNone(String operationId) {
        this.registerOperation(operationId, TXN_NONE);
    }

    private void registerOperation(String operationId, String txnState) {
        this.txnStatesByOp.put(operationId, txnState);
    }

    public String getTransactionType() {
        return this.txnType;
    }

    protected Transaction getTransaction() {
        return this.context.getTransaction(this.txnType);
    }

    protected Transaction startTransaction() {
        return this.context.startTransaction(this.txnType);
    }

    protected Transaction cancelTransaction() {
        return this.context.cancelTransaction(this.txnType);
    }

    public void handleMessage(BrowserMessage message) {
        String state = this.getOperationTxnState(message.getOperationId());
        if (state == null) {
            this.context.debug("Ignoring message without transactional state: " + message);
            return;
        }
        Transaction txn = this.getTransaction();
        if (state.equals(TXN_REQUIRED)) {
            if (txn == null) {
                txn = this.startTransaction();
            }
        } else if (state.equals(TXN_REQUIRES_NEW)) {
            this.cancelTransaction();
            txn = this.startTransaction();
        } else if (state.equals(TXN_MANDATORY)) {
            if (txn == null) {
                this.transactionStateViolated(message, state, null);
                return;
            }
        } else if (state.equals(TXN_NONE)) {
            if (txn != null) {
                txn = null;
            }
        } else {
            this.context.debug("Ignoring message with invalid transactional state (" + state + "): " + message);
            return;
        }
        if (txn != null) {
            this.handleTxnlMessage(message, txn);
        } else {
            this.handleNonTxnlMessage(message);
        }
    }

    protected abstract void handleTxnlMessage(BrowserMessage var1, Transaction var2);

    protected void handleNonTxnlMessage(BrowserMessage message) {
    }

    protected void transactionStateViolated(BrowserMessage message, String state, Transaction txn) {
        throw new IllegalStateException("Transaction state violated - state: " + state + ", txn: " + txn);
    }
}

