/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.txn;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.ui.swt.browser.txn.Transaction;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class TransactionManager {
    private ClientMessageContext context;
    private Map txnCtors = new HashMap();
    private Map txns = new HashMap();
    private int lastTxnId = 0;

    public TransactionManager(ClientMessageContext context) {
        this.context = context;
    }

    public synchronized Transaction getTransaction(String type) {
        return (Transaction)this.txns.get(type);
    }

    public synchronized Transaction startTransaction(String type) {
        this.cancelTransaction(type);
        Transaction txn = this.createTransaction(type);
        if (txn != null) {
            if (!txn.start()) {
                return null;
            }
            this.txns.put(type, txn);
        }
        return txn;
    }

    public synchronized Transaction cancelTransaction(String type) {
        Transaction txn = this.getTransaction(type);
        if (txn != null) {
            txn.cancel();
        }
        return txn;
    }

    synchronized boolean removeTransaction(Transaction txn) {
        if (txn != this.getTransaction(txn.getType())) {
            return false;
        }
        return this.txns.remove(txn.getType()) == txn;
    }

    public void registerTransactionType(String type, Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Transaction class must be non-null");
        }
        if (!Transaction.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Transaction class " + clazz.getName() + " must be a subclass of Transaction");
        }
        try {
            Class[] ctorParams = new Class[]{Integer.TYPE, String.class, ClientMessageContext.class};
            Constructor ctor = clazz.getConstructor(ctorParams);
            this.txnCtors.put(type, ctor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access appropriate constructor for " + clazz.getName());
        }
    }

    protected Transaction createTransaction(String type) {
        Constructor ctor = (Constructor)this.txnCtors.get(type);
        if (ctor == null) {
            throw new IllegalStateException("Unregistered transaction type: " + type);
        }
        try {
            Object[] params = new Object[]{new Integer(this.getNextTransactionId()), type, this.context};
            return (Transaction)ctor.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating transaction for type " + type, e);
        }
    }

    private int getNextTransactionId() {
        return ++this.lastTxnId;
    }
}

