/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnComplete
extends CoreTableColumn
implements TableCellAddedListener {
    private static UISWTGraphicImpl graphicWait;
    private static int width;

    public ColumnComplete(String sTableID) {
        super("CompleteIcon", sTableID);
        this.initializeAsGraphic(-2, width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    static {
        Image img = ImageLoaderFactory.getInstance().getImage("icon.rate.wait");
        width = img.getBounds().width;
        graphicWait = new UISWTGraphicImpl(img);
    }

    private class Cell
    implements TableCellRefreshListener {
        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void refresh(TableCell cell) {
            int sortVal;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            boolean bComplete = dm.isDownloadComplete(false);
            int n = sortVal = bComplete ? 0 : 1;
            if (!cell.setSortValue(sortVal) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setGraphic(bComplete ? null : graphicWait);
        }
    }
}

