/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnDateAdded2Liner
extends CoreTableColumn
implements TableCellRefreshListener {
    static final String[] FORMATS = new String[]{"EEEE, MMMM d, yyyy", "EEE, MMMM d, yyyy", "EEE, MMM d, yyyy", "EEE, MMM d, ''yy", "MMMM d, ''yy", "MMM d, ''yy", "yyyy/mm/dd"};
    static int globalFormat = 0;
    int curFormat = 0;

    public ColumnDateAdded2Liner(String sTableID, boolean bVisible) {
        super("date_added", 2, bVisible ? -2 : -1, 70, sTableID);
    }

    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? 0L : dm.getDownloadState().getLongParameter("stats.download.added.time");
        if (!cell.setSortValue(value) && cell.isValid() && this.curFormat == globalFormat) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        int cellWidth = cell.getWidth();
        Date date = new Date(value);
        GC gc = new GC((Drawable)Display.getDefault());
        Point minSize = new Point(99999, 0);
        int idxFormat = -1;
        for (int i = 0; i < FORMATS.length; ++i) {
            SimpleDateFormat temp = new SimpleDateFormat(FORMATS[i]);
            Point newSize = gc.stringExtent(temp.format(date));
            if (newSize.x < cellWidth) {
                idxFormat = i;
                break;
            }
            if (newSize.x >= minSize.x) continue;
            minSize = newSize;
            idxFormat = i;
        }
        gc.dispose();
        if (idxFormat >= 0) {
            if (idxFormat > globalFormat) {
                globalFormat = idxFormat;
                cell.getTableColumn().invalidateCells();
            } else if (idxFormat < globalFormat) {
                idxFormat = globalFormat;
            }
            this.curFormat = idxFormat;
            SimpleDateFormat temp = new SimpleDateFormat(FORMATS[idxFormat] + "\nh:mm a");
            cell.setText(temp.format(date));
        }
    }
}

