/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnIsSeeding
extends CoreTableColumn
implements TableCellAddedListener {
    private static UISWTGraphicImpl graphicCheck;
    private static int width;

    public ColumnIsSeeding(String sTableID) {
        super("IsSeeding", sTableID);
        this.initializeAsGraphic(-2, width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    static {
        Image img = ImageLoaderFactory.getInstance().getImage("image.check");
        width = img.getBounds().width;
        graphicCheck = new UISWTGraphicImpl(img);
    }

    private class Cell
    implements TableCellRefreshListener {
        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void refresh(TableCell cell) {
            int sortVal;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            int state = dm.getState();
            boolean bSeeding = state == 60 || (state == 30 || state == 0 || state == 40) && dm.getAssumedComplete();
            int n = sortVal = bSeeding ? 0 : 1;
            if (!cell.setSortValue(sortVal) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setGraphic(bSeeding ? graphicCheck : null);
        }
    }
}

