/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnMediaThumb
extends CoreTableColumn
implements TableCellAddedListener {
    public ColumnMediaThumb(String sTableID) {
        super("MediaThumb", sTableID);
        this.initializeAsGraphic(-2, 50);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public class disposableUISWTGraphic
    extends UISWTGraphicImpl {
        public disposableUISWTGraphic(Image newImage) {
            super(newImage);
        }
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener,
    TableCellVisibilityListener {
        TOTorrent torrent;
        Graphic graphic;

        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void dispose(TableCell cell) {
            this.disposeOldImage(cell);
        }

        public void refresh(TableCell cell) {
            this.refresh(cell, false);
        }

        public void refresh(TableCell cell, boolean bForce) {
            boolean bChanged;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            TOTorrent newTorrent = dm.getTorrent();
            long lastUpdated = PlatformTorrentUtils.getContentLastUpdated(newTorrent);
            if (lastUpdated == 0L) {
                lastUpdated = -1L;
            }
            boolean bl = bChanged = cell.setSortValue(lastUpdated) || bForce;
            if (newTorrent == this.torrent && !bChanged && cell.isValid()) {
                return;
            }
            if (!bForce && !cell.isShown()) {
                return;
            }
            this.torrent = newTorrent;
            if (this.torrent == null) {
                cell.setGraphic(null);
            } else {
                this.disposeOldImage(cell);
                byte[] b = PlatformTorrentUtils.getContentThumbnail(this.torrent);
                if (b == null) {
                    String path = dm.getDownloadState().getPrimaryFile();
                    if (path != null) {
                        Image icon = ImageRepository.getPathIcon(path, true);
                        UISWTGraphicImpl graphic = new UISWTGraphicImpl(icon);
                        cell.setGraphic(graphic);
                    } else {
                        cell.setGraphic(null);
                    }
                } else {
                    int MAXH = cell.getHeight() - 2;
                    if (MAXH <= 0) {
                        MAXH = 30;
                    }
                    ByteArrayInputStream bis = new ByteArrayInputStream(b);
                    try {
                        Image img = new Image((Device)Display.getDefault(), (InputStream)bis);
                        int w = img.getBounds().width;
                        int h = img.getBounds().height;
                        if (h > MAXH) {
                            int h2 = MAXH;
                            int w2 = h2 * w / h;
                            Image newImg = new Image(img.getDevice(), w2, h2);
                            GC gc = new GC((Drawable)newImg);
                            gc.setAdvanced(true);
                            try {
                                gc.setInterpolation(2);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            gc.drawImage(img, 0, 0, w, h, 0, 0, w2, h2);
                            gc.dispose();
                            img.dispose();
                            img = newImg;
                        }
                        disposableUISWTGraphic graphic = new disposableUISWTGraphic(img);
                        cell.setGraphic(graphic);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }

        private void disposeOldImage(TableCell cell) {
            Graphic oldGraphic = cell.getGraphic();
            if (oldGraphic instanceof disposableUISWTGraphic) {
                Image oldImage = ((UISWTGraphic)oldGraphic).getImage();
                Utils.disposeSWTObjects(new Object[]{oldImage});
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (visibility == 1) {
                this.disposeOldImage(cell);
            } else if (visibility == 0) {
                this.refresh(cell, true);
            }
        }

        private void log(TableCell cell, String s) {
            System.out.println(((TableRowCore)cell.getTableRow()).getIndex() + ":" + System.currentTimeMillis() + ": " + s);
        }
    }
}

