/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnProgressETA
extends CoreTableColumn
implements TableCellAddedListener {
    private static final int borderWidth = 1;
    Display display;

    public ColumnProgressETA(String sTableID) {
        super("ProgressETA", sTableID);
        this.initializeAsGraphic(-2, 120);
        this.setAlignment(1);
        this.display = SWTThread.getInstance().getDisplay();
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener,
    TableCellMouseListener,
    TableCellVisibilityListener {
        int lastPercentDone = 0;
        long lastETA;
        private boolean bMouseDowned = false;
        Rectangle areaPlay = null;
        Rectangle areaStream = null;

        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginHeight(1);
            cell.setFillCell(true);
        }

        public void dispose(TableCell cell) {
            this.disposeExisting(cell);
        }

        public void refresh(TableCell cell) {
            this.refresh(cell, false);
        }

        private void refresh(TableCell cell, boolean bForce) {
            Rectangle imageBounds;
            boolean bImageSizeChanged;
            Color cBorder;
            Color cFG;
            long eta;
            int percentDone;
            long sortValue;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            EnhancedDownloadManager edm = null;
            boolean bCanBeProgressive = PlatformTorrentUtils.isContentProgressive(dm.getTorrent());
            if (bCanBeProgressive && ((edm = this.getEDM(dm)) == null || !edm.supportsProgressiveMode())) {
                bCanBeProgressive = false;
            }
            if (!cell.setSortValue(sortValue = (long)((percentDone = this.getPercentDone(cell)) << 49) + ((eta = this.getETA(cell)) << 4) + (long)this.getState(cell) + (long)(bCanBeProgressive ? 1 : 0)) && !bForce && cell.isValid() && this.lastPercentDone == percentDone && this.lastETA == eta) {
                return;
            }
            if (!bForce && !cell.isShown()) {
                return;
            }
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight();
            int x1 = newWidth - 1 - 1;
            int progressX1 = bCanBeProgressive ? x1 - 55 : x1;
            int progressY1 = newHeight - 1 - 1 - 12;
            if (x1 < 10 || progressX1 < 10 || progressY1 < 3) {
                return;
            }
            SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
            Color cBG = skinProperties.getColor("color.progress.bg");
            if (cBG == null) {
                cBG = Colors.blues[0];
            }
            if ((cFG = skinProperties.getColor("color.progress.fg")) == null) {
                cFG = Colors.blues[2];
            }
            if ((cBorder = skinProperties.getColor("color.progress.border")) == null) {
                cBorder = Colors.grey;
            }
            Color cText = skinProperties.getColor("color.progress.text");
            if (cBorder == null) {
                cBorder = Colors.black;
            }
            int etaY0 = progressY1 + 1;
            this.lastPercentDone = percentDone;
            this.lastETA = eta;
            boolean bDrawProgressBar = true;
            Image image = ((TableCellCore)cell).getGraphicSWT();
            if (image == null) {
                bImageSizeChanged = true;
            } else {
                imageBounds = image.getBounds();
                bImageSizeChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
            }
            image = new Image((Device)ColumnProgressETA.this.display, newWidth, newHeight);
            imageBounds = image.getBounds();
            GC gcImage = new GC((Drawable)image);
            Color background = ((TableRowCore)cell.getTableRow()).getBackground();
            if (background != null) {
                gcImage.setBackground(background);
                gcImage.fillRectangle(imageBounds);
            }
            String sETALine = null;
            long lSpeed = this.getSpeed(dm);
            String sSpeed = lSpeed <= 0L ? "" : "(" + DisplayFormatters.formatByteCountToKiBEtcPerSec(lSpeed, true) + ")";
            this.areaPlay = null;
            this.areaStream = null;
            if (bCanBeProgressive) {
                Rectangle bounds;
                Image img;
                String id = "";
                if (edm.getProgressiveMode()) {
                    if (edm.getProgressivePlayETA() <= 0L) {
                        bDrawProgressBar = false;
                        id = "image.stream.play";
                        img = ImageLoaderFactory.getInstance().getImage(id);
                        if (ImageLoader.isRealImage(img)) {
                            gcImage.drawImage(img, 2, 0);
                            bounds = img.getBounds();
                            this.areaPlay = new Rectangle(2, 0, bounds.width, bounds.height);
                        }
                    }
                    id = "image.stream.enabled";
                } else {
                    id = "image.stream";
                }
                img = ImageLoaderFactory.getInstance().getImage(id);
                if (ImageLoader.isRealImage(img)) {
                    bounds = img.getBounds();
                    this.areaStream = new Rectangle(newWidth - img.getBounds().width - 2, 0, bounds.width, bounds.height);
                    gcImage.drawImage(img, this.areaStream.x, this.areaStream.y);
                }
                if (edm.getProgressiveMode()) {
                    String sETA;
                    sETALine = this.isStopped(cell) ? MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{DisplayFormatters.formatDownloadStatus((DownloadManager)cell.getDataSource()), sSpeed}) : ((sETA = TimeFormatter.format(edm.getProgressivePlayETA())).length() == 0 ? MessageText.getString("MyTorrents.column.ColumnProgressETA.StreamReady", new String[]{sSpeed}) : MessageText.getString("MyTorrents.column.ColumnProgressETA.PlayableIn", new String[]{sETA, sSpeed}));
                }
            }
            if (bDrawProgressBar) {
                if (!bImageSizeChanged) {
                    // empty if block
                }
                gcImage.setForeground(cBorder);
                gcImage.drawRectangle(0, 0, progressX1, progressY1);
                int limit = progressX1 * percentDone / 1000;
                gcImage.setBackground(cBG);
                gcImage.fillRectangle(1, 1, limit, progressY1 - 1);
                if (limit < progressX1) {
                    gcImage.setBackground(cFG);
                    gcImage.fillRectangle(limit + 1, 1, progressX1 - limit, progressY1 - 1);
                }
            }
            if (sETALine == null) {
                String sETA = this.isStopped(cell) ? DisplayFormatters.formatDownloadStatus((DownloadManager)cell.getDataSource()) : TimeFormatter.format(eta);
                sETALine = MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA, sSpeed});
            }
            FontData[] fontData = gcImage.getFont().getFontData();
            fontData[0].setHeight(Utils.pixelsToPoint(10, ColumnProgressETA.this.display.getDPI().y));
            Font font = new Font((Device)ColumnProgressETA.this.display, fontData);
            gcImage.setFont(font);
            int[] fg = cell.getForeground();
            gcImage.setForeground(ColorCache.getColor((Device)ColumnProgressETA.this.display, fg[0], fg[1], fg[2]));
            gcImage.drawText(sETALine, 0, etaY0, true);
            if (bDrawProgressBar) {
                gcImage.setForeground(cText);
                String sPercent = DisplayFormatters.formatPercentFromThousands(percentDone);
                gcImage.drawText(sPercent, 2, 2, true);
            }
            gcImage.setFont(null);
            font.dispose();
            gcImage.dispose();
            this.disposeExisting(cell);
            ((TableCellCore)cell).setGraphic(image);
        }

        private int getPercentDone(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 0;
            }
            return dm.getStats().getDownloadCompleted(true);
        }

        private long getETA(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 31536000L;
            }
            return dm.getStats().getETA();
        }

        private int getState(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return 100;
            }
            return dm.getState();
        }

        private boolean isStopped(TableCell cell) {
            int state = this.getState(cell);
            return state == 75 || state == 70 || state == 65 || state == 100;
        }

        private long getSpeed(DownloadManager dm) {
            if (dm == null) {
                return 0L;
            }
            return dm.getStats().getDataReceiveRate();
        }

        public EnhancedDownloadManager getEDM(DownloadManager dm) {
            DownloadManagerEnhancer dmEnhancer = DownloadManagerEnhancer.getSingleton();
            if (dmEnhancer == null) {
                return null;
            }
            return dmEnhancer.getEnhancedDownload(dm);
        }

        public void cellMouseTrigger(TableCellMouseEvent event2) {
            if (event2.button != 1) {
                return;
            }
            if (event2.eventType == 0) {
                this.bMouseDowned = true;
                return;
            }
            if (event2.eventType == 1 && this.bMouseDowned) {
                if (!event2.cell.getTableRow().isSelected()) {
                    this.log(event2.cell, "not selected");
                    return;
                }
                DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
                if (dm == null) {
                    return;
                }
                EnhancedDownloadManager edm = this.getEDM(dm);
                if (edm == null) {
                    return;
                }
                if (this.areaPlay != null && this.areaPlay.contains(event2.x, event2.y)) {
                    if (edm.getProgressiveMode() && edm.getProgressivePlayETA() <= 0L) {
                        Download pDL = (Download)((TableRowCore)event2.cell.getTableRow()).getDataSource(false);
                        TorrentListViewsUtils.playViaMediaServer(pDL);
                    }
                } else if (this.areaStream != null && this.areaStream.contains(event2.x, event2.y)) {
                    if (edm.getProgressiveMode()) {
                        edm.setProgressiveMode(false);
                    } else {
                        Object[] dms = dm.getGlobalManager().getDownloadManagers().toArray();
                        for (int i = 0; i < dms.length; ++i) {
                            EnhancedDownloadManager edmCheck;
                            DownloadManager dmCheck = (DownloadManager)dms[i];
                            if (dmCheck.isDownloadComplete(false) || (edmCheck = this.getEDM(dmCheck)) == null || !edmCheck.getProgressiveMode()) continue;
                            edmCheck.setProgressiveMode(false);
                        }
                        edm.setProgressiveMode(true);
                    }
                }
                event2.cell.invalidate();
            }
            this.bMouseDowned = false;
        }

        private void disposeExisting(TableCell cell) {
            Image oldImage;
            Graphic oldGraphic = cell.getGraphic();
            if (oldGraphic instanceof UISWTGraphic && (oldImage = ((UISWTGraphic)oldGraphic).getImage()) != null && !oldImage.isDisposed()) {
                cell.setGraphic(null);
                oldImage.dispose();
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (visibility == 1) {
                this.disposeExisting(cell);
            } else if (visibility == 0) {
                this.refresh(cell, true);
            }
        }

        private void log(TableCell cell, String s) {
            System.out.println(((TableRowCore)cell.getTableRow()).getIndex() + ":" + System.currentTimeMillis() + ": " + s);
        }
    }
}

