/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnQuality
extends CoreTableColumn
implements TableCellAddedListener {
    public Font font;

    public ColumnQuality(String sTableID) {
        super("Quality", sTableID);
        this.initializeAsGraphic(-2, 40);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public class disposableUISWTGraphic
    extends UISWTGraphicImpl {
        public disposableUISWTGraphic(Image newImage) {
            super(newImage);
        }
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener {
        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void dispose(TableCell cell) {
            this.disposeOld(cell);
        }

        public void refresh(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) {
                return;
            }
            String quality = PlatformTorrentUtils.getContentQuality(torrent);
            if (!cell.setSortValue((Comparable)((Object)quality)) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            if (quality == null) {
                this.disposeOld(cell);
                cell.setGraphic(null);
                return;
            }
            Image img = ImageLoaderFactory.getInstance().getImage("icon.quality." + quality);
            if (ImageLoader.isRealImage(img)) {
                UISWTGraphicImpl graphic = new UISWTGraphicImpl(img);
                cell.setGraphic(graphic);
            } else {
                int width = cell.getWidth();
                int height = cell.getHeight();
                img = new Image((Device)Display.getDefault(), width, height);
                GC gcImage = new GC((Drawable)img);
                Color background = ((TableRowCore)cell.getTableRow()).getBackground();
                if (background != null) {
                    gcImage.setBackground(background);
                    gcImage.fillRectangle(0, 0, width, height);
                }
                if (ColumnQuality.this.font == null) {
                    FontData[] fontData = gcImage.getFont().getFontData();
                    fontData[0].setHeight(Utils.pixelsToPoint(12, Display.getDefault().getDPI().y));
                    fontData[0].setStyle(1);
                    fontData[0].setName("Sans Serif");
                    ColumnQuality.this.font = new Font((Device)Display.getDefault(), fontData);
                }
                gcImage.setFont(ColumnQuality.this.font);
                int iPosition = ((TableRowCore)cell.getTableRow()).getIndex();
                boolean bOdd = (iPosition + 1) % 2 == 0;
                String prefix = "color.rating." + (bOdd ? "odd" : "even");
                SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
                Color color1 = skinProperties.getColor(prefix + ".good.darker");
                Color color2 = skinProperties.getColor("color.rating.good");
                Rectangle r = img.getBounds();
                r.x += 2;
                r.y += 2;
                gcImage.setForeground(color1);
                GCStringPrinter.printString(gcImage, quality, r, true, false, 0x1000000);
                gcImage.setForeground(color2);
                GCStringPrinter.printString(gcImage, quality, img.getBounds(), true, false, 0x1000000);
                gcImage.dispose();
                disposableUISWTGraphic graphic = new disposableUISWTGraphic(img);
                this.disposeOld(cell);
                cell.setGraphic(graphic);
            }
        }

        private void disposeOld(TableCell cell) {
            Graphic oldGraphic = cell.getGraphic();
            if (oldGraphic instanceof disposableUISWTGraphic) {
                Image oldImage = ((UISWTGraphic)oldGraphic).getImage();
                Utils.disposeSWTObjects(new Object[]{oldImage});
            }
        }
    }
}

