/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRate
extends CoreTableColumn
implements TableCellAddedListener {
    static Font font = null;
    static Font smallFont = null;

    public ColumnRate(String sTableID) {
        super("Rating", sTableID);
        this.initializeAsGraphic(-2, 40);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener,
    TableCellMouseListener {
        String rating = "--";

        public Cell(TableCell cell) {
            boolean isContent;
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null && !(isContent = PlatformTorrentUtils.isContent(dm.getTorrent()))) {
                this.rating = "";
                return;
            }
        }

        public void dispose(TableCell cell) {
            this.disposeOldImage(cell);
        }

        public void refresh(TableCell cell) {
            boolean b;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            TOTorrent torrent = dm.getTorrent();
            String rating = GlobalRatingUtils.getRatingString(torrent);
            long count = GlobalRatingUtils.getCount(torrent);
            try {
                b = !cell.setSortValue(Float.parseFloat(rating) * 100000.0f + (float)count);
            }
            catch (Exception e) {
                boolean bl = b = !cell.setSortValue(new Float(count));
            }
            if (b && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            int width = cell.getWidth();
            int height = cell.getHeight();
            if (width <= 0 || height <= 0) {
                return;
            }
            Image img = new Image((Device)Display.getDefault(), width, height);
            GC gcImage = new GC((Drawable)img);
            Color background = ((TableRowCore)cell.getTableRow()).getBackground();
            if (background != null) {
                gcImage.setBackground(background);
                gcImage.fillRectangle(0, 0, width, height);
            }
            if (font == null) {
                FontData[] fontData = gcImage.getFont().getFontData();
                fontData[0].setHeight(Utils.pixelsToPoint(20, Display.getDefault().getDPI().y));
                fontData[0].setStyle(1);
                font = new Font((Device)Display.getDefault(), fontData);
            }
            gcImage.setFont(font);
            SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
            Color bg = ((TableCellImpl)cell).getTableRowCore().getBackground();
            HSLColor hsl = new HSLColor();
            hsl.initHSLbyRGB(bg.getRed(), bg.getGreen(), bg.getBlue());
            hsl.setLuminence(hsl.getLuminence() - 10);
            Color color2 = ColorCache.getColor((Device)Display.getDefault(), hsl.getRed(), hsl.getGreen(), hsl.getBlue());
            Rectangle r = img.getBounds();
            r.x += 2;
            r.y += 2;
            if (color2 != null) {
                gcImage.setForeground(color2);
            }
            r.height -= 12;
            GCStringPrinter.printString(gcImage, rating, r, true, false, 0x1000000);
            Color color1 = ColorCache.getColor((Device)Display.getDefault(), GlobalRatingUtils.getColor(torrent));
            if (color1 == null) {
                color1 = skinProperties.getColor("color.row.fg");
            }
            r = img.getBounds();
            r.height -= 12;
            gcImage.setForeground(color1);
            GCStringPrinter.printString(gcImage, rating, r, true, false, 0x1000000);
            if (count > 0L) {
                if (smallFont == null) {
                    gcImage.setFont(null);
                    FontData[] fontData = gcImage.getFont().getFontData();
                    fontData[0].setHeight(Utils.pixelsToPoint(9, Display.getDefault().getDPI().y));
                    smallFont = new Font((Device)Display.getDefault(), fontData);
                }
                gcImage.setFont(smallFont);
                GCStringPrinter.printString(gcImage, "" + count + " ratings", img.getBounds(), true, false, 1024);
            }
            gcImage.dispose();
            UISWTGraphicImpl graphic = new UISWTGraphicImpl(img);
            this.disposeOldImage(cell);
            cell.setGraphic(graphic);
        }

        private void disposeOldImage(TableCell cell) {
            Image image;
            Graphic oldGraphic = cell.getGraphic();
            if (oldGraphic instanceof UISWTGraphic && (image = ((UISWTGraphic)oldGraphic).getImage()) != null && !image.isDisposed()) {
                image.dispose();
            }
        }

        public void cellMouseTrigger(TableCellMouseEvent event2) {
            if (event2.eventType == 1 && event2.button == 2) {
                DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
                if (dm == null) {
                    return;
                }
                TOTorrent torrent = dm.getTorrent();
                GlobalRatingUtils.updateFromPlatform(torrent, 0L);
                Utils.beep();
            }
        }
    }
}

