/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnRateUpDown
extends CoreTableColumn
implements TableCellAddedListener {
    private static UISWTGraphicImpl graphicRateMe;
    private static UISWTGraphicImpl graphicUp;
    private static UISWTGraphicImpl graphicDown;
    private static UISWTGraphicImpl graphicWait;
    private static Rectangle boundsRateMe;
    private static int width;

    public ColumnRateUpDown(String sTableID) {
        super("RateIt", sTableID);
        this.initializeAsGraphic(-2, width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    static {
        Image img = ImageLoaderFactory.getInstance().getImage("icon.rateme");
        graphicRateMe = new UISWTGraphicImpl(img);
        boundsRateMe = img.getBounds();
        width = ColumnRateUpDown.boundsRateMe.width;
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.up");
        graphicUp = new UISWTGraphicImpl(img);
        width = Math.max(width, img.getBounds().width);
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.down");
        graphicDown = new UISWTGraphicImpl(img);
        width = Math.max(width, img.getBounds().width);
        img = ImageLoaderFactory.getInstance().getImage("icon.rate.wait");
        graphicWait = new UISWTGraphicImpl(img);
        width = Math.max(width, img.getBounds().width);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellMouseListener {
        boolean bMouseDowned = false;

        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void refresh(TableCell cell) {
            UISWTGraphicImpl graphic;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            if (!PlatformTorrentUtils.isContent(dm.getTorrent())) {
                return;
            }
            if (!dm.isDownloadComplete(false)) {
                return;
            }
            int rating = PlatformTorrentUtils.getUserRating(dm.getTorrent());
            if (!cell.setSortValue(rating) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            switch (rating) {
                case -2: {
                    graphic = graphicWait;
                    break;
                }
                case -1: {
                    graphic = graphicRateMe;
                    break;
                }
                case 0: {
                    graphic = graphicDown;
                    break;
                }
                case 1: {
                    graphic = graphicUp;
                    break;
                }
                default: {
                    graphic = null;
                }
            }
            cell.setGraphic(graphic);
        }

        public void cellMouseTrigger(final TableCellMouseEvent event2) {
            DownloadManager dm;
            if (event2.eventType == 1 && event2.button == 2) {
                dm = (DownloadManager)event2.cell.getDataSource();
                if (dm == null) {
                    return;
                }
                final TOTorrent torrent = dm.getTorrent();
                try {
                    final String fHash = torrent.getHashWrapper().toString();
                    PlatformRatingMessenger.getUserRating(new String[]{"content"}, new String[]{fHash}, 5000L, new PlatformRatingMessenger.GetRatingReplyListener(){

                        public void replyReceived(String replyType, PlatformRatingMessenger.GetRatingReply reply) {
                            long rating;
                            if (replyType.equals(PlatformMessenger.REPLY_RESULT) && (rating = reply.getRatingValue(fHash, "content")) >= -1L) {
                                PlatformTorrentUtils.setUserRating(torrent, (int)rating);
                                event2.cell.invalidate();
                            }
                        }

                        public void messageSent() {
                        }
                    });
                }
                catch (TOTorrentException e) {
                    Debug.out(e);
                }
                Utils.beep();
            }
            if (event2.button != 1) {
                return;
            }
            if (!event2.cell.getTableRow().isSelected()) {
                return;
            }
            dm = (DownloadManager)event2.cell.getDataSource();
            if (dm == null) {
                return;
            }
            if (!PlatformTorrentUtils.isContent(dm.getTorrent())) {
                return;
            }
            if (!dm.isDownloadComplete(false)) {
                return;
            }
            if (event2.eventType == 0) {
                this.bMouseDowned = true;
                return;
            }
            if (event2.eventType == 1 && this.bMouseDowned) {
                Comparable sortValue = event2.cell.getSortValue();
                if (sortValue == null || sortValue.equals(new Long(-1L))) {
                    int cellWidth = event2.cell.getWidth();
                    int cellHeight = event2.cell.getHeight();
                    int x = event2.x - (cellWidth - boundsRateMe.width) / 2;
                    int y = event2.y - (cellHeight - boundsRateMe.height) / 2;
                    if (x >= 0 && y >= 0 && x < boundsRateMe.width && y < boundsRateMe.height) {
                        try {
                            final TOTorrent torrent = dm.getTorrent();
                            String hash = torrent.getHashWrapper().toBase32String();
                            final int value = x < boundsRateMe.height - y + 1 ? 1 : 0;
                            PlatformTorrentUtils.setUserRating(torrent, -2);
                            event2.cell.invalidate();
                            PlatformRatingMessenger.setUserRating(hash, value, 0L, new PlatformMessengerListener(){

                                public void replyReceived(PlatformMessage message, String replyType, Object jsonReply) {
                                    if (PlatformRatingMessenger.ratingSucceeded(jsonReply)) {
                                        PlatformTorrentUtils.setUserRating(torrent, value);
                                        GlobalRatingUtils.updateFromPlatform(torrent, 2000L);
                                    } else {
                                        PlatformTorrentUtils.setUserRating(torrent, -1);
                                    }
                                    event2.cell.invalidate();
                                }

                                public void messageSent(PlatformMessage message) {
                                }
                            });
                        }
                        catch (TOTorrentException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        final TOTorrent torrent = dm.getTorrent();
                        String hash = torrent.getHashWrapper().toBase32String();
                        final int oldValue = PlatformTorrentUtils.getUserRating(torrent);
                        if (oldValue == -2) {
                            return;
                        }
                        PlatformTorrentUtils.setUserRating(torrent, -2);
                        event2.cell.invalidate();
                        PlatformRatingMessenger.setUserRating(hash, -1, 0L, new PlatformMessengerListener(){

                            public void replyReceived(PlatformMessage message, String replyType, Object jsonReply) {
                                if (PlatformRatingMessenger.ratingSucceeded(jsonReply)) {
                                    PlatformTorrentUtils.setUserRating(torrent, -1);
                                    GlobalRatingUtils.updateFromPlatform(torrent, 2000L);
                                } else {
                                    PlatformTorrentUtils.setUserRating(torrent, oldValue == -2 ? -1 : oldValue);
                                }
                                event2.cell.invalidate();
                            }

                            public void messageSent(PlatformMessage message) {
                            }
                        });
                    }
                    catch (TOTorrentException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.bMouseDowned = false;
        }
    }
}

