/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnSpeed
extends CoreTableColumn
implements TableCellAddedListener {
    private static boolean DEBUG = false;
    static final String[] ICON_NAMES = new String[]{"icon.speed.0", "icon.speed.1", "icon.speed.2", "icon.speed.3", "icon.speed.4"};
    static UISWTGraphic[] graphics = new UISWTGraphic[ICON_NAMES.length];
    private static int width = 0;

    public ColumnSpeed(String sTableID) {
        super("SpeedGraphic", sTableID);
        this.initializeAsGraphic(-2, width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    static {
        for (int i = 0; i < graphics.length; ++i) {
            Image img = ImageLoaderFactory.getInstance().getImage(ICON_NAMES[i]);
            ColumnSpeed.graphics[i] = new UISWTGraphicImpl(img);
            width = Math.max(width, img.getBounds().width);
        }
    }

    private class Cell
    implements TableCellRefreshListener {
        public Cell(TableCell cell) {
            cell.addListeners(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void refresh(TableCell cell) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            int index = 0;
            int state = dm.getState();
            if (state == 50 || state == 60) {
                long speed;
                boolean bComplete = dm.isDownloadComplete(false);
                long l = speed = bComplete ? dm.getStats().getDataSendRate() : dm.getStats().getDataReceiveRate();
                if (speed < 1024L) {
                    index = 0;
                } else {
                    GlobalManager gm = dm.getGlobalManager();
                    GlobalManagerStats stats = gm.getStats();
                    int maxSpeed = COConfigurationManager.getIntParameter(bComplete ? TransferSpeedValidator.getActiveUploadParameter(gm) : "Max Download Speed KBs", 0) * 1024;
                    if (maxSpeed != 0) {
                        index = speed >= (long)maxSpeed ? 4 : (int)Math.round((double)ICON_NAMES.length * (double)speed / (double)maxSpeed);
                        if (DEBUG) {
                            System.out.println("speed=" + speed + ";ms=" + maxSpeed + ";" + (double)speed / (double)maxSpeed + ";" + index);
                        }
                    } else {
                        int globalSpeed = bComplete ? stats.getDataSendRate() : stats.getDataReceiveRate();
                        index = (int)Math.round((double)ICON_NAMES.length * (double)speed / (double)globalSpeed);
                        if (DEBUG) {
                            System.out.println("speed=" + speed + ";gs=" + globalSpeed + ";" + (double)speed / (double)globalSpeed + ";" + index);
                        }
                    }
                }
                if (index >= ICON_NAMES.length) {
                    index = ICON_NAMES.length - 1;
                }
            } else {
                if (dm.isDownloadComplete(false)) {
                    index = -1;
                } else {
                    TRTrackerScraperResponse scrape = dm.getTrackerScrapeResponse();
                    if (scrape != null) {
                        int seeds = scrape.getSeeds();
                        int peers = scrape.getPeers();
                        index = peers > 0 ? (int)((double)seeds / (double)peers * (double)ICON_NAMES.length) : (seeds == 0 ? 0 : 4);
                    }
                }
                index = -1;
            }
            if (!cell.setSortValue(index) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setGraphic(index < 0 || index >= graphics.length ? null : graphics[index]);
        }
    }
}

