/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnTitle
extends CoreTableColumn
implements TableCellRefreshListener,
ObfusticateCellText {
    public static String s = "";

    public ColumnTitle(String sTableID) {
        super("name", -2, 250, sTableID);
        this.setObfustication(true);
        this.setType(1);
    }

    public void refresh(TableCell cell) {
        int pos;
        String path;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (name = PlatformTorrentUtils.getContentTitle(dm.getTorrent())) == null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (name.length() > 0 && (path = dm.getDownloadState().getPrimaryFile()) != null && (pos = path.lastIndexOf(46)) >= 0) {
            String ext = path.substring(pos);
            Program program = Program.findProgram((String)ext);
            if (program != null) {
                ext = ext + " (" + program.getName() + ")";
            }
            name = name + "\n" + MessageText.getString("TableColumn.header.name.ext", new String[]{ext});
        }
        cell.setText(name);
    }

    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }
}

