/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells;

import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class BrowserWindow {
    private Shell shell;

    public BrowserWindow(Shell parent, String url, int w, int h, boolean allowResize) {
        int style = 2144;
        if (allowResize) {
            style |= 0x10;
        }
        this.shell = ShellFactory.createShell(parent, style);
        this.shell.setLayout((Layout)new FillLayout());
        Utils.setShellIcon(this.shell);
        Browser browser = new Browser((Composite)this.shell, 0);
        BrowserContext context = new BrowserContext("browser-window" + Math.random(), browser, null);
        context.addMessageListener(new TorrentListener());
        context.addMessageListener(new DisplayListener(browser));
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event2) {
                BrowserWindow.this.shell.open();
            }

            public void changed(ProgressEvent event2) {
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event2) {
                BrowserWindow.this.shell.dispose();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                BrowserWindow.this.shell.setText(event2.title);
            }
        });
        if (w > 0 && h > 0) {
            this.shell.setSize(w, h);
        }
        Utils.centerWindowRelativeTo(this.shell, (Control)parent);
        browser.setUrl(url);
        browser.setData("StartURL", (Object)url);
    }

    public void waitUntilClosed() {
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 2144);
        new BrowserWindow(shell, "http://google.com", 500, 200, true);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

