/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.ui.swt.KeyBindings;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.help.AboutWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;

public class MainMenu {
    final String PREFIX_V2 = "MainWindow.menu";
    final String PREFIX_V3 = "MainWindow.v3.menu";
    private Menu menuBar;
    private final SWTSkin skin;

    public MainMenu(SWTSkin skin, Shell shell) {
        this.skin = skin;
        this.buildMenu(shell);
    }

    private void buildMenu(Shell parent) {
        this.menuBar = new Menu((Decorations)parent, 2);
        this.addFileMenu(parent);
        this.addViewMenu(parent);
        this.addHelpMenu(parent);
        parent.setMenuBar(this.menuBar);
    }

    public void linkMenuBar(Shell parent) {
        parent.setMenuBar(this.menuBar);
    }

    private void addHelpMenu(final Shell parent) {
        final Display display = parent.getDisplay();
        MenuItem helpItem = new MenuItem(this.menuBar, 64);
        Messages.setLanguageText((Widget)helpItem, "MainWindow.menu.help");
        Menu helpMenu = new Menu((Decorations)parent, 4);
        helpItem.setMenu(helpMenu);
        if (!Constants.isOSX) {
            MenuItem help_about = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_about, "MainWindow.menu.help.about");
            help_about.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    AboutWindow.show(display);
                }
            });
            new MenuItem(helpMenu, 2);
        }
        MenuItem help_whatsnew = new MenuItem(helpMenu, 0);
        Messages.setLanguageText((Widget)help_whatsnew, "MainWindow.menu.help.releasenotes");
        help_whatsnew.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new WelcomeWindow(parent);
            }
        });
        MenuItem help_faq = new MenuItem(helpMenu, 0);
        Messages.setLanguageText((Widget)help_faq, "MainWindow.menu.help.faq");
        help_faq.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String faqString = "http://www.azureuswiki.com/index.php/";
                Utils.launch(faqString);
            }
        });
        new MenuItem(helpMenu, 2);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuItem help_checkupdate = new MenuItem(helpMenu, 0);
            KeyBindings.setAccelerator(help_checkupdate, "MainWindow.menu.help.checkupdate");
            Messages.setLanguageText((Widget)help_checkupdate, "MainWindow.menu.help.checkupdate");
            help_checkupdate.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uiFunctions != null) {
                        uiFunctions.bringToFront();
                    }
                    AzureusCore core = AzureusCoreFactory.getSingleton();
                    UpdateMonitor.getSingleton(core).performCheck(true, false, new UpdateCheckInstanceListener(){

                        public void cancelled(UpdateCheckInstance instance) {
                        }

                        public void complete(UpdateCheckInstance instance) {
                            if (instance.getUpdates().length == 0) {
                                Utils.execSWTThread(new AERunnable(){

                                    public void runSupport() {
                                        Utils.openMessageBox(parent, 34, "window.update.noupdates", (String[])null);
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }
    }

    private void addViewMenu(Shell parent) {
        MenuItem viewItem = new MenuItem(this.menuBar, 64);
        Messages.setLanguageText((Widget)viewItem, "MainWindow.menu.view");
        Menu viewMenu = new Menu((Decorations)parent, 4);
        viewItem.setMenu(viewMenu);
        this.addViewMenuItems(viewMenu);
    }

    private void addViewMenuItems(Menu viewMenu) {
        this.createMenuItem(viewMenu, "MainWindow.v3.menu.home", new Listener(){

            public void handleEvent(Event event2) {
                MainMenu.this.skin.setActiveTab("maintabs", "maintabs.home");
            }
        });
        this.createMenuItem(viewMenu, "MainWindow.v3.menu.browse", new Listener(){

            public void handleEvent(Event event2) {
                MainMenu.this.skin.setActiveTab("maintabs", "maintabs.browse");
            }
        });
        this.createMenuItem(viewMenu, "MainWindow.v3.menu.library", new Listener(){

            public void handleEvent(Event event2) {
                MainMenu.this.skin.setActiveTab("maintabs", "maintabs.library");
            }
        });
        this.createMenuItem(viewMenu, "MainWindow.v3.menu.publish", new Listener(){

            public void handleEvent(Event event2) {
                MainMenu.this.skin.setActiveTab("maintabs", "maintabs.publish");
            }
        });
        new MenuItem(viewMenu, 2);
        this.createMenuItem(viewMenu, "MainWindow.v3.menu.advanced", new Listener(){

            public void handleEvent(Event event2) {
                MainMenu.this.skin.setActiveTab("maintabs", "maintabs.advanced");
            }
        });
    }

    private void addFileMenu(Shell parent) {
        MenuItem fileItem = new MenuItem(this.menuBar, 64);
        Messages.setLanguageText((Widget)fileItem, "MainWindow.menu.file");
        Menu fileMenu = new Menu((Decorations)parent, 4);
        fileItem.setMenu(fileMenu);
        this.createMenuItem(fileMenu, "MainWindow.menu.file.open", new Listener(){

            public void handleEvent(Event event2) {
                TorrentOpener.openTorrentSimple();
            }
        });
        if (!Constants.isOSX) {
            new MenuItem(fileMenu, 2);
            MenuItem file_restart = new MenuItem(fileMenu, 0);
            Messages.setLanguageText((Widget)file_restart, "MainWindow.menu.file.restart");
            file_restart.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(true, false);
                }
            });
            final MenuItem file_exit = new MenuItem(fileMenu, 0);
            if (!COConfigurationManager.getBooleanParameter("Enable System Tray") || !COConfigurationManager.getBooleanParameter("Close To Tray")) {
                KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
            }
            Messages.setLanguageText((Widget)file_exit, "MainWindow.menu.file.exit");
            file_exit.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(false, false);
                }
            });
            ParameterListener paramListener = new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    if (COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                        KeyBindings.removeAccelerator(file_exit, "MainWindow.menu.file.exit");
                    } else {
                        KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
                    }
                }
            };
            COConfigurationManager.addParameterListener("Enable System Tray", paramListener);
            COConfigurationManager.addParameterListener("Close To Tray", paramListener);
        }
    }

    private MenuItem createMenuItem(Menu parent, String key, Listener selectionListener2) {
        return this.createMenuItem(parent, 8, key, selectionListener2);
    }

    private MenuItem createMenuItem(Menu parent, int style, String key, Listener selectionListener2) {
        MenuItem item = new MenuItem(parent, style);
        Messages.setLanguageText((Widget)item, key);
        KeyBindings.setAccelerator(item, key);
        item.addListener(13, selectionListener2);
        return item;
    }

    public void addToOldMenuView(Menu viewMenu) {
        new MenuItem(viewMenu, 2);
        this.addViewMenuItems(viewMenu);
        new MenuItem(viewMenu, 2);
        this.createViewMenuItem(viewMenu, "SearchBar.visible", "searchbar");
        this.createViewMenuItem(viewMenu, "TabBar.visible", "tabbar");
    }

    private void createViewMenuItem(Menu viewMenu, final String configID, final String keyID) {
        COConfigurationManager.setBooleanDefault(configID, true);
        MenuItem item = this.createMenuItem(viewMenu, 32, "MainWindow.v3.menu.view." + keyID, new Listener(){

            public void handleEvent(Event event2) {
                MenuItem item = (MenuItem)event2.widget;
                boolean visible = item.getSelection();
                MainMenu.this.setVisibility(configID, keyID, visible);
            }
        });
        this.setVisibility(configID, keyID, COConfigurationManager.getBooleanParameter(configID));
        final MenuItem itemViewSearchBar = item;
        final ParameterListener listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                itemViewSearchBar.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener(configID, listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener(configID, listener);
            }
        });
    }

    public void setVisibility(String configID, String viewID, boolean visible) {
        SWTSkinObject skinObject = this.skin.getSkinObject(viewID);
        if (skinObject != null) {
            Control control = skinObject.getControl();
            if (visible) {
                FormData fd;
                Point size = (Point)control.getData("v3.oldHeight");
                if (size != null && (fd = (FormData)control.getLayoutData()) != null && (fd.width != size.x || fd.height != size.y)) {
                    this.slide(control, fd, size);
                }
            } else {
                FormData fd = (FormData)control.getLayoutData();
                if (fd != null) {
                    control.setData("v3.oldHeight", (Object)new Point(fd.width, fd.height));
                    Point size = new Point(0, 0);
                    this.slide(control, fd, size);
                }
            }
            COConfigurationManager.setParameter(configID, visible);
            Utils.relayout(control);
        }
    }

    private void slide(final Control control, final FormData fd, final Point size) {
        AERunnable runnable = new AERunnable(){

            public void runSupport() {
                fd.width = size.x;
                fd.height = size.y;
                control.setLayoutData((Object)fd);
                Utils.relayout(control);
            }

            static /* synthetic */ Control access$300(17 x0) {
                return x0.control;
            }
        };
        control.getDisplay().asyncExec((Runnable)runnable);
    }
}

