/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.search.network.NetworkSearch;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSet;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSetListener;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.PublishUtils;
import com.aelitis.azureus.ui.swt.utils.UIUpdatable;
import com.aelitis.azureus.ui.swt.utils.UIUpdater;
import com.aelitis.azureus.ui.swt.utils.UIUpdaterFactory;
import com.aelitis.azureus.ui.swt.views.RecommendationsView;
import com.aelitis.azureus.ui.swt.views.skin.Browse;
import com.aelitis.azureus.ui.swt.views.skin.ManageCdList;
import com.aelitis.azureus.ui.swt.views.skin.ManageDlList;
import com.aelitis.azureus.ui.swt.views.skin.MediaList;
import com.aelitis.azureus.ui.swt.views.skin.MiniBrowse;
import com.aelitis.azureus.ui.swt.views.skin.MiniDownloadList;
import com.aelitis.azureus.ui.swt.views.skin.MiniRecentList;
import com.aelitis.azureus.ui.swt.views.skin.Publish;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.util.Constants;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindow
implements SWTSkinTabSetListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    protected Shell shell;
    private final Display display;
    private final AzureusCore core;
    private SWTSkin skin;
    private org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMainWindow;
    private org.gudy.azureus2.ui.swt.mainwindow.MainMenu oldMainMenu;
    private MainMenu menu;
    private UISWTInstanceImpl uiSWTInstanceImpl;
    private UIFunctionsImpl uiFunctions;
    private SystemTraySWT systemTraySWT;
    private Map mapTrackUsage;
    private AEMonitor mapTrackUsage_mon = new AEMonitor("mapTrackUsage");
    private long lCurrentTrackTime = 0L;
    private boolean disposedOrDisposing;
    private Object[] dms_Startup;

    public static void main(String[] args) {
        Initializer.main(new String[0]);
    }

    public MainWindow(AzureusCore core, Display display, final SplashWindow splash) {
        this.core = core;
        this.display = display;
        this.disposedOrDisposing = false;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow.this.createWindow(splash);
                if (splash != null) {
                    splash.closeSplash();
                }
            }
        });
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray();
        gm.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindow.this.downloadAdded(dm);
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
    }

    private void processStartupDMS() {
        AEThread thread = new AEThread("v3.mw.dmAdded", true){

            public void runSupport() {
                long startTime = System.currentTimeMillis();
                if (MainWindow.this.dms_Startup == null || MainWindow.this.dms_Startup.length == 0) {
                    return;
                }
                for (int i = 0; i < MainWindow.this.dms_Startup.length; ++i) {
                    DownloadManager dm = (DownloadManager)MainWindow.this.dms_Startup[i];
                    MainWindow.this.downloadAdded(dm);
                }
                MainWindow.access$102(MainWindow.this, null);
                System.out.println("psDMS " + (SystemTime.getCurrentTime() - startTime) + "ms");
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    private void downloadAdded(DownloadManager dm) {
        final TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            Debug.out(e);
        }
        String title = PlatformTorrentUtils.getContentTitle(torrent);
        if (title != null && title.length() > 0 && dm.getDownloadState().getDisplayName() == null) {
            dm.getDownloadState().setDisplayName(title);
        }
        if (this.skin != null && PlatformTorrentUtils.isContent(torrent) && SystemTime.getCurrentTime() - dm.getDownloadState().getLongParameter("stats.download.added.time") < 10000L && !PublishUtils.isPublished(dm)) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    int ret;
                    Display current;
                    SWTSkinTabSet tabSetMain = MainWindow.this.skin.getTabSet("maintabs");
                    if (tabSetMain != null && !tabSetMain.getActiveTab().getSkinObjectID().equals("maintabs.home") && (current = Display.getCurrent()) != null && current.getFocusControl() != null && !MessageBoxShell.isOpen() && (ret = MessageBoxShell.open(MainWindow.this.shell, MessageText.getString("HomeReminder.title"), MessageText.getString("HomeReminder.text", new String[]{PlatformTorrentUtils.getContentTitle(torrent)}), new String[]{MessageText.getString("Button.ok"), MessageText.getString("HomeReminder.gohome")}, 0, "downloadinhome", MessageText.getString("MessageBoxWindow.nomoreprompting"), false, 15000)) == 1) {
                        tabSetMain.setActiveTab("maintabs.home");
                    }
                }
            });
        }
        final String fHash = hash;
        if (PlatformTorrentUtils.isContent(torrent)) {
            if (PlatformTorrentUtils.getUserRating(torrent) == -2) {
                PlatformTorrentUtils.setUserRating(torrent, -1);
                PlatformRatingMessenger.getUserRating(new String[]{"content"}, new String[]{hash}, 5000L, new PlatformRatingMessenger.GetRatingReplyListener(){

                    public void replyReceived(String replyType, PlatformRatingMessenger.GetRatingReply reply) {
                        long rating;
                        if (replyType.equals(PlatformMessenger.REPLY_RESULT) && (rating = reply.getRatingValue(fHash, "content")) >= -1L) {
                            PlatformTorrentUtils.setUserRating(torrent, (int)rating);
                        }
                    }

                    public void messageSent() {
                    }
                });
            }
            long now = SystemTime.getCurrentTime();
            long mdRefreshOn = PlatformTorrentUtils.getMetaDataRefreshOn(torrent);
            if (mdRefreshOn < now) {
                PlatformTorrentUtils.log("addDM, update MD NOW");
                PlatformTorrentUtils.updateMetaData(torrent, 5000L);
            } else {
                PlatformTorrentUtils.log("addDM, update MD on " + new Date(mdRefreshOn));
                SimpleTimer.addEvent("Update MD", mdRefreshOn, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        PlatformTorrentUtils.updateMetaData(torrent, 15000L);
                    }
                });
            }
            long grRefreshOn = GlobalRatingUtils.getRefreshOn(torrent);
            if (grRefreshOn <= now) {
                GlobalRatingUtils.updateFromPlatform(torrent, 5000L);
            } else {
                SimpleTimer.addEvent("Update G.Rating", grRefreshOn, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        GlobalRatingUtils.updateFromPlatform(torrent, 15000L);
                    }
                });
            }
        }
    }

    protected void createWindow(SplashWindow splash) {
        long startTime = SystemTime.getCurrentTime();
        this.uiFunctions = new UIFunctionsImpl(this);
        UIFunctionsManager.setUIFunctions(this.uiFunctions);
        Utils.disposeComposite((Composite)this.shell);
        splash.reportPercent(60);
        ImageRepository.loadImagesForSplashWindow(this.display);
        ImageRepository.loadImages(this.display);
        this.shell = new Shell(this.display, 1264);
        this.shell.setData("class", (Object)this);
        this.shell.setText("Azureus");
        Utils.setShellIcon(this.shell);
        Utils.linkShellMetricsToConfig(this.shell, "window");
        this.setupUsageTracker();
        splash.reportPercent(70);
        this.skin = SWTSkinFactory.getInstance();
        this.initSkinListeners();
        this.uiSWTInstanceImpl = new UISWTInstanceImpl(this.core);
        this.uiSWTInstanceImpl.init();
        this.skin.initialize(this.shell, "main.shell");
        splash.reportPercent(80);
        System.out.println("skin init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.menu = new MainMenu(this.skin, this.shell);
        if (org.gudy.azureus2.core3.util.Constants.isOSX) {
            try {
                Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                Method method = ehancerClass.getMethod("registerToolbarToggle", Shell.class);
                method.invoke(null, this.shell);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            Listener toggleListener = new Listener(){

                public void handleEvent(Event event2) {
                    boolean bVisible = event2.type == 17;
                    MainWindow.this.menu.setVisibility("SearchBar.visible", "searchbar", bVisible);
                }
            };
            this.shell.addListener(17, toggleListener);
            this.shell.addListener(18, toggleListener);
        }
        System.out.println("createWindow init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        splash.reportPercent(90);
        this.skin.layout();
        System.out.println("skin layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        try {
            Utils.createTorrentDropTarget((Composite)this.shell, true);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
        }
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MainWindow.this.dispose(false, false);
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event2) {
                if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                    MainWindow.this.minimizeToTray(event2);
                } else {
                    event2.doit = MainWindow.this.dispose(false, false);
                }
            }

            public void shellIconified(ShellEvent event2) {
                if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray")) {
                    MainWindow.this.minimizeToTray(event2);
                }
            }
        });
        this.shell.addListener(20, new Listener(){

            public void handleEvent(Event e) {
                if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled")) {
                    e.doit = false;
                    MainWindow.this.shell.setVisible(false);
                    PasswordWindow.showPasswordWindow(MainWindow.this.display);
                }
            }
        });
        this.initWidgets();
        System.out.println("skin widgets init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.showMainWindow();
        System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.processStartupDMS();
        System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose(boolean bForRestart, boolean bCloseAlreadyInProgress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        this.disposedOrDisposing = true;
        if (this.oldMainWindow != null) {
            boolean res = this.oldMainWindow.dispose(bForRestart, bCloseAlreadyInProgress);
            this.oldMainWindow = null;
            if (!res) {
                return false;
            }
        } else {
            if (!UIExitUtilsSWT.canClose(this.core.getGlobalManager(), bForRestart)) {
                return false;
            }
            UIExitUtilsSWT.uiShutdown();
        }
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        if (!SWTThread.getInstance().isTerminated()) {
            SWTThread.getInstance().getInitializer().stopIt(bForRestart, false);
        }
        this.mapTrackUsage_mon.enter();
        try {
            if (this.mapTrackUsage != null) {
                SWTSkinTabSet tabSetMain = this.skin.getTabSet("maintabs");
                if (tabSetMain != null) {
                    this.updateMapTrackUsage(tabSetMain.getActiveTab().getSkinObjectID());
                }
                FileUtil.writeResilientFile(new File(SystemProperties.getUserPath(), "timingstats.dat"), this.mapTrackUsage);
            }
        }
        finally {
            this.mapTrackUsage_mon.exit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUsageTracker() {
        this.mapTrackUsage_mon.enter();
        try {
            if (COConfigurationManager.getBooleanParameter("Send Version Info")) {
                this.mapTrackUsage = new HashMap();
                File f = new File(SystemProperties.getUserPath(), "timingstats.dat");
                if (f.exists()) {
                    final Map oldMapTrackUsage = FileUtil.readResilientFile(f);
                    PlatformConfigMessenger.sendUsageStats(oldMapTrackUsage, f.lastModified(), new PlatformMessengerListener(){

                        public void messageSent(PlatformMessage message) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void replyReceived(PlatformMessage message, String replyType, Object jsonReply) {
                            if (MainWindow.this.mapTrackUsage == null) {
                                return;
                            }
                            MainWindow.this.mapTrackUsage_mon.enter();
                            try {
                                if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
                                    Iterator iterator = oldMapTrackUsage.keySet().iterator();
                                    while (iterator.hasNext()) {
                                        String key = (String)iterator.next();
                                        Long value = (Long)oldMapTrackUsage.get(key);
                                        Long oldValue = (Long)MainWindow.this.mapTrackUsage.get(key);
                                        if (oldValue != null) {
                                            value = new Long(value + oldValue);
                                        }
                                        MainWindow.this.mapTrackUsage.put(key, value);
                                    }
                                }
                            }
                            finally {
                                MainWindow.this.mapTrackUsage_mon.exit();
                            }
                        }
                    });
                }
                SimpleTimer.addPeriodicEvent("UsageTracker", 1000L, new TimerEventPerformer(){
                    long lLastMouseMove = 0L;
                    Point ptLastMousePos = new Point(0, 0);

                    public void perform(TimerEvent event2) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if ((this).MainWindow.this.shell == null || (this).MainWindow.this.shell.isDisposed()) {
                                    return;
                                }
                                Point pt = (this).MainWindow.this.shell.getDisplay().getCursorLocation();
                                if (pt.equals((Object)ptLastMousePos)) {
                                    return;
                                }
                                ptLastMousePos = pt;
                                long now = SystemTime.getCurrentTime();
                                long diff = now - lLastMouseMove;
                                if (diff < 10000L) {
                                    MainWindow.this.lCurrentTrackTime += diff;
                                }
                                lLastMouseMove = now;
                            }
                        });
                    }
                });
            } else {
                this.mapTrackUsage = null;
            }
        }
        finally {
            this.mapTrackUsage_mon.exit();
        }
    }

    private void showMainWindow() {
        boolean bStartMinimize;
        boolean isOSX = org.gudy.azureus2.core3.util.Constants.isOSX;
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray") && (!isOSX || SWT.getVersion() > 3300);
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled", false);
        boolean bl = bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized", false));
        if (!bStartMinimize) {
            this.shell.layout();
            this.shell.open();
            if (!isOSX) {
                this.shell.forceActive();
            }
        } else if (isOSX) {
            this.shell.setMinimized(true);
            this.shell.setVisible(true);
        }
        this.shell.layout(true, true);
        if (bEnableTray) {
            try {
                this.systemTraySWT = new SystemTraySWT();
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true);
            }
        }
        AssociationChecker.checkAssociations();
        this.core.triggerLifeCycleComponentCreated(this.uiFunctions);
        this.core.getPluginManager().firePluginEvent(6);
        boolean hasInComplete = false;
        Object[] dms = this.core.getGlobalManager().getDownloadManagers().toArray();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = (DownloadManager)dms[i];
            if (dm.getAssumedComplete()) continue;
            hasInComplete = true;
            break;
        }
        String startTab = hasInComplete ? "maintabs.home" : "maintabs.browse";
        SWTSkinTabSet tabSet = this.skin.getTabSet("maintabs");
        if (tabSet != null) {
            COConfigurationManager.setBooleanDefault("v3.Start Advanced", false);
            if (COConfigurationManager.getBooleanParameter("v3.Start Advanced")) {
                startTab = "maintabs.advanced";
            }
            tabSet.setActiveTab(startTab);
        }
    }

    public void setVisible(final boolean visible) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (visible && !MainWindow.this.shell.getVisible() && COConfigurationManager.getBooleanParameter("Password enabled", false) && !PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                    MainWindow.this.shell.setVisible(false);
                    return;
                }
                MainWindow.this.shell.setVisible(visible);
                if (visible) {
                    MainWindow.this.shell.forceActive();
                    MainWindow.this.shell.setMinimized(false);
                }
            }
        });
    }

    private void minimizeToTray(ShellEvent event2) {
        boolean isOSX = org.gudy.azureus2.core3.util.Constants.isOSX;
        if (event2 != null) {
            event2.doit = false;
        }
        if (isOSX) {
            this.shell.setMinimized(true);
        } else {
            this.shell.setVisible(false);
        }
        MinimizedWindow.setAllVisible(true);
    }

    private void initSkinListeners() {
        final HashMap<String, Class> views = new HashMap<String, Class>();
        views.put("minibrowse", MiniBrowse.class);
        views.put("minidownload-list", MiniDownloadList.class);
        views.put("minirecent-list", MiniRecentList.class);
        views.put("browse", Browse.class);
        views.put("manage-dl-list", ManageDlList.class);
        views.put("manage-cd-list", ManageCdList.class);
        views.put("my-media-list", MediaList.class);
        views.put("publish", Publish.class);
        SWTSkinObjectListener l = new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                String key;
                Class cla;
                if (eventType == 0 && (cla = (Class)views.get(key = skinObject.getViewID())) != null) {
                    try {
                        SkinView skinView = (SkinView)cla.newInstance();
                        SkinViewManager.add(skinView);
                        skinObject.addListener(skinView);
                        skinView.eventOccured(skinObject, eventType, params);
                        views.remove(key);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
        Iterator iterator = views.keySet().iterator();
        while (iterator.hasNext()) {
            String viewID = (String)iterator.next();
            this.skin.addListener(viewID, l);
        }
    }

    private void initWidgets() {
        SWTSkinObject skinObject = this.skin.getSkinObject("recommend-list");
        if (skinObject != null) {
            Composite cData = (Composite)skinObject.getControl();
            Composite cHeaders = null;
            skinObject = this.skin.getSkinObject("recommend-list-headers");
            if (skinObject != null) {
                cHeaders = (Composite)skinObject.getControl();
            }
            new RecommendationsView(this.skin.getSkinProperties(), cHeaders, cData);
        }
        if ((skinObject = this.skin.getSkinObject("statusbar")) != null) {
            Composite cArea = (Composite)skinObject.getControl();
            final MainStatusBar statusBar = new MainStatusBar();
            Composite composite = statusBar.initStatusBar(this.core, this.core.getGlobalManager(), this.display, cArea);
            composite.setLayoutData((Object)Utils.getFilledFormData());
            UIUpdater uiUpdater = UIUpdaterFactory.getInstance();
            uiUpdater.addUpdater(new UIUpdatable(){

                public String getUpdateUIName() {
                    return "StatusBar";
                }

                public void updateUI() {
                    statusBar.refreshStatusBar();
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("search-text")) != null) {
            this.attachSearchBox(skinObject);
        }
        this.shell.layout(true, true);
        SWTSkinTabSet tabSet = this.skin.getTabSet("maintabs");
        if (tabSet != null) {
            tabSet.addListener(this);
        }
    }

    private void attachSearchBox(SWTSkinObject skinObject) {
        Composite cArea = (Composite)skinObject.getControl();
        final Text text = new Text(cArea, 0);
        text.setLayoutData((Object)Utils.getFilledFormData());
        final String sDefault = MessageText.getString("MainWindow.v3.search.defaultText");
        text.setText(sDefault);
        text.setForeground(ColorCache.getColor((Device)text.getDisplay(), 127, 127, 127));
        text.setBackground(ColorCache.getColor((Device)text.getDisplay(), 255, 255, 255));
        text.selectAll();
        text.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Text text = (Text)e.widget;
                if (text.getText().equals(sDefault)) {
                    text.setForeground(ColorCache.getColor((Device)text.getDisplay(), 0, 0, 0));
                    text.setText("");
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Text text = (Text)e.widget;
                String sSearchText = text.getText();
                MainWindow.this.doSearch(sSearchText);
            }
        });
        SWTSkinObject searchGo = this.skin.getSkinObject("search-go");
        if (searchGo != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(searchGo);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility) {
                    String sSearchText = text.getText().trim();
                    if (!sSearchText.equals(sDefault) && sSearchText.length() > 0) {
                        MainWindow.this.doSearch(sSearchText);
                    }
                }
            });
        }
    }

    protected void doSearch(String sSearchText) {
        SWTSkinObjectTab[] tabs;
        this.skin.setActiveTab("maintabs", "maintabs.browse");
        SWTSkinObject skinObject = this.skin.getSkinObject("browse");
        if (skinObject == null) {
            return;
        }
        String sURL = Constants.URL_PREFIX + "app?page=content%2FSearch&service=external&sp=S" + UrlUtils.encode(sSearchText) + "&" + Constants.URL_SUFFIX;
        System.out.println(sURL);
        if (skinObject instanceof SWTSkinObjectBrowser) {
            ((SWTSkinObjectBrowser)skinObject).setURL(sURL);
            return;
        }
        skinObject = this.skin.getSkinObject("browse-tabs");
        if (skinObject == null) {
            System.err.println("no browse-tabs");
            return;
        }
        SWTSkinTabSet tabSetSearch = this.skin.getTabSet(SWTSkinTabSet.getTabSetID(this.skin, skinObject, "search-tab"));
        SWTSkinObjectBasic searchTab = null;
        if (tabSetSearch != null && (tabs = tabSetSearch.getTabs()).length > 0) {
            searchTab = tabs[tabs.length - 1];
        }
        String sTabID = "internal.tab.searchresults";
        if (searchTab == null || !searchTab.getSkinObjectID().equals(sTabID)) {
            searchTab = this.skin.createTab(sTabID, "search-tab", skinObject);
            Control currentControl = searchTab.getControl();
            FormData formData = (FormData)currentControl.getLayoutData();
            if (formData == null) {
                formData = new FormData();
            }
            formData.right = new FormAttachment(100, 0);
            currentControl.setLayoutData((Object)formData);
            currentControl.getParent().layout(true);
            tabSetSearch = ((SWTSkinObjectTab)searchTab).getTabset();
        }
        tabSetSearch.setActiveTab(sTabID);
        SWTSkinObject searchResultsTabsView = this.skin.getSkinObject("search-results-tabs");
        if (searchResultsTabsView == null) {
            System.err.println("searchResultsTabs null");
            return;
        }
        sTabID = "internal.tab.searchresults." + Integer.toHexString(sSearchText.hashCode());
        SWTSkinObjectTab tabSearchResult = null;
        String sTabSetID = SWTSkinTabSet.getTabSetID(this.skin, searchResultsTabsView, "tab");
        SWTSkinTabSet tabSetSearchResults = this.skin.getTabSet(sTabSetID);
        SWTSkinObjectTab lastTab = null;
        if (tabSetSearchResults != null) {
            SWTSkinObjectTab[] tabs2 = tabSetSearchResults.getTabs();
            if (tabs2.length > 0) {
                lastTab = tabs2[tabs2.length - 1];
            }
            tabSearchResult = tabSetSearchResults.getTab(sTabID);
        }
        if (tabSearchResult == null) {
            SWTSkinObject tabText;
            tabSearchResult = this.skin.createTab(sTabID, "tab", searchResultsTabsView);
            if (tabSetSearchResults == null) {
                tabSetSearchResults = this.skin.getTabSet(sTabSetID);
            }
            Control currentControl = tabSearchResult.getControl();
            if (lastTab != null) {
                FormData formData = (FormData)currentControl.getLayoutData();
                if (formData == null) {
                    formData = new FormData();
                }
                formData.left = new FormAttachment(lastTab.getControl(), 2);
                currentControl.setLayoutData((Object)formData);
            }
            if ((tabText = this.skin.getSkinObject("search-result-tab-text", tabSearchResult)) instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)tabText).setText(sSearchText);
            }
            searchResultsTabsView.getControl().getParent().layout(true, true);
            String[] activeWidgetIDs = tabSearchResult.getActiveWidgetIDs();
            SWTSkinObject searchResultsView = this.skin.getSkinObject("search-results-view");
            if (activeWidgetIDs.length == 1 && searchResultsView != null) {
                SWTSkinObject searchResultsContentN;
                String sContentConfigID = activeWidgetIDs[0];
                String sContentID = "internal.tab.searchresults.content." + Integer.toHexString(sSearchText.hashCode());
                SWTSkinObject searchResultsContent = this.skin.createSkinObject(sContentID, sContentConfigID, searchResultsView);
                tabSearchResult.setActiveWidgets(new SWTSkinObject[]{searchResultsContent});
                SWTSkinObject searchResultsContentG = this.skin.getSkinObject("search-results-google", searchResultsContent);
                if (searchResultsContentG != null) {
                    Composite cArea = (Composite)searchResultsContentG.getControl();
                    Browser browser = new Browser(cArea, 0);
                    BrowserContext context = new BrowserContext("search", browser, null);
                    context.addMessageListener(new TorrentListener(this.core));
                    browser.setLayoutData((Object)Utils.getFilledFormData());
                    browser.setUrl(sURL);
                    cArea.layout(true, true);
                }
                if ((searchResultsContentN = this.skin.getSkinObject("search-results-network", searchResultsContent)) != null) {
                    Composite cArea = (Composite)searchResultsContentN.getControl();
                    Browser browser = new Browser(cArea, 0);
                    BrowserContext context = new BrowserContext("search", browser, null);
                    browser.setLayoutData((Object)Utils.getFilledFormData());
                    NetworkSearch.search(this.core, sSearchText, browser);
                    cArea.layout(true, true);
                }
            }
        }
        if (tabSetSearchResults != null) {
            tabSetSearchResults.setActiveTab(sTabID);
        }
    }

    public void tabChanged(SWTSkinTabSet tabSet, String oldTabID, String newTabID) {
        this.updateMapTrackUsage(oldTabID);
        if (tabSet.getID().equals("maintabs")) {
            SkinView view;
            if (newTabID.equals("maintabs.advanced")) {
                this.createOldMainWindow();
                if (this.oldMainMenu != null) {
                    this.oldMainMenu.linkMenuBar(this.shell);
                }
            } else if (newTabID.equals("maintabs.home") && oldTabID.equals("maintabs.home")) {
                SkinView view2 = SkinViewManager.get(MiniBrowse.class);
                if (view2 instanceof MiniBrowse) {
                    ((MiniBrowse)view2).restart();
                }
            } else if (newTabID.equals("maintabs.browse") && oldTabID.equals("maintabs.browse")) {
                SkinView view3 = SkinViewManager.get(Browse.class);
                if (view3 instanceof Browse) {
                    ((Browse)view3).restart();
                }
            } else if (newTabID.equals("maintabs.publish") && oldTabID.equals("maintabs.publish") && (view = SkinViewManager.get(Publish.class)) instanceof Publish) {
                ((Publish)view).restart();
            }
            if (!newTabID.equals("maintabs.advanced") && this.oldMainMenu != null) {
                this.menu.linkMenuBar(this.shell);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapTrackUsage(String sTabID) {
        if (this.mapTrackUsage != null) {
            this.mapTrackUsage_mon.enter();
            try {
                Long currentLength = (Long)this.mapTrackUsage.get(sTabID);
                currentLength = currentLength == null ? new Long(this.lCurrentTrackTime) : new Long(currentLength + this.lCurrentTrackTime);
                this.mapTrackUsage.put(sTabID, currentLength);
            }
            finally {
                this.mapTrackUsage_mon.exit();
            }
        }
        this.lCurrentTrackTime = 0L;
    }

    private void createOldMainWindow() {
        SWTSkinObject skinObject;
        if (this.oldMainWindow != null || this.disposedOrDisposing) {
            return;
        }
        if (this.uiSWTInstanceImpl == null) {
            System.out.println("This will end only in disaster! " + Debug.getCompressedStackTrace());
        }
        if ((skinObject = this.skin.getSkinObject("advanced")) != null) {
            Composite cArea = (Composite)skinObject.getControl();
            Label lblWait = new Label(cArea, 0x1000000);
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            lblWait.setLayoutData((Object)formData);
            lblWait.setForeground(skinObject.getProperties().getColor("color.row.fg"));
            Messages.setLanguageText((Widget)lblWait, "MainWindow.v3.view.wait");
            cArea.layout(true);
            lblWait.update();
            cArea.setBackground(cArea.getShell().getBackground());
            this.oldMainWindow = new org.gudy.azureus2.ui.swt.mainwindow.MainWindow(this.core, null, cArea.getShell(), cArea, this.uiSWTInstanceImpl);
            this.oldMainWindow.setShowMainWindow(false);
            this.oldMainWindow.runSupport();
            this.oldMainMenu = new org.gudy.azureus2.ui.swt.mainwindow.MainMenu(this.shell);
            this.oldMainMenu.createMenu(this.core, this.shell);
            this.oldMainMenu.setMainWindow(this.oldMainWindow);
            this.oldMainWindow.setMenu(this.oldMainMenu);
            Menu viewMenu = this.oldMainMenu.getMenu(org.gudy.azureus2.ui.swt.mainwindow.MainMenu.MENU_VIEW);
            if (viewMenu != null) {
                this.menu.addToOldMenuView(viewMenu);
            }
            this.uiFunctions.oldMainWindowInitialized(this.oldMainWindow);
            lblWait.dispose();
            cArea.layout(true);
        }
    }

    public org.gudy.azureus2.ui.swt.mainwindow.MainWindow getOldMainWindow(boolean bForceCreate) {
        if (this.oldMainWindow == null && bForceCreate) {
            this.createOldMainWindow();
        }
        return this.oldMainWindow;
    }

    public UIFunctionsSWT getOldUIFunctions(boolean bCreateOld) {
        if (this.oldMainWindow == null && bCreateOld) {
            this.createOldMainWindow();
        }
        if (this.oldMainWindow != null) {
            return this.oldMainWindow.getUIFunctions();
        }
        return null;
    }

    public void switchToAdvancedTab() {
        SWTSkinTabSet tabSetMain = this.skin.getTabSet("maintabs");
        if (tabSetMain == null) {
            System.err.println("maintabs");
            return;
        }
        tabSetMain.setActiveTab("maintabs.advanced");
    }

    public UISWTInstance getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    public void showURL(String url, String target) {
        SWTSkinObject skinObject = this.skin.getSkinObject(target);
        this.skin.activateTab(skinObject);
        if (skinObject instanceof SWTSkinObjectBrowser) {
            ((SWTSkinObjectBrowser)skinObject).getBrowser().setVisible(false);
            if (url == null || url.length() == 0) {
                ((SWTSkinObjectBrowser)skinObject).restart();
            } else {
                ((SWTSkinObjectBrowser)skinObject).setURL(url);
            }
        }
    }

    static /* synthetic */ Object[] access$102(MainWindow x0, Object[] x1) {
        x0.dms_Startup = x1;
        return x1;
    }
}

