/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private final MainWindow mainWindow;
    private final Map mapPluginViews = new HashMap();
    private final AEMonitor pluginViews_mon = new AEMonitor("v3.uif.pluginViews");

    public UIFunctionsImpl(MainWindow window) {
        this.mainWindow = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(PluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(view, null);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(String viewID, UISWTViewEventListener l) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(viewID, l);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(viewID, l);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.put(view, null);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.addPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "addPluginView", e));
        }
    }

    public void bringToFront() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    ((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell.setVisible(true);
                    ((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell.forceActive();
                    ((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell.setMinimized(false);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "bringToFront", e));
                }
            }
        });
    }

    public void closeDownloadBars() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.closeDownloadBars();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closeDownloadBars", e));
        }
    }

    public void closePluginView(IView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.closePluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginView", e));
        }
    }

    public void closePluginViews(String sViewID) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(false);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.closePluginViews(sViewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "closePluginViews", e));
        }
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        try {
            return this.mainWindow.dispose(for_restart, close_already_in_progress);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Disposing MainWindow", e));
            return false;
        }
    }

    public Shell getMainShell() {
        return this.mainWindow.shell;
    }

    public Menu getMenu(int id) {
        return null;
    }

    public UISWTView[] getPluginViews() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return new UISWTView[0];
            }
            return uiFunctions.getPluginViews();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getPluginViews", e));
            return new UISWTView[0];
        }
    }

    public UISWTInstanceImpl getSWTPluginInstanceImpl() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return null;
            }
            return uiFunctions.getSWTPluginInstanceImpl();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "getSWTPluginInstanceImpl", e));
            return null;
        }
    }

    public void openManagerView(DownloadManager dm) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.openManagerView(dm);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openManagerView", e));
        }
    }

    public void openPluginView(AbstractIView view, String name) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.openPluginView(view, name);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(PluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.openPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.openPluginView(sParentID, sViewID, l, dataSource, bSetFocus);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void openPluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.openPluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "openPluginView", e));
        }
    }

    public void refreshIconBar() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.refreshIconBar();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshIconBar", e));
        }
    }

    public void refreshLanguage() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.refreshLanguage();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "refreshLanguage", e));
        }
    }

    public void removeManagerView(DownloadManager dm) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.removeManagerView(dm);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removeManagerView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(String viewID) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.remove(viewID);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.removePluginView(viewID);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(UISWTPluginView view) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                this.pluginViews_mon.enter();
                try {
                    this.mapPluginViews.remove(view);
                }
                finally {
                    this.pluginViews_mon.exit();
                }
                return;
            }
            uiFunctions.removePluginView(view);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "removePluginView", e));
        }
    }

    public boolean requestShutdown() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return true;
            }
            return uiFunctions.requestShutdown();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "requestShutdown", e));
            return false;
        }
    }

    public void setStatusText(String string) {
    }

    public boolean showConfig(String string) {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return false;
            }
            this.mainWindow.switchToAdvancedTab();
            return uiFunctions.showConfig(string);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showConfig", e));
            return false;
        }
    }

    public void showMyShares() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showMyShares();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showMyShares", e));
        }
    }

    public void showMyTorrents() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showMyTorrents();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showMyTorrents", e));
        }
    }

    public void showMyTracker() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showMyTracker();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showMyTracker", e));
        }
    }

    public void showStats() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showStats();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showStats", e));
        }
    }

    public void showStatsDHT() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showStatsDHT();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "showStatsDHT", e));
        }
    }

    public void showStatsTransfers() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showStatsTransfers();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "", e));
        }
    }

    public void showConsole() {
        try {
            UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
            if (uiFunctions == null) {
                return;
            }
            this.mainWindow.switchToAdvancedTab();
            uiFunctions.showConsole();
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "ShowConsole", e));
        }
    }

    public UISWTInstance getUISWTInstance() {
        return this.mainWindow.getUISWTInstanceImpl();
    }

    public boolean viewURL(final String url, final String target, final int w, final int h, final boolean allowResize) {
        this.mainWindow.shell.getDisplay().syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (target == null) {
                    BrowserWindow window = new BrowserWindow(((UIFunctionsImpl)UIFunctionsImpl.this).mainWindow.shell, url, w, h, allowResize);
                    window.waitUntilClosed();
                } else {
                    UIFunctionsImpl.this.mainWindow.showURL(url, target);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void oldMainWindowInitialized(org.gudy.azureus2.ui.swt.mainwindow.MainWindow oldMainWindow) {
        UIFunctionsSWT uiFunctions = this.mainWindow.getOldUIFunctions(true);
        if (uiFunctions == null) {
            return;
        }
        this.pluginViews_mon.enter();
        try {
            Iterator iterator = this.mapPluginViews.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                if (key instanceof PluginView) {
                    uiFunctions.addPluginView((PluginView)key);
                    continue;
                }
                if (key instanceof UISWTPluginView) {
                    uiFunctions.addPluginView((UISWTPluginView)key);
                    continue;
                }
                if (!(key instanceof String)) continue;
                UISWTViewEventListener value = (UISWTViewEventListener)this.mapPluginViews.get(key);
                uiFunctions.addPluginView((String)key, value);
            }
            this.mapPluginViews.clear();
        }
        finally {
            this.pluginViews_mon.exit();
        }
    }
}

