/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class SWTBGImagePainter
implements Listener {
    private static boolean DEBUG = false;
    private static boolean TEST_SWT_PAINTING = Constants.isOSX;
    private Rectangle lastResizeRect = new Rectangle(0, 0, 0, 0);
    private final Shell shell;
    private Image imgSrc;
    private Image imgSrcLeft;
    private Image imgSrcRight;
    private Rectangle imgSrcBounds;
    private Rectangle imgSrcLeftBounds;
    private Rectangle imgSrcRightBounds;
    private Image lastImage = null;
    boolean inEvent = false;
    Rectangle lastBounds = new Rectangle(0, 0, 0, 0);
    Point lastShellBGSize = new Point(0, 0);
    private final int tileMode;
    private final Control control;
    private boolean bDirty;

    private SWTBGImagePainter(Control control, int tileMode) {
        this.control = control;
        this.shell = control.getShell();
        this.tileMode = tileMode;
        control.setData("BGPainter", (Object)this);
    }

    public SWTBGImagePainter(Control control, Image bgImage, int tileMode) {
        this(control, null, null, bgImage, tileMode);
    }

    public SWTBGImagePainter(Control control, Image bgImageLeft, Image bgImageRight, Image bgImage, int tileMode) {
        this(control, tileMode);
        this.setImages(bgImageLeft, bgImageRight, bgImage);
        if ((tileMode & 3) != 3) {
            int width = -1;
            int height = -1;
            if (tileMode == 1 || tileMode == 0) {
                width = this.imgSrcBounds.width + this.imgSrcLeftBounds.width + this.imgSrcRightBounds.width;
            }
            if (tileMode == 2 || tileMode == 0) {
                height = this.imgSrcBounds.height;
            }
            control.setLayoutData((Object)new FormData(width, height));
        }
        if (this.bDirty) {
            this.buildBackground(control);
        }
        if (!TEST_SWT_PAINTING) {
            control.addListener(11, (Listener)this);
            control.addListener(9, (Listener)this);
        }
    }

    public void setImage(Image bgImageLeft, Image bgImageRight, Image bgImage) {
        this.setImages(bgImageLeft, bgImageRight, bgImage);
        if (this.bDirty) {
            this.buildBackground(this.control);
        }
    }

    private boolean imagesEqual(Image image1, Image image2) {
        if (image1 == image2) {
            return true;
        }
        return !ImageLoader.isRealImage(image1) && !ImageLoader.isRealImage(image2);
    }

    private void setImages(Image bgImageLeft, Image bgImageRight, Image bgImage) {
        if (this.imagesEqual(this.imgSrc, bgImage) && this.imagesEqual(this.imgSrcLeft, bgImageLeft) && this.imagesEqual(this.imgSrcRight, bgImageRight)) {
            if (DEBUG) {
                System.out.println("same");
            }
            return;
        }
        if (DEBUG) {
            System.out.println("SI " + bgImageLeft + ";" + bgImageRight + ";" + bgImage + ";" + this.control.getData("SkinObject") + "/" + Debug.getStackTrace(true, false));
        }
        this.imgSrc = bgImage;
        this.imgSrcBounds = this.imgSrc.getBounds();
        this.lastShellBGSize = new Point(0, 0);
        if (ImageLoader.isRealImage(bgImageLeft)) {
            this.imgSrcLeft = bgImageLeft;
            this.imgSrcLeftBounds = this.imgSrcLeft.getBounds();
        } else {
            this.imgSrcLeft = null;
            this.imgSrcLeftBounds = new Rectangle(0, 0, 0, 0);
        }
        if (ImageLoader.isRealImage(bgImageRight)) {
            this.imgSrcRight = bgImageRight;
            this.imgSrcRightBounds = this.imgSrcRight.getBounds();
        } else {
            this.imgSrcRight = null;
            this.imgSrcRightBounds = new Rectangle(0, 0, 0, 0);
        }
        if (TEST_SWT_PAINTING) {
            this.control.removeListener(11, (Listener)this);
            this.control.removeListener(9, (Listener)this);
            if (this.imgSrcRight == null && this.imgSrcLeft == null && this.tileMode == 0) {
                this.control.setBackgroundImage(this.imgSrc);
            } else {
                this.control.addListener(11, (Listener)this);
                this.control.addListener(9, (Listener)this);
                this.bDirty = true;
            }
        } else {
            this.bDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildBackground(Control control) {
        boolean bTileX;
        if (this.inEvent || this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.inEvent = true;
        Point size = control.getSize();
        if (size.x <= 0 || size.y <= 0) {
            this.inEvent = false;
            if (DEBUG) {
                System.out.println("- size " + control.getData("ConfigID"));
            }
            Image image = new Image((Device)this.shell.getDisplay(), 1, 1);
            control.setBackgroundImage(image);
            this.lastBounds = control.getBounds();
            return;
        }
        Composite parent = control.getParent();
        Image imgBG = parent.getBackgroundImage();
        if (imgBG != null && imgBG.isDisposed()) {
            imgBG = null;
        }
        Rectangle imgBGBounds = imgBG == null ? new Rectangle(0, 0, 1, 1) : imgBG.getBounds();
        Rectangle compositeArea = control.getBounds();
        boolean bTileY = (this.tileMode & 1) > 0;
        boolean bl = bTileX = (this.tileMode & 2) > 0;
        if (!this.bDirty && imgBG == null && bTileX && bTileY) {
            this.inEvent = false;
            return;
        }
        if (!this.bDirty && imgBG == null && compositeArea.width == this.lastBounds.width && compositeArea.height == this.lastBounds.height) {
            this.inEvent = false;
            return;
        }
        if (!this.bDirty && compositeArea.equals((Object)this.lastBounds) && imgBGBounds.width == this.lastShellBGSize.x && imgBGBounds.height == this.lastShellBGSize.y) {
            this.inEvent = false;
            return;
        }
        if (TEST_SWT_PAINTING && !this.bDirty && compositeArea.width == this.lastBounds.width && compositeArea.height == this.lastBounds.height) {
            this.inEvent = false;
            return;
        }
        try {
            Point ofs;
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + "@" + Integer.toHexString(this.hashCode()) + "BGPain: " + control.getData("SkinObject") + "/" + "; image" + size + ";" + this.tileMode + ";lB=" + this.lastBounds + "/" + compositeArea + ";" + "lBG=" + this.lastShellBGSize + "/" + imgBGBounds.width + "x" + imgBGBounds.height + ";" + this.bDirty);
            }
            this.lastBounds = compositeArea;
            this.lastShellBGSize = new Point(imgBGBounds.width, imgBGBounds.height);
            Image newImage = new Image((Device)this.shell.getDisplay(), size.x, size.y);
            if (control.getParent() == this.shell) {
                ofs = control.getLocation();
                Rectangle clientArea = this.shell.getClientArea();
                ofs.x += clientArea.x;
                ofs.y += clientArea.y;
            } else {
                Composite composite = control instanceof Composite ? (Composite)control : null;
                Rectangle clientArea = composite == null ? control.getBounds() : composite.getClientArea();
                Point locControl = control.toDisplay(clientArea.x, clientArea.y);
                clientArea = this.shell.getClientArea();
                Point locShell = this.shell.toDisplay(clientArea.x, clientArea.y);
                ofs = new Point(locControl.x - locShell.x, locControl.y - locShell.y);
            }
            ofs.x %= imgBGBounds.width;
            ofs.y %= imgBGBounds.height;
            GC gc = new GC((Drawable)newImage);
            try {
                control.setBackgroundImage(null);
                gc.setBackground(control.getBackground());
                gc.fillRectangle(0, 0, size.x, size.y);
                if (imgBG != null) {
                    for (int y = 0; y < size.y; y += imgBGBounds.height) {
                        for (int x = 0; x < size.x; x += imgBGBounds.width) {
                            gc.drawImage(imgBG, x - ofs.x, y - ofs.y);
                        }
                    }
                }
                int maxY = bTileY ? size.y : this.imgSrcBounds.height;
                int maxX = bTileX ? size.x : this.imgSrcBounds.width;
                int x0 = 0;
                if ((this.tileMode & 4) > 0) {
                    x0 = (size.x - this.imgSrcBounds.width) / 2;
                    maxX += x0;
                }
                int y0 = 0;
                if ((this.tileMode & 8) > 0) {
                    y0 = (size.y - this.imgSrcBounds.height) / 2;
                    maxY += y0;
                }
                if (this.imgSrcRight != null) {
                    int width = this.imgSrcRightBounds.width;
                    maxX -= width;
                }
                if (this.imgSrcLeft != null) {
                    gc.drawImage(this.imgSrcLeft, 0, 0);
                    x0 += this.imgSrcLeftBounds.width;
                }
                for (int y = y0; y < maxY; y += this.imgSrcBounds.height) {
                    for (int x = x0; x < maxX; x += this.imgSrcBounds.width) {
                        if (x + this.imgSrcBounds.width >= maxX) {
                            int width = maxX - x;
                            gc.drawImage(this.imgSrc, 0, 0, width, this.imgSrcBounds.height, x, y, width, this.imgSrcBounds.height);
                            continue;
                        }
                        gc.drawImage(this.imgSrc, x, y);
                    }
                }
                if (this.imgSrcRight != null) {
                    gc.drawImage(this.imgSrcRight, maxX, 0);
                }
            }
            finally {
                gc.dispose();
            }
            control.setBackgroundImage(newImage);
            if (this.lastImage != null) {
                this.lastImage.dispose();
            }
            this.lastImage = newImage;
            this.bDirty = false;
        }
        finally {
            this.inEvent = false;
        }
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 2144);
        shell.setLayout((Layout)new FillLayout());
        Composite c = new Composite((Composite)shell, 2048);
        c.setLayout((Layout)new FillLayout());
        c.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawLine(0, 0, 100, 50);
            }
        });
        Label lbl = new Label(c, 0);
        lbl.setText("text");
        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void handleEvent(Event event2) {
        if (event2.type == 11) {
            Control control = (Control)event2.widget;
            Rectangle resizeRect = control.getBounds();
            if (resizeRect.equals((Object)this.lastResizeRect)) {
                return;
            }
            this.lastResizeRect = resizeRect;
            if (DEBUG) {
                System.out.println("BGPaint:HE: " + control.getData("ConfigID") + ";" + event2);
            }
            this.buildBackground(control);
        } else if (event2.type == 9) {
            Control control = (Control)event2.widget;
            if (DEBUG) {
                System.out.println("BGPaint:P: " + control.getData("ConfigID") + ";" + event2);
            }
            if (!TEST_SWT_PAINTING) {
                this.buildBackground(control);
            }
        }
    }
}

