/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinButtonUtility {
    ArrayList listeners = new ArrayList();
    private final SWTSkinObject skinObject;

    public SWTSkinButtonUtility(SWTSkinObject skinObject) {
        this.skinObject = skinObject;
        Listener l = new Listener(){
            boolean bDownPressed;

            public void handleEvent(Event event2) {
                if (event2.type == 3) {
                    this.bDownPressed = true;
                    return;
                }
                if (!this.bDownPressed) {
                    return;
                }
                this.bDownPressed = false;
                if (SWTSkinButtonUtility.this.isDisabled()) {
                    return;
                }
                Iterator iter = SWTSkinButtonUtility.this.listeners.iterator();
                while (iter.hasNext()) {
                    ButtonListenerAdapter l = (ButtonListenerAdapter)iter.next();
                    l.pressed(SWTSkinButtonUtility.this);
                }
            }
        };
        if (skinObject instanceof SWTSkinObjectContainer) {
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 4, l);
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 3, l);
        } else {
            skinObject.getControl().addListener(4, l);
            skinObject.getControl().addListener(3, l);
        }
    }

    public boolean isDisabled() {
        return this.skinObject.getSuffix().equals("-disabled");
    }

    public void setDisabled(boolean disabled) {
        String suffix;
        String string = suffix = disabled ? "-disabled" : "";
        if (this.skinObject.getSuffix().equals(suffix)) {
            return;
        }
        this.skinObject.switchSuffix(suffix, 1, true);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ButtonListenerAdapter l = (ButtonListenerAdapter)iter.next();
            l.disabledStateChanged(this, disabled);
        }
    }

    public void addSelectionListener(ButtonListenerAdapter listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public SWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setTextID(final String id) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObject[] children;
                if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectText) {
                    SWTSkinObjectText skinTextObject = (SWTSkinObjectText)SWTSkinButtonUtility.this.skinObject;
                    skinTextObject.setTextID(id);
                } else if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)SWTSkinButtonUtility.this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectText) {
                    SWTSkinObjectText skinTextObject = (SWTSkinObjectText)children[0];
                    skinTextObject.setTextID(id);
                }
                Utils.relayout(SWTSkinButtonUtility.this.skinObject.getControl());
            }
        });
    }

    public static class ButtonListenerAdapter {
        public void pressed(SWTSkinButtonUtility buttonUtility) {
        }

        public void disabledStateChanged(SWTSkinButtonUtility buttonUtility, boolean disabled) {
        }
    }
}

