/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTBGImagePainter;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class SWTSkinObjectBasic
implements SWTSkinObject {
    protected Control control;
    protected String type;
    protected String sConfigID;
    protected SWTBGImagePainter painter;
    protected SWTSkinProperties properties;
    protected String sID;
    protected SWTSkinObject parent;
    protected SWTSkin skin;
    protected String[] suffixes = null;
    protected ArrayList listeners = new ArrayList();
    protected AEMonitor listeners_mon = new AEMonitor("SWTSkinObjectBasic::listener");
    private String sViewID;

    public SWTSkinObjectBasic(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        this(skin, properties, sID, sConfigID, type, parent);
        this.setControl(control);
    }

    public SWTSkinObjectBasic(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String type, SWTSkinObject parent) {
        this.skin = skin;
        this.properties = properties;
        this.sConfigID = sConfigID;
        this.sID = sID;
        this.type = type;
        this.parent = parent;
    }

    public void setControl(Control control) {
        this.control = control;
        control.setData("ConfigID", (Object)this.sConfigID);
        control.setData("SkinObject", (Object)this);
        SWTSkinUtils.addMouseImageChangeListeners((Widget)control);
        this.switchSuffix("", 1, false);
    }

    public Control getControl() {
        return this.control;
    }

    public String getType() {
        return this.type;
    }

    public String getConfigID() {
        return this.sConfigID;
    }

    public String getSkinObjectID() {
        return this.sID;
    }

    public SWTSkinObject getParent() {
        return this.parent;
    }

    public void setBackground(String sConfigID, String sSuffix) {
        Image imageBGRight;
        Image imageBGLeft;
        Image imageBG;
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        Image[] images = imageLoader.getImages(sConfigID + sSuffix);
        if (images.length == 1 && ImageLoader.isRealImage(images[0])) {
            imageBG = images[0];
            imageBGLeft = imageLoader.getImage(sConfigID + sSuffix + "-left");
            imageBGRight = imageLoader.getImage(sConfigID + sSuffix + "-right");
        } else if (images.length == 3 && ImageLoader.isRealImage(images[2])) {
            imageBGLeft = images[0];
            imageBG = images[1];
            imageBGRight = images[2];
        } else {
            return;
        }
        if (this.painter == null) {
            String sTileMode = this.properties.getStringValue(sConfigID + ".drawmode");
            int tileMode = SWTSkinUtils.getTileMode(sTileMode);
            this.painter = new SWTBGImagePainter(this.control, imageBGLeft, imageBGRight, imageBG, tileMode);
        } else {
            this.painter.setImage(imageBGLeft, imageBGRight, imageBG);
        }
        this.control.update();
    }

    public String toString() {
        String s = "SWTSkinObjectBasic {" + this.sID;
        if (!this.sID.equals(this.sConfigID)) {
            s = s + "/" + this.sConfigID;
        }
        s = s + ", " + this.type + "; parent=" + (this.parent == null ? null : this.parent.getSkinObjectID() + "}");
        return s;
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SWTSkinObject) {
            SWTSkinObject skinObject = (SWTSkinObject)obj;
            boolean bEquals = skinObject.getSkinObjectID().equals(this.sID);
            if (this.parent != null) {
                return bEquals && this.parent.equals(skinObject.getParent());
            }
            return bEquals;
        }
        return super.equals(obj);
    }

    public void setVisible(boolean visible) {
        this.control.setVisible(visible);
        this.triggerListeners(visible ? 0 : 1);
    }

    public String switchSuffix(String suffix, int level, boolean walkUp) {
        String sTooltip;
        if (walkUp) {
            SWTSkinObject parentSkinObject = this.parent;
            SWTSkinObject skinObject = this;
            while (parentSkinObject instanceof SWTSkinObjectContainer && ((SWTSkinObjectContainer)parentSkinObject).getPropogation()) {
                skinObject = parentSkinObject;
                parentSkinObject = parentSkinObject.getParent();
            }
            if (skinObject != this) {
                skinObject.switchSuffix(suffix, level, false);
                return null;
            }
        }
        if (this.suffixes == null) {
            this.suffixes = new String[level];
        } else if (this.suffixes.length < level) {
            String[] newSuffixes = new String[level];
            System.arraycopy(this.suffixes, 0, newSuffixes, 0, this.suffixes.length);
            this.suffixes = newSuffixes;
        }
        this.suffixes[level - 1] = suffix;
        suffix = this.getSuffix();
        Color color = this.properties.getColor(this.sConfigID + ".color" + suffix);
        if (color != null) {
            this.control.setBackground(color);
        }
        this.setBackground(this.sConfigID + ".background", suffix);
        String sCursor = this.properties.getStringValue(this.sConfigID + ".cursor");
        if (sCursor != null && sCursor.length() > 0 && sCursor.equalsIgnoreCase("hand")) {
            this.control.addListener(6, this.skin.getHandCursorListener(this.control.getDisplay()));
            this.control.addListener(7, this.skin.getHandCursorListener(this.control.getDisplay()));
        }
        if ((sTooltip = this.properties.getStringValue(this.sConfigID + ".tooltip" + suffix)) != null) {
            this.setTooltipAndChildren(this.control, sTooltip);
        }
        return suffix;
    }

    public String getSuffix() {
        String suffix = "";
        for (int i = 0; i < this.suffixes.length; ++i) {
            suffix = suffix + this.suffixes[i];
        }
        return suffix;
    }

    public void setTooltipAndChildren(Control c, String sToolTip) {
        c.setToolTipText(sToolTip);
        if (c instanceof Composite) {
            Control[] children = ((Composite)c).getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control control = children[i];
                this.setTooltipAndChildren(control, sToolTip);
            }
        }
    }

    public SWTSkinProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SWTSkinProperties skinProperties) {
        this.properties = skinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SWTSkinObjectListener listener) {
        this.listeners_mon.enter();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SWTSkinObjectListener listener) {
        this.listeners_mon.enter();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public SWTSkinObjectListener[] getListeners() {
        return this.listeners.toArray(new SWTSkinObjectListener[0]);
    }

    public void triggerListeners(int eventType) {
        this.triggerListeners(eventType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerListeners(int eventType, Object params) {
        this.listeners_mon.enter();
        try {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    SWTSkinObjectListener l = (SWTSkinObjectListener)iterator.next();
                    l.eventOccured(this, eventType, params);
                }
                catch (Exception e) {
                    Debug.out("Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error for listener added locally", e);
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        SWTSkinObjectListener[] listeners = this.skin.getSkinObjectListeners(this.sViewID);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                SWTSkinObjectListener l = listeners[i];
                l.eventOccured(this, eventType, params);
                continue;
            }
            catch (Exception e) {
                Debug.out("Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error for listener added to skin", e);
            }
        }
    }

    protected void setViewID(String viewID) {
        this.sViewID = viewID;
    }

    public String getViewID() {
        return this.sViewID;
    }
}

