/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.SystemTime;

public class SWTSkinObjectBrowser
extends SWTSkinObjectBasic {
    private Browser browser;
    private Composite cArea;
    private String sStartURL;

    public SWTSkinObjectBrowser(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "browser", parent);
        SWTSkinObject skinObjectIndicator;
        AzureusCore core = AzureusCoreFactory.getSingleton();
        this.cArea = (Composite)parent.getControl();
        this.browser = new Browser(this.cArea, 0);
        Control widgetIndicator = null;
        String sIndicatorWidgetID = properties.getStringValue(sConfigID + ".indicator");
        if (sIndicatorWidgetID != null && (skinObjectIndicator = skin.getSkinObjectByID(sIndicatorWidgetID)) != null) {
            widgetIndicator = skinObjectIndicator.getControl();
        }
        BrowserContext context = new BrowserContext(sID, this.browser, widgetIndicator);
        context.addMessageListener(new TorrentListener(core));
        context.addMessageListener(new DisplayListener(this.browser));
        this.setControl((Control)this.browser);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setURL(String url) {
        if (url == null) {
            this.browser.setText("");
        } else {
            this.browser.setUrl(url);
        }
        if (this.sStartURL == null) {
            this.sStartURL = url;
            this.browser.setData("StartURL", (Object)url);
        }
        System.out.println(SystemTime.getCurrentTime() + "] Set URL: " + url);
    }

    public void restart() {
        this.setURL(this.sStartURL);
    }

    public void layout() {
        this.cArea.layout();
    }
}

