/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.util.Debug;

public class SWTSkinObjectContainer
extends SWTSkinObjectBasic {
    boolean bPropogate = false;

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        this(skin, properties, null, sID, sConfigID, "container", parent);
    }

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, type, parent);
        if (control == null) {
            Composite parentComposite;
            int style = 0;
            if (properties.getIntValue(sConfigID + ".border", 0) == 1) {
                style = 2048;
            }
            Object createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
            if (SWTSkin.DEBUGLAYOUT) {
                System.out.println("linkIDtoParent: Create Composite " + sID + " on " + createOn);
                parentComposite = new Group((Composite)createOn, style);
                ((Group)parentComposite).setText(sConfigID);
                parentComposite.setData("DEBUG", (Object)"1");
            } else {
                parentComposite = new Composite((Composite)createOn, style);
            }
            parentComposite.setLayout((Layout)new FormLayout());
            control = parentComposite;
        }
        this.setControl(control);
    }

    public SWTSkinObject[] getChildren() {
        String[] widgets = this.properties.getStringArray(this.sConfigID + ".widgets");
        if (widgets == null) {
            return new SWTSkinObject[0];
        }
        ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>();
        for (int i = 0; i < widgets.length; ++i) {
            String id = widgets[i];
            SWTSkinObject skinObject = this.skin.getSkinObjectByID(id, this);
            if (skinObject == null) continue;
            list.add(skinObject);
        }
        SWTSkinObject[] objects = new SWTSkinObject[list.size()];
        objects = list.toArray(objects);
        return objects;
    }

    public String switchSuffix(String suffix, int level, boolean walkUp) {
        String sFullsuffix = super.switchSuffix(suffix, level, walkUp);
        if (this.bPropogate && suffix != null) {
            SWTSkinObject[] children = this.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].switchSuffix(suffix, level, false);
            }
        }
        return sFullsuffix;
    }

    public void setPropogation(boolean propogate) {
        this.bPropogate = propogate;
        if (SWTSkin.DEBUGLAYOUT) {
            ((Group)this.control).setText(((Group)this.control).getText() + (this.bPropogate ? ";P" : ""));
        }
    }

    public boolean getPropogation() {
        return this.bPropogate;
    }

    public void triggerListeners(int eventType, Object params) {
        try {
            super.triggerListeners(eventType, params);
        }
        catch (Exception e) {
            Debug.out("Trigger of Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error", e);
        }
        SWTSkinObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            try {
                children[i].triggerListeners(eventType, params);
                continue;
            }
            catch (Exception e) {
                Debug.out("Trigger of Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " for Container child has caused an error", e);
            }
        }
    }
}

