/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectImage
extends SWTSkinObjectBasic {
    Label label;
    private boolean customImage;
    private static PaintListener tilePaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Image imgLeft;
            Label label = (Label)e.widget;
            Image imgSrc = (Image)label.getData("image");
            if (imgSrc == null) {
                return;
            }
            Rectangle imgSrcBounds = imgSrc.getBounds();
            Point size = label.getSize();
            int x0 = 0;
            int y0 = 0;
            int x1 = size.x;
            int y1 = size.y;
            Image imgRight = (Image)label.getData("image-right");
            if (imgRight != null) {
                int width = imgRight.getBounds().width;
                x1 -= width;
            }
            if ((imgLeft = (Image)label.getData("image-left")) != null) {
                e.gc.drawImage(imgLeft, 0, 0);
                x0 += imgLeft.getBounds().width;
            }
            for (int y = y0; y < y1; y += imgSrcBounds.height) {
                for (int x = x0; x < x1; x += imgSrcBounds.width) {
                    e.gc.drawImage(imgSrc, x, y);
                }
            }
            if (imgRight != null) {
                e.gc.drawImage(imgRight, x1, 0);
            }
        }
    };

    public SWTSkinObjectImage(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, String sImageID, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "image", parent);
        this.setControl((Control)this.createImageLabel(sConfigID, sImageID));
        this.customImage = false;
    }

    private Label createImageLabel(String sConfigID, String sImageID) {
        ImageLoader imageLoader;
        Image image;
        String sCursor;
        String sURL;
        int align;
        int style = 64;
        String sAlign = this.properties.getStringValue(sConfigID + ".align");
        if (sAlign != null && (align = SWTSkinUtils.getAlignment(sAlign, 0)) != 0) {
            style |= align;
        }
        if (this.properties.getIntValue(sConfigID + ".border", 0) == 1) {
            style |= 0x800;
        }
        Object createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        this.label = new Label((Composite)createOn, style);
        this.label.setData("SkinObject", (Object)this);
        Color color = this.properties.getColor(sConfigID + ".color");
        if (color != null) {
            this.label.setBackground(color);
        }
        if ((sURL = this.properties.getStringValue(sConfigID + ".url")) != null && sURL.length() > 0) {
            this.label.setToolTipText(sURL);
            this.label.addListener(4, new Listener(){

                public void handleEvent(Event arg0) {
                    Utils.launch(UrlUtils.encode(sURL));
                }
            });
        }
        if ((sCursor = this.properties.getStringValue(sConfigID + ".cursor")) != null && sCursor.length() > 0 && sCursor.equalsIgnoreCase("hand")) {
            this.label.addListener(6, this.skin.getHandCursorListener(this.label.getDisplay()));
            this.label.addListener(7, this.skin.getHandCursorListener(this.label.getDisplay()));
        }
        if (!ImageLoader.isRealImage(image = (imageLoader = this.skin.getImageLoader(this.properties)).getImage(sImageID))) {
            sImageID = sConfigID + ".image";
            image = imageLoader.getImage(sImageID);
        }
        if (ImageLoader.isRealImage(image)) {
            this.setLabelImage(sConfigID, sImageID);
        }
        return this.label;
    }

    protected Image setLabelImage(String sConfigID) {
        return this.setLabelImage(sConfigID, sConfigID);
    }

    private Image setLabelImage(String sConfigID, String sImageID) {
        String sDrawMode;
        Image imageRight;
        if (this.label == null || this.label.isDisposed()) {
            return null;
        }
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        Image image = imageLoader.getImage(sImageID);
        Image imageLeft = imageLoader.getImage(sImageID + ".left");
        if (ImageLoader.isRealImage(imageLeft)) {
            this.label.setData("image-left", (Object)imageLeft);
        }
        if (ImageLoader.isRealImage(imageRight = imageLoader.getImage(sImageID + ".right"))) {
            this.label.setData("image-right", (Object)imageRight);
        }
        if ((sDrawMode = this.properties.getStringValue(sConfigID + ".drawmode")) == null) {
            sDrawMode = "";
        }
        if (sDrawMode.equalsIgnoreCase("tile")) {
            Rectangle imgBounds = image.getBounds();
            this.label.setSize(imgBounds.width, imgBounds.height);
            this.label.setData("image", (Object)image);
            this.label.setLayoutData((Object)new FormData(imgBounds.width, imgBounds.height));
            this.label.removePaintListener(tilePaintListener);
            this.label.addPaintListener(tilePaintListener);
        } else {
            this.label.setImage(image);
            this.label.setData("ImageID", (Object)sImageID);
        }
        SWTSkinUtils.addMouseImageChangeListeners((Widget)this.label);
        return image;
    }

    public void setBackground(String sConfigID, String sSuffix) {
    }

    public String switchSuffix(String suffix, int level, boolean walkUp) {
        suffix = super.switchSuffix(suffix, level, walkUp);
        if (this.customImage) {
            return suffix;
        }
        if (suffix == null) {
            return null;
        }
        String sImageID = this.sConfigID + ".image" + suffix;
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        Image image = imageLoader.getImage(sImageID);
        if (image != ImageLoader.noImage) {
            this.setLabelImage(sImageID);
        }
        return suffix;
    }

    public Image getImage() {
        return this.label.getImage();
    }

    public void setImage(Image image) {
        this.customImage = true;
        this.label.setData("Image", (Object)image);
        this.label.setData("image-left", null);
        this.label.setData("image-right", null);
        this.label.setImage(image);
        Utils.relayout((Control)this.label);
    }
}

