/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class SWTSkinObjectImageContainer
extends SWTSkinObjectContainer {
    Composite composite = (Composite)this.getControl();
    private static PaintListener tilePaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Image imgLeft;
            System.out.println("moo");
            Composite c = (Composite)e.widget;
            Image imgSrc = (Image)c.getData("image");
            if (imgSrc == null) {
                return;
            }
            Rectangle imgSrcBounds = imgSrc.getBounds();
            Point size = c.getSize();
            int x0 = 0;
            int y0 = 0;
            int x1 = size.x;
            int y1 = size.y;
            Image imgRight = (Image)c.getData("image-right");
            if (imgRight != null) {
                int width = imgRight.getBounds().width;
                x1 -= width;
            }
            if ((imgLeft = (Image)c.getData("image-left")) != null) {
                e.gc.drawImage(imgLeft, 0, 0);
                x0 += imgLeft.getBounds().width;
            }
            for (int y = y0; y < y1; y += imgSrcBounds.height) {
                for (int x = x0; x < x1; x += imgSrcBounds.width) {
                    e.gc.drawImage(imgSrc, x, y);
                }
            }
            if (imgRight != null) {
                e.gc.drawImage(imgRight, x1, 0);
            }
        }
    };

    public SWTSkinObjectImageContainer(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, parent);
        this.setLabelImage(sConfigID, sConfigID + ".image");
    }

    protected Image setLabelImage(String sConfigID) {
        return this.setLabelImage(sConfigID, sConfigID);
    }

    private Image setLabelImage(String sConfigID, String sImageID) {
        String sDrawMode;
        Image imageRight;
        if (this.composite == null || this.composite.isDisposed()) {
            return null;
        }
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        Image image = imageLoader.getImage(sImageID);
        Image imageLeft = imageLoader.getImage(sImageID + ".left");
        if (ImageLoader.isRealImage(imageLeft)) {
            this.composite.setData("image-left", (Object)imageLeft);
        }
        if (ImageLoader.isRealImage(imageRight = imageLoader.getImage(sImageID + ".right"))) {
            this.composite.setData("image-right", (Object)imageRight);
        }
        if ((sDrawMode = this.properties.getStringValue(sImageID + ".drawmode")) == null) {
            sDrawMode = "";
        }
        System.out.println("Hello");
        if (sDrawMode.equalsIgnoreCase("tile")) {
            Rectangle imgBounds = image.getBounds();
            this.composite.setSize(imgBounds.width, imgBounds.height);
            this.composite.setData("image", (Object)image);
            this.composite.setLayoutData((Object)new FormData(imgBounds.width, imgBounds.height));
            this.composite.removePaintListener(tilePaintListener);
            this.composite.addPaintListener(tilePaintListener);
        } else {
            this.composite.setData("ImageID", (Object)sImageID);
        }
        SWTSkinUtils.addMouseImageChangeListeners((Widget)this.composite);
        return image;
    }
}

