/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.text.NumberFormat;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;

public class SWTSkinObjectSash
extends SWTSkinObjectBasic {
    private static final boolean FASTDRAG = false;
    protected String sControlBefore;
    protected String sControlAfter;

    public SWTSkinObjectSash(final SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parent, final boolean bVertical) {
        super(skin, properties, sID, sConfigID, "sash", parent);
        Object createOn;
        int style;
        int n = style = bVertical ? 512 : 256;
        if (typeParams.length > 2) {
            this.sControlBefore = typeParams[1];
            this.sControlAfter = typeParams[2];
        }
        if ((createOn = parent == null ? skin.getShell() : (Composite)parent.getControl()) == null || createOn.isDisposed()) {
            Debug.out("Can not create " + sID + " because parent is null or disposed");
            return;
        }
        final Sash sash = new Sash((Composite)createOn, style);
        int splitAt = COConfigurationManager.getIntParameter("v3." + sID + ".SplitAt", -1);
        if (splitAt != -1) {
            double pct = (double)splitAt / 10000.0;
            sash.setData("PCT", (Object)new Double(pct));
        } else {
            String sPos = properties.getStringValue(sConfigID + ".startpos");
            if (sPos != null) {
                try {
                    long l = NumberFormat.getInstance().parse(sPos).longValue();
                    if (sPos.endsWith("%")) {
                        double pct = (double)(100L - l) / 100.0;
                        sash.setData("PCT", (Object)new Double(pct));
                    } else {
                        sash.setData("PX", (Object)new Long(l));
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        Shell parentComposite = createOn;
        Listener l = new Listener((Composite)parentComposite, (Composite)createOn, sID){
            private boolean skipResize = false;
            private final /* synthetic */ Composite val$parentComposite;
            private final /* synthetic */ Composite val$createOn;
            private final /* synthetic */ String val$sID;
            {
                this.val$parentComposite = composite;
                this.val$createOn = composite2;
                this.val$sID = string;
            }

            public void handleEvent(Event e) {
                Composite below = null;
                SWTSkinObject skinObject = skin.getSkinObjectByID(SWTSkinObjectSash.this.sControlAfter);
                if (skinObject != null) {
                    below = (Composite)skinObject.getControl();
                }
                if (below == null) {
                    return;
                }
                Composite above = null;
                skinObject = skin.getSkinObjectByID(SWTSkinObjectSash.this.sControlBefore);
                if (skinObject != null) {
                    above = (Composite)skinObject.getControl();
                }
                if (e.type == 11) {
                    Long px;
                    if (this.skipResize) {
                        return;
                    }
                    Double l = (Double)sash.getData("PCT");
                    if (l != null) {
                        SWTSkinObjectSash.this.setPercent(l, (Control)sash, above, below, bVertical, (Control)this.val$parentComposite);
                    }
                    if ((px = (Long)sash.getData("PX")) != null) {
                        int i = bVertical ? this.val$createOn.getSize().x : this.val$createOn.getSize().y;
                        double pct = 1.0 - px.doubleValue() / (double)i;
                        FormData belowData = (FormData)below.getLayoutData();
                        if (bVertical) {
                            belowData.width = (int)((double)this.val$parentComposite.getBounds().width * pct);
                        } else {
                            belowData.height = (int)((double)this.val$parentComposite.getBounds().height * pct);
                        }
                        sash.setData("PCT", (Object)new Double(pct));
                    }
                } else if (e.type == 13) {
                    this.skipResize = true;
                    Rectangle area = this.val$parentComposite.getClientArea();
                    FormData belowData = (FormData)below.getLayoutData();
                    if (bVertical) {
                        belowData.width = area.width - (e.x + e.width);
                        if (belowData.width < 0) {
                            belowData.width = 0;
                            e.doit = false;
                        }
                    } else {
                        belowData.height = area.height - (e.y + e.height);
                        if (belowData.height < 0) {
                            belowData.height = 0;
                            e.doit = false;
                        }
                    }
                    this.val$parentComposite.layout(true);
                    double d = bVertical ? (double)below.getBounds().width / (double)this.val$parentComposite.getBounds().width : (double)below.getBounds().height / (double)this.val$parentComposite.getBounds().height;
                    Double l = new Double(d);
                    l = SWTSkinObjectSash.this.ensureVisibilityStates(l, above, below, bVertical);
                    sash.setData("PCT", (Object)l);
                    if (e.detail != 1) {
                        COConfigurationManager.setParameter("v3." + this.val$sID + ".SplitAt", (int)(l * 10000.0));
                    }
                    this.skipResize = false;
                }
            }
        };
        createOn.addListener(11, l);
        sash.addListener(13, l);
        String sDblClick = properties.getStringValue(sConfigID + ".dblclick");
        if (sDblClick != null) {
            final int dir = (sDblClick = sDblClick.toLowerCase()).equals("left") ? 16384 : 131072;
            sash.addListener(8, new Listener((Composite)parentComposite){
                private final /* synthetic */ Composite val$parentComposite;
                {
                    this.val$parentComposite = composite;
                }

                public void handleEvent(Event e) {
                    Double oldPCT;
                    Composite below = null;
                    SWTSkinObject skinObject = skin.getSkinObjectByID(SWTSkinObjectSash.this.sControlAfter);
                    if (skinObject != null) {
                        below = (Composite)skinObject.getControl();
                    }
                    if (below == null) {
                        return;
                    }
                    Composite above = null;
                    skinObject = skin.getSkinObjectByID(SWTSkinObjectSash.this.sControlBefore);
                    if (skinObject != null) {
                        above = (Composite)skinObject.getControl();
                    }
                    if ((oldPCT = (Double)sash.getData("PCT")) == null) {
                        oldPCT = new Double(-1.0);
                    }
                    Double pct = dir == 16384 ? (oldPCT == 1.0 ? new Double(0.0) : new Double(1.0)) : (oldPCT == 0.0 ? new Double(1.0) : new Double(0.0));
                    SWTSkinObjectSash.this.setPercent(pct, (Control)sash, above, below, bVertical, (Control)this.val$parentComposite);
                    below.getParent().layout();
                }
            });
        }
        this.setControl((Control)sash);
    }

    protected void setPercent(Double l, Control sash, Composite above, Composite below, boolean bVertical, Control parentComposite) {
        FormData belowData = (FormData)below.getLayoutData();
        if (bVertical) {
            belowData.width = (int)((double)(parentComposite.getBounds().width - sash.getSize().x / 2) * l);
            if (belowData.width < 0) {
                belowData.width = 0;
            }
        } else {
            belowData.height = (int)((double)(parentComposite.getBounds().height - sash.getSize().y / 2) * l);
            if (belowData.height < 0) {
                belowData.height = 0;
            }
        }
        below.getParent().layout();
        l = this.ensureVisibilityStates(l, above, below, bVertical);
        sash.setData("PCT", (Object)l);
        COConfigurationManager.setParameter("v3." + this.sID + ".SplitAt", (int)(l * 10000.0));
    }

    private Double ensureVisibilityStates(Double l, Composite above, Composite below, boolean bVertical) {
        int sizeAbove;
        Double ret = l;
        int sizeBelow = bVertical ? below.getSize().x : below.getSize().y;
        int n = sizeAbove = bVertical ? above.getSize().x : above.getSize().y;
        if ((l == 0.0 || sizeBelow <= 1) && below != null && below.getVisible()) {
            ret = new Double(0.0);
            below.setVisible(false);
            below.setData("SashSetVisibility", (Object)new Boolean(true));
        } else if (below != null && !below.isVisible() && below.getData("SashSetVisibility") != null) {
            below.setVisible(true);
            below.setData("SashSetVisibility", null);
        }
        if ((l == 1.0 || sizeAbove <= 1) && above != null && above.getVisible()) {
            ret = new Double(1.0);
            above.setVisible(false);
            above.setData("SashSetVisibility", (Object)new Boolean(true));
        } else if (above != null && !above.isVisible() && above.getData("SashSetVisibility") != null) {
            above.setVisible(true);
            above.setData("SashSetVisibility", null);
        }
        return ret;
    }
}

