/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSet;
import java.util.ArrayList;

public class SWTSkinObjectTab
extends SWTSkinObjectContainer {
    SWTSkinObject[] activeWidgets = null;
    SWTSkinObject activeWidgetsParent;
    SWTSkinTabSet tabset;

    public SWTSkinObjectTab(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, parent);
        this.type = "tab";
    }

    public String[] getActiveWidgetIDs() {
        String[] sIDs = this.properties.getStringArray(this.getConfigID() + ".active-widgets");
        return sIDs;
    }

    public SWTSkinObject[] getActiveWidgets() {
        if (this.activeWidgets == null) {
            String[] sIDs = this.getActiveWidgetIDs();
            ArrayList<SWTSkinObject> skinObjectArray = new ArrayList<SWTSkinObject>();
            if (sIDs != null) {
                for (int i = 0; i < sIDs.length; ++i) {
                    SWTSkinObject skinObject = this.getSkin().getSkinObjectByID(sIDs[i], this.activeWidgetsParent);
                    if (skinObject == null) continue;
                    skinObjectArray.add(skinObject);
                }
            }
            if (skinObjectArray.size() == 0) {
                return new SWTSkinObject[0];
            }
            this.activeWidgets = new SWTSkinObject[skinObjectArray.size()];
            this.activeWidgets = skinObjectArray.toArray(this.activeWidgets);
        }
        return this.activeWidgets;
    }

    public void setActiveWidgets(SWTSkinObject[] skinObjects) {
        this.activeWidgets = skinObjects;
    }

    public SWTSkinObject getActiveWidgetsParent() {
        return this.activeWidgetsParent;
    }

    public void setActiveWidgetsParent(SWTSkinObject activeWidgetsParent) {
        this.activeWidgetsParent = activeWidgetsParent;
        this.activeWidgets = null;
    }

    public SWTSkinTabSet getTabset() {
        return this.tabset;
    }

    public void setTabset(SWTSkinTabSet tabset) {
        this.tabset = tabset;
    }
}

