/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class SWTSkinObjectText2
extends SWTSkinObjectBasic
implements SWTSkinObjectText,
PaintListener {
    String sText;
    String sKey;
    boolean bIsTextDefault = false;
    private int style = 64;
    private Canvas canvas;
    private static Font font = null;

    public SWTSkinObjectText2(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "text", parent);
        int align;
        String sAlign = skinProperties.getStringValue(sConfigID + ".align");
        if (sAlign != null && (align = SWTSkinUtils.getAlignment(sAlign, 0)) != 0) {
            this.style |= align;
        }
        if (skinProperties.getIntValue(sConfigID + ".border", 0) == 1) {
            this.style |= 0x800;
        }
        Object createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.canvas = new Canvas((Composite)createOn, 0){
            Point ptMax;
            {
                this.ptMax = new Point(0, 0);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int border = this.getBorderWidth() * 2;
                Point pt = new Point(border, border);
                if (SWTSkinObjectText2.this.sText == null) {
                    return pt;
                }
                Font existingFont = (Font)SWTSkinObjectText2.this.canvas.getData("font");
                Color existingColor = (Color)SWTSkinObjectText2.this.canvas.getData("color");
                GC gc = new GC((Drawable)this);
                if (existingFont != null) {
                    gc.setFont(existingFont);
                }
                if (existingColor != null) {
                    gc.setForeground(existingColor);
                }
                pt = gc.textExtent(SWTSkinObjectText2.this.sText);
                pt.x += border;
                pt.y += border;
                gc.dispose();
                if (pt.x > this.ptMax.x) {
                    this.ptMax.x = pt.x;
                }
                if (pt.y > this.ptMax.y) {
                    this.ptMax.y = pt.y;
                }
                return this.ptMax;
            }
        };
        this.canvas.setData("font", (Object)font);
        this.setControl((Control)this.canvas);
        if (typeParams.length > 1) {
            this.bIsTextDefault = true;
            this.sText = typeParams[1];
        }
        this.canvas.addPaintListener((PaintListener)this);
        this.updateFont("");
    }

    public String switchSuffix(String suffix, int level, boolean walkUp) {
        String text;
        if ((suffix = super.switchSuffix(suffix, level, walkUp)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        if ((this.sText == null || this.bIsTextDefault) && (text = this.properties.getStringValue(sPrefix + suffix)) != null) {
            this.sText = text;
        }
        this.updateFont(suffix);
        return suffix;
    }

    private void updateFont(String suffix) {
        Font existingFont;
        String sPrefix = this.sConfigID + ".text";
        Color color = this.properties.getColor(sPrefix + ".color" + suffix);
        if (color != null) {
            this.canvas.setData("color", (Object)color);
        }
        if ((existingFont = (Font)this.canvas.getData("Font" + suffix)) != null && !existingFont.isDisposed()) {
            this.canvas.setData("font", (Object)existingFont);
        } else {
            String sStyle;
            boolean bNewFont = false;
            int iFontSize = -1;
            int iFontWeight = -1;
            String sFontFace = null;
            String sSize = this.properties.getStringValue(sPrefix + ".size" + suffix);
            if (sSize != null) {
                FontData[] fd = this.canvas.getFont().getFontData();
                try {
                    char firstChar = sSize.charAt(0);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    }
                    double dSize = NumberFormat.getInstance(Locale.US).parse(sSize).doubleValue();
                    iFontSize = firstChar == '+' ? (int)((double)fd[0].height + dSize) : (firstChar == '-' ? (int)((double)fd[0].height - dSize) : (sSize.endsWith("px") ? Utils.pixelsToPoint(dSize, this.canvas.getDisplay().getDPI().y) : (int)dSize));
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if ((sStyle = this.properties.getStringValue(sPrefix + ".style" + suffix)) != null) {
                String[] sStyles = sStyle.toLowerCase().split(",");
                for (int i = 0; i < sStyles.length; ++i) {
                    String s = sStyles[i];
                    if (s.equals("bold")) {
                        iFontWeight = iFontWeight == -1 ? 1 : (iFontWeight |= 1);
                        bNewFont = true;
                    }
                    if (s.equals("italic")) {
                        iFontWeight = iFontWeight == -1 ? 2 : (iFontWeight |= 2);
                        bNewFont = true;
                    }
                    if (s.equals("underline")) {
                        this.canvas.addPaintListener(new PaintListener(){

                            public void paintControl(PaintEvent e) {
                                Point size = ((Control)e.widget).getSize();
                                e.gc.drawLine(0, size.y - 1, size.x - 1, size.y - 1);
                            }
                        });
                    }
                    if (!s.equals("strike")) continue;
                    this.canvas.addPaintListener(new PaintListener(){

                        public void paintControl(PaintEvent e) {
                            Point size = ((Control)e.widget).getSize();
                            int y = size.y / 2;
                            e.gc.drawLine(0, y, size.x - 1, y);
                        }
                    });
                }
            }
            if ((sFontFace = this.properties.getStringValue(sPrefix + ".font" + suffix)) != null) {
                bNewFont = true;
            }
            if (bNewFont) {
                FontData[] fd = this.canvas.getFont().getFontData();
                if (iFontSize > 0) {
                    fd[0].setHeight(iFontSize);
                }
                if (iFontWeight >= 0) {
                    fd[0].setStyle(iFontWeight);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font canvasFont = new Font((Device)this.canvas.getDisplay(), fd);
                this.canvas.setData("font", (Object)canvasFont);
                this.canvas.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        canvasFont.dispose();
                    }
                });
                this.canvas.setData("Font" + suffix, (Object)canvasFont);
            }
        }
        this.canvas.redraw();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.sText)) {
            return;
        }
        this.sText = text;
        this.sKey = null;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObjectText2.this.canvas.redraw();
                Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
            }
        });
    }

    public void paintControl(PaintEvent e) {
        if (this.sText == null || this.sText.length() == 0) {
            return;
        }
        Composite composite = (Composite)e.widget;
        Rectangle clientArea = composite.getClientArea();
        Font existingFont = (Font)this.canvas.getData("font");
        Color existingColor = (Color)this.canvas.getData("color");
        if (existingFont != null) {
            e.gc.setFont(existingFont);
        }
        if (existingColor != null) {
            e.gc.setForeground(existingColor);
        }
        GCStringPrinter.printString(e.gc, this.sText, clientArea, true, false, this.style | 0x80);
    }

    public void setTextID(String key) {
        if (key == null) {
            this.setText("");
        }
        if (key.equals(this.sKey)) {
            return;
        }
        this.sText = MessageText.getString(key);
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObjectText2.this.canvas.redraw();
                SWTSkinObjectText2.this.canvas.layout(true);
                Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
            }
        });
    }
}

