/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesParam;
import java.util.Properties;
import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.util.Debug;

public class SWTSkinPropertiesClone
implements SWTSkinPropertiesParam {
    private static final String IGNORE_NAME = ".type";
    private static final boolean DEBUG = true;
    private final SWTSkinProperties properties;
    private final String sCloneConfigID;
    private final String sTemplateConfigID;
    private final String[] sCloneParams;

    public SWTSkinPropertiesClone(SWTSkinProperties properties, String sCloneConfigID, String[] sCloneParams) {
        this.properties = properties;
        this.sCloneConfigID = sCloneConfigID;
        this.sCloneParams = sCloneParams;
        this.sTemplateConfigID = sCloneParams[0];
    }

    private void checkName(String name) {
        if (name.startsWith(this.sTemplateConfigID)) {
            System.err.println(name + " shouldn't have template prefix of " + this.sTemplateConfigID + "; " + Debug.getStackTrace(true, false));
        }
        if (name.startsWith(this.sCloneConfigID)) {
            System.err.println(name + " shouldn't have clone prefix of " + this.sCloneConfigID + "; " + Debug.getStackTrace(true, false));
        }
    }

    public void addProperty(String name, String value) {
        this.properties.addProperty(this.sCloneConfigID + name, value);
    }

    public Color getColor(String name) {
        this.checkName(name);
        Color val = this.properties.getColor(this.sCloneConfigID + name);
        if (val != null) {
            return val;
        }
        return this.properties.getColor(this.sTemplateConfigID + name);
    }

    public int[] getColorValue(String name) {
        int[] val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getColorValue(this.sCloneConfigID + name))[0] < 0) {
            return val;
        }
        return this.properties.getColorValue(this.sTemplateConfigID + name);
    }

    public int getIntValue(String name, int def) {
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && this.properties.getStringValue(this.sCloneConfigID + name) != null) {
            return this.properties.getIntValue(this.sCloneConfigID + name, def);
        }
        return this.properties.getIntValue(this.sTemplateConfigID + name, def);
    }

    public Properties getProperties() {
        return this.properties.getProperties();
    }

    public String[] getStringArray(String name) {
        String[] val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getStringArray(this.sCloneConfigID + name, this.sCloneParams)) != null) {
            return val;
        }
        return this.properties.getStringArray(this.sTemplateConfigID + name, this.sCloneParams);
    }

    public String getStringValue(String name, String def) {
        String val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getStringValue(this.sCloneConfigID + name, this.sCloneParams)) != null) {
            return val;
        }
        return this.properties.getStringValue(this.sTemplateConfigID + name, this.sCloneParams, def);
    }

    public String getStringValue(String name) {
        String val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getStringValue(this.sCloneConfigID + name, this.sCloneParams)) != null) {
            return val;
        }
        return this.properties.getStringValue(this.sTemplateConfigID + name, this.sCloneParams);
    }

    public String[] getStringArray(String name, String[] params) {
        String[] val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getStringArray(this.sCloneConfigID + name, params)) != null) {
            return val;
        }
        return this.properties.getStringArray(this.sTemplateConfigID + name, params);
    }

    public String getStringValue(String name, String[] params, String def) {
        String val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getStringValue(this.sCloneConfigID + name, params)) != null) {
            return val;
        }
        return this.properties.getStringValue(this.sTemplateConfigID + name, params, def);
    }

    public String getStringValue(String name, String[] params) {
        String val;
        this.checkName(name);
        if (!name.equals(IGNORE_NAME) && (val = this.properties.getStringValue(this.sCloneConfigID + name, params)) != null) {
            return val;
        }
        return this.properties.getStringValue(this.sTemplateConfigID + name, params);
    }

    public SWTSkinProperties getOriginalProperties() {
        return this.properties;
    }

    public String[] getParamValues() {
        return this.sCloneParams;
    }
}

