/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinTabSet {
    private Listener tabMouseListener;
    private final SWTSkin skin;
    private final SWTSkinProperties skinProperties;
    private final String sID;
    private SWTSkinObjectTab activeTab;
    private List tabs;
    private ArrayList listeners = new ArrayList();

    public SWTSkinTabSet(SWTSkin skin, String sID) {
        this.sID = sID;
        this.skin = skin;
        this.skinProperties = skin.getSkinProperties();
        this.tabs = new ArrayList();
    }

    public void addTab(SWTSkinObjectTab tab) {
        this.tabs.add(tab);
        tab.setTabset(this);
        this.addMouseListener(tab, tab.getControl());
        if (this.tabs.size() == 1) {
            this.setTabVisible(tab, false, tab.getActiveWidgets());
        } else {
            this.setTabVisible(tab, false, tab.getActiveWidgets());
        }
    }

    public SWTSkinObjectTab getActiveTab() {
        return this.activeTab;
    }

    public SWTSkinObjectTab[] getTabs() {
        return this.tabs.toArray(new SWTSkinObjectTab[0]);
    }

    public void clean() {
        if (this.tabs.size() > 0) {
            for (int i = this.tabs.size() - 1; i >= 0; --i) {
                SWTSkinObjectTab tab = (SWTSkinObjectTab)this.tabs.get(i);
                this.setTabVisible(tab, false, null);
                if (i != 0) continue;
                this.setActiveTab(tab);
            }
        }
    }

    public SWTSkinObjectTab getTab(String sID) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)this.tabs.get(i);
            String sTabID = tab.getSkinObjectID();
            if (!sTabID.equals(sID)) continue;
            return tab;
        }
        return null;
    }

    public boolean setActiveTab(String sID) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            String sTabID;
            SWTSkinObject tab = (SWTSkinObject)this.tabs.get(i);
            if (!(tab instanceof SWTSkinObjectTab) || !(sTabID = tab.getSkinObjectID()).equals(sID)) continue;
            this.setActiveTab((SWTSkinObjectTab)tab);
            return true;
        }
        return false;
    }

    public void setActiveTab(final SWTSkinObjectTab newTab) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!SWTSkinTabSet.this.tabs.contains(newTab)) {
                    System.err.println("No contain in " + SWTSkinTabSet.this.sID + ": " + newTab);
                    return;
                }
                String sOldID = SWTSkinTabSet.this.activeTab == null ? "" : SWTSkinTabSet.this.activeTab.getSkinObjectID();
                SWTSkinObject[] objects = SWTSkinTabSet.this.setTabVisible(newTab, true, null);
                if (newTab != SWTSkinTabSet.this.activeTab) {
                    if (SWTSkinTabSet.this.activeTab != null) {
                        SWTSkinTabSet.this.setTabVisible(SWTSkinTabSet.this.activeTab, false, objects);
                    }
                    SWTSkinTabSet.this.activeTab = newTab;
                } else {
                    System.err.println("Already on tab " + newTab + " in " + SWTSkinTabSet.this.sID);
                }
                String sConfigID = SWTSkinTabSet.this.activeTab.getConfigID();
                String sNewID = SWTSkinTabSet.this.activeTab.getSkinObjectID();
                SWTSkinObject parent = SWTSkinTabSet.this.skin.getSkinObject(SWTSkinTabSet.this.skinProperties.getStringValue(sConfigID + ".activate"));
                if (parent != null) {
                    parent.getControl().setFocus();
                }
                if (Constants.isOSX) {
                    boolean bHasSkinBrowser = false;
                    SWTSkinObject[] activeWidgets = SWTSkinTabSet.this.activeTab.getActiveWidgets();
                    for (int i = 0; i < activeWidgets.length; ++i) {
                        SWTSkinObject skinObject = activeWidgets[i];
                        if (!SWTSkinTabSet.this.hasSkinBrowser(skinObject)) continue;
                        bHasSkinBrowser = true;
                        break;
                    }
                    if (bHasSkinBrowser) {
                        Shell shell = SWTSkinTabSet.this.activeTab.getControl().getShell();
                        Point size = shell.getSize();
                        --size.x;
                        shell.setSize(size);
                        ++size.x;
                        shell.setSize(size);
                    }
                }
                SWTSkinTabSet.this.triggerChangeListener(sOldID, sNewID);
            }
        });
    }

    private boolean hasSkinBrowser(SWTSkinObject skinObject) {
        if (skinObject instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children = ((SWTSkinObjectContainer)skinObject).getChildren();
            for (int i = 0; i < children.length; ++i) {
                SWTSkinObject object = children[i];
                if (!this.hasSkinBrowser(object)) continue;
                return true;
            }
        }
        return skinObject instanceof SWTSkinObjectBrowser;
    }

    private void triggerChangeListener(String oldID, String newID) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            try {
                SWTSkinTabSetListener l = (SWTSkinTabSetListener)iter.next();
                l.tabChanged(this, oldID, newID);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void addMouseListener(SWTSkinObject tab, Control control) {
        if (this.tabMouseListener == null) {
            this.tabMouseListener = new Listener(){
                boolean bDownPressed = false;

                public void handleEvent(Event event2) {
                    if (event2.type == 3) {
                        this.bDownPressed = true;
                        return;
                    }
                    if (!this.bDownPressed) {
                        return;
                    }
                    this.bDownPressed = false;
                    Control control = (Control)event2.widget;
                    SWTSkinTabSet.this.setActiveTab((SWTSkinObjectTab)control.getData("Tab"));
                }
            };
        }
        control.setData("Tab", (Object)tab);
        control.addListener(4, this.tabMouseListener);
        control.addListener(3, this.tabMouseListener);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.addMouseListener(tab, children[i]);
            }
        }
    }

    private SWTSkinObject[] setTabVisible(SWTSkinObjectTab tab, boolean visible, SWTSkinObject[] skipObjects) {
        String sSkinID = tab.getSkinObjectID();
        SWTSkinObject swtObject = this.skin.getSkinObjectByID(sSkinID);
        if (swtObject == null) {
            return null;
        }
        String suffix = visible ? "-selected" : "";
        swtObject.switchSuffix(suffix, 1, true);
        tab.triggerListeners(2);
        SWTSkinObject[] activeWidgets = tab.getActiveWidgets();
        for (int i = 0; i < activeWidgets.length; ++i) {
            SWTSkinObject skinObject = activeWidgets[i];
            boolean ok = true;
            if (skipObjects != null) {
                for (int j = 0; j < skipObjects.length; ++j) {
                    if (!skinObject.equals(skipObjects[j])) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            skinObject.setVisible(visible);
        }
        return activeWidgets;
    }

    public void addListener(SWTSkinTabSetListener listener) {
        this.listeners.add(listener);
    }

    public String getID() {
        return this.sID;
    }

    protected static String[] getTemplateInfo(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        SWTSkinProperties skinProperties = skin.getSkinProperties();
        String sID = skinObject.getConfigID() + ".view.template." + sTemplateKey;
        return skinProperties.getStringArray(sID);
    }

    protected static String getTemplateID(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        String[] templateInfo = SWTSkinTabSet.getTemplateInfo(skin, skinObject, sTemplateKey);
        if (templateInfo != null) {
            return templateInfo[0];
        }
        return null;
    }

    public static String getTabSetID(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        String[] templateInfo = SWTSkinTabSet.getTemplateInfo(skin, skinObject, sTemplateKey);
        if (templateInfo != null && templateInfo.length > 1) {
            return templateInfo[1];
        }
        return null;
    }
}

