/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinImageChanger;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SWTSkinUtils {
    public static final int TILE_NONE = 0;
    public static final int TILE_Y = 1;
    public static final int TILE_X = 2;
    public static final int TILE_CENTER_X = 4;
    public static final int TILE_CENTER_Y = 8;
    public static final int TILE_BOTH = 3;
    private static Listener imageDownListener;
    private static Listener imageOverListener;

    public static int getAlignment(String sAlign, int def) {
        int align = sAlign.equalsIgnoreCase("center") ? 0x1000000 : (sAlign.equalsIgnoreCase("bottom") ? 1024 : (sAlign.equalsIgnoreCase("top") ? 128 : (sAlign.equalsIgnoreCase("left") ? 16384 : (sAlign.equalsIgnoreCase("right") ? 131072 : def))));
        return align;
    }

    public static int getTileMode(String sTileMode) {
        int tileMode = 0;
        if (sTileMode == null || sTileMode == "") {
            return tileMode;
        }
        if ((sTileMode = sTileMode.toLowerCase()).equals("tile")) {
            tileMode = 3;
        } else if (sTileMode.equals("tile-x")) {
            tileMode = 2;
        } else if (sTileMode.equals("tile-y")) {
            tileMode = 1;
        } else if (sTileMode.equals("center-x")) {
            tileMode = 4;
        } else if (sTileMode.equals("center-y")) {
            tileMode = 8;
        }
        return tileMode;
    }

    static void addMouseImageChangeListeners(Widget widget) {
        if (widget.getData("hasMICL") != null) {
            return;
        }
        widget.addListener(6, imageOverListener);
        widget.addListener(7, imageOverListener);
        widget.addListener(3, imageDownListener);
        widget.addListener(4, imageDownListener);
        widget.setData("hasMICL", (Object)"1");
    }

    static {
        imageOverListener = new SWTSkinImageChanger("-over", 6, 7);
        imageDownListener = new SWTSkinImageChanger("-down", 3, 4);
    }

    public static class MouseEnterExitListener
    implements Listener {
        boolean bOver = false;

        public MouseEnterExitListener(Widget widget) {
            widget.addListener(5, (Listener)this);
            widget.addListener(7, (Listener)this);
        }

        public void handleEvent(Event event2) {
            Control control = (Control)event2.widget;
            SWTSkinObject skinObject = (SWTSkinObject)control.getData("SkinObject");
            if (event2.type == 5) {
                if (this.bOver) {
                    return;
                }
                System.out.println(System.currentTimeMillis() + ": " + skinObject + "-- OVER");
                this.bOver = true;
                skinObject.switchSuffix("-over", 2, true);
            } else {
                this.bOver = false;
                skinObject.switchSuffix("", 2, true);
            }
        }
    }
}

