/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class SWTTextPaintListener
implements PaintListener {
    private int align;
    private Color bgcolor;
    private Color fgcolor;
    private Font font;
    private String text;
    private SWTSkinProperties skinProperties;

    public SWTTextPaintListener(SWTSkin skin, Control createOn, String sConfigID) {
        String sSize;
        this.skinProperties = skin.getSkinProperties();
        this.bgcolor = this.skinProperties.getColor(sConfigID + ".color");
        this.text = this.skinProperties.getStringValue(sConfigID + ".text");
        this.fgcolor = this.skinProperties.getColor(sConfigID + ".text.color");
        this.align = 0;
        String sAlign = this.skinProperties.getStringValue(sConfigID + ".align");
        if (sAlign != null) {
            this.align = SWTSkinUtils.getAlignment(sAlign, 0);
        }
        if ((sSize = this.skinProperties.getStringValue(sConfigID + ".text.size")) != null) {
            FontData[] fd = createOn.getFont().getFontData();
            try {
                char firstChar = sSize.charAt(0);
                if (firstChar == '+' || firstChar == '-') {
                    sSize = sSize.substring(1);
                }
                int iSize = Integer.parseInt(sSize);
                fd[0].height = firstChar == '+' ? (fd[0].height += iSize) : (firstChar == '-' ? (fd[0].height -= iSize) : iSize);
                this.font = new Font((Device)createOn.getDisplay(), fd);
                createOn.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        SWTTextPaintListener.this.font.dispose();
                    }
                });
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void paintControl(PaintEvent e) {
        e.gc.setClipping(e.x, e.y, e.width, e.height);
        if (this.bgcolor != null) {
            e.gc.setBackground(this.bgcolor);
        }
        if (this.fgcolor != null) {
            e.gc.setForeground(this.fgcolor);
        }
        if (this.font != null) {
            e.gc.setFont(this.font);
        }
        if (this.text != null) {
            Rectangle clientArea = ((Composite)e.widget).getClientArea();
            GCStringPrinter.printString(e.gc, this.text, clientArea, true, true, this.align);
        }
    }
}

