/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.gudy.azureus2.core3.util.Debug;

public class ColorCache {
    private static final Map mapColors = new HashMap();

    public static Color getColor(Device device, int red, int green, int blue) {
        Long key;
        Color color;
        if (mapColors.size() == 0) {
            for (int i = 1; i <= 16; ++i) {
                color = device.getSystemColor(i);
                Long key2 = new Long(((long)color.getRed() << 16) + (long)(color.getGreen() << 8) + (long)color.getBlue());
                ColorCache.addColor(key2, color);
            }
        }
        if ((color = (Color)mapColors.get(key = new Long(((long)red << 16) + (long)(green << 8) + (long)blue))) == null) {
            try {
                color = new Color(device, red, green, blue);
            }
            catch (IllegalArgumentException e) {
                Debug.out("One Invalid: " + red + ";" + green + ";" + blue, e);
            }
            ColorCache.addColor(key, color);
        }
        return color;
    }

    public static Color getColor(Device device, String value) {
        int[] colors = new int[3];
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            if (value.charAt(0) == '#') {
                long l = Long.parseLong(value.substring(1), 16);
                colors[0] = (int)(l >> 16 & 0xFFL);
                colors[1] = (int)(l >> 8 & 0xFFL);
                colors[2] = (int)(l & 0xFFL);
            } else {
                StringTokenizer st = new StringTokenizer(value, ",");
                colors[0] = Integer.parseInt(st.nextToken());
                colors[1] = Integer.parseInt(st.nextToken());
                colors[2] = Integer.parseInt(st.nextToken());
            }
        }
        catch (Exception e) {
            Debug.out(value, e);
            return null;
        }
        return ColorCache.getColor(device, colors[0], colors[1], colors[2]);
    }

    private static void addColor(Long key, Color color) {
        mapColors.put(key, color);
    }
}

