/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.ui.skin.SkinProperties;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageLoader {
    private Display display;
    public static Image noImage;
    private final Map mapImages = new HashMap();
    private final ArrayList notFound = new ArrayList();
    private SkinProperties skinProperties;

    public ImageLoader(Display display, SkinProperties skinProperties) {
        this.display = display;
        this.skinProperties = skinProperties;
    }

    private Image loadImage(Display display, String key) {
        return this.loadImage(display, this.skinProperties.getStringValue(key), key);
    }

    private Image[] findResources(String sKey) {
        int i;
        if (Collections.binarySearch(this.notFound, sKey) >= 0) {
            return null;
        }
        String[] sSuffixChecks = new String[]{"-over", "-down", "-disabled"};
        for (i = 0; i < sSuffixChecks.length; ++i) {
            String sParentName;
            String[] sParentFiles;
            String sSuffix = sSuffixChecks[i];
            if (!sKey.endsWith(sSuffix) || (sParentFiles = this.skinProperties.getStringArray(sParentName = sKey.substring(0, sKey.length() - sSuffix.length()))) == null) continue;
            boolean bFoundOne = false;
            Image[] images = new Image[sParentFiles.length];
            for (int j = 0; j < sParentFiles.length; ++j) {
                int index = sParentFiles[j].lastIndexOf(46);
                if (index <= 0) continue;
                String sTryFile = sParentFiles[j].substring(0, index) + sSuffix + sParentFiles[j].substring(index);
                images[j] = this.loadImage(this.display, sTryFile, sKey);
                if (images[j] == null) {
                    sTryFile = sParentFiles[j].substring(0, index) + sSuffix.replace('-', '_') + sParentFiles[j].substring(index);
                    images[j] = this.loadImage(this.display, sTryFile, sKey);
                }
                if (bFoundOne || images[j] == null) continue;
                bFoundOne = true;
            }
            if (!bFoundOne) continue;
            return images;
        }
        i = Collections.binarySearch(this.notFound, sKey) * -1 - 1;
        this.notFound.add(i, sKey);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image loadImage(Display display, String res, String sKey) {
        Image img = null;
        if (res == null) {
            String sTryFile;
            int index;
            String sParentName;
            String sParentFile;
            String sSuffix;
            String[] sSuffixChecks = new String[]{"-over", "-down", "-disabled"};
            for (int i = 0; i < sSuffixChecks.length && (!sKey.endsWith(sSuffix = sSuffixChecks[i]) || (sParentFile = this.skinProperties.getStringValue(sParentName = sKey.substring(0, sKey.length() - sSuffix.length()))) == null || (index = sParentFile.lastIndexOf(46)) <= 0 || (img = this.loadImage(display, sTryFile = sParentFile.substring(0, index) + sSuffix + sParentFile.substring(index), sKey)) == null && (img = this.loadImage(display, sTryFile = sParentFile.substring(0, index) + sSuffix.replace('-', '_') + sParentFile.substring(index), sKey)) == null); ++i) {
            }
        }
        if (img != null) return img;
        try {
            InputStream is = ImageLoader.class.getClassLoader().getResourceAsStream(res);
            if (is != null) {
                img = new Image((Device)display, is);
            }
            if (img != null) return img;
        }
        catch (Throwable e) {
            System.err.println("ImageRepository:loadImage:: Resource not found: " + res + "\n" + e);
        }
        return img;
    }

    public void unLoadImages() {
        Iterator iter = this.mapImages.values().iterator();
        while (iter.hasNext()) {
            Image[] images = (Image[])iter.next();
            if (images == null) continue;
            for (int i = 0; i < images.length; ++i) {
                Image image = images[i];
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
        }
    }

    public Image[] getImages(String sKey) {
        if (sKey == null) {
            return new Image[]{ImageLoader.getNoImage()};
        }
        Image[] images = (Image[])this.mapImages.get(sKey);
        if (images != null) {
            return images;
        }
        String[] locations = this.skinProperties.getStringArray(sKey);
        if (locations == null || locations.length == 0) {
            images = this.findResources(sKey);
            if (images == null) {
                return new Image[]{ImageLoader.getNoImage()};
            }
            for (int i = 0; i < images.length; ++i) {
                if (images[i] != null) continue;
                images[i] = ImageLoader.getNoImage();
            }
        } else {
            images = new Image[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                images[i] = this.loadImage(this.display, locations[i], sKey);
                if (images[i] != null) continue;
                images[i] = ImageLoader.getNoImage();
            }
        }
        this.mapImages.put(sKey, images);
        return images;
    }

    public Image getImage(String sKey) {
        Image[] images = this.getImages(sKey);
        if (images == null || images.length == 0) {
            return null;
        }
        return images[0];
    }

    private static Image getNoImage() {
        if (noImage == null) {
            Display display = Display.getDefault();
            int SIZE = 10;
            noImage = new Image((Device)display, 10, 10);
            GC gc = new GC((Drawable)noImage);
            gc.setBackground(display.getSystemColor(7));
            gc.fillRectangle(0, 0, 10, 10);
            gc.setBackground(display.getSystemColor(3));
            gc.drawRectangle(0, 0, 9, 9);
            gc.dispose();
        }
        return noImage;
    }

    public boolean imageExists(String name) {
        return ImageLoader.isRealImage(this.getImage(name));
    }

    public static boolean isRealImage(Image image) {
        return image != null && image != ImageLoader.getNoImage();
    }
}

